/*
 * Decompiled with CFR 0.152.
 */
package org.classpath.icedtea.pulseaudio;

import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.Port;
import org.classpath.icedtea.pulseaudio.EventLoop;
import org.classpath.icedtea.pulseaudio.Operation;
import org.classpath.icedtea.pulseaudio.PulseAudioLine;
import org.classpath.icedtea.pulseaudio.PulseAudioPlaybackLine;
import org.classpath.icedtea.pulseaudio.PulseAudioVolumeControl;
import org.classpath.icedtea.pulseaudio.SecurityWrapper;

abstract class PulseAudioPort
extends PulseAudioLine
implements Port,
PulseAudioPlaybackLine {
    private String name;
    private byte[] contextPointer;
    private int channels;
    private EventLoop eventLoop;
    private float cachedVolume;
    private PulseAudioVolumeControl volumeControl;

    PulseAudioPort(String string) {
        this.name = string;
        this.eventLoop = EventLoop.getEventLoop();
        this.contextPointer = this.eventLoop.getContextPointer();
        this.updateVolumeInfo();
        this.volumeControl = new PulseAudioVolumeControl(this, this.eventLoop);
        this.controls.add(this.volumeControl);
        this.open();
    }

    public abstract byte[] native_set_volume(float var1);

    public abstract byte[] native_update_volume();

    public float getCachedVolume() {
        return this.cachedVolume;
    }

    public void setCachedVolume(float f) {
        this.cachedVolume = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateVolumeInfo() {
        Operation operation;
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            operation = new Operation(this.native_update_volume());
        }
        operation.waitForCompletion();
        operation.releaseReference();
    }

    void update_channels_and_volume(int n, float f) {
        this.channels = n;
        this.cachedVolume = f;
    }

    public void close() {
        this.native_set_volume(0.0f);
        this.isOpen = false;
        this.fireLineEvent(new LineEvent(this, LineEvent.Type.CLOSE, -1L));
    }

    public abstract Line.Info getLineInfo();

    public void open() {
        if (this.isOpen) {
            return;
        }
        this.native_set_volume(this.cachedVolume);
        this.isOpen = true;
        this.fireLineEvent(new LineEvent(this, LineEvent.Type.OPEN, -1L));
    }

    public String getName() {
        return this.name;
    }

    static {
        SecurityWrapper.loadNativeLibrary();
    }
}

