/*
 * Decompiled with CFR 0.152.
 */
package org.classpath.icedtea.pulseaudio;

import java.util.Arrays;
import org.classpath.icedtea.pulseaudio.EventLoop;
import org.classpath.icedtea.pulseaudio.SecurityWrapper;

class Operation {
    private byte[] operationPointer;
    private EventLoop eventLoop;
    public static long RUNNING = -1L;
    public static long DONE = -1L;
    public static long CANCELLED = -1L;

    private static native void init_constants();

    private static long checkNativeOperationState(long l) {
        if (!Arrays.asList(RUNNING, DONE, CANCELLED).contains(l)) {
            throw new IllegalStateException("Unknown operation state: " + l);
        }
        return l;
    }

    private native void native_ref();

    private native void native_unref();

    private native long native_get_state();

    Operation(byte[] byArray) {
        assert (byArray != null);
        this.operationPointer = byArray;
        this.eventLoop = EventLoop.getEventLoop();
    }

    protected void finalize() throws Throwable {
        assert (this.operationPointer == null);
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addReference() {
        assert (this.operationPointer != null);
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            this.native_ref();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseReference() {
        assert (this.operationPointer != null);
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            this.native_unref();
        }
        this.operationPointer = null;
    }

    boolean isNull() {
        return this.operationPointer == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getState() {
        assert (this.operationPointer != null);
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            return Operation.checkNativeOperationState(this.native_get_state());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForCompletion() {
        assert (this.operationPointer != null);
        boolean bl = false;
        do {
            Object object = this.eventLoop.threadLock;
            synchronized (object) {
                if (this.getState() == DONE) {
                    return;
                }
                try {
                    this.eventLoop.threadLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                }
            }
        } while (this.getState() != DONE);
        if (bl) {
            Thread.currentThread().interrupt();
        }
    }

    static {
        SecurityWrapper.loadNativeLibrary();
        Operation.init_constants();
    }
}

