/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.main;

import org.herac.tuxguitar.app.action.TGActionProcessorListener;
import org.herac.tuxguitar.app.system.config.TGConfigManager;
import org.herac.tuxguitar.app.system.icons.TGIconManager;
import org.herac.tuxguitar.app.system.icons.TGSkinManager;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.component.tabfolder.TGTabFolder;
import org.herac.tuxguitar.app.view.component.table.TGTableViewer;
import org.herac.tuxguitar.app.view.dialog.fretboard.TGFretBoardEditor;
import org.herac.tuxguitar.app.view.main.TGWindowDivider;
import org.herac.tuxguitar.app.view.main.TGWindowLayout;
import org.herac.tuxguitar.app.view.toolbar.edit.TGEditToolBar;
import org.herac.tuxguitar.app.view.toolbar.main.TGMainToolBar;
import org.herac.tuxguitar.app.view.util.TGCursorController;
import org.herac.tuxguitar.app.view.util.TGSyncProcess;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UICloseListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.resource.UICursor;
import org.herac.tuxguitar.ui.resource.UIRectangle;
import org.herac.tuxguitar.ui.resource.UISize;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGExpressionResolver;
import org.herac.tuxguitar.util.TGSynchronizer;
import org.herac.tuxguitar.util.singleton.TGSingletonFactory;
import org.herac.tuxguitar.util.singleton.TGSingletonUtil;

public class TGWindow
implements TGEventListener {
    private TGContext context;
    private TGSyncProcess loadTitleProcess;
    private TGCursorController cursorController;
    private UIWindow window;

    public TGWindow(TGContext context) {
        this.context = context;
        this.createSyncProcesses();
    }

    public void open() {
        if (this.window != null) {
            this.window.open();
            this.window.layout();
        }
    }

    public void createWindow() {
        UIFactory uiFactory = TGApplication.getInstance(this.context).getFactory();
        this.window = uiFactory.createWindow();
        this.window.addCloseListener((UICloseListener)new TGActionProcessorListener(this.context, "action.system.dispose"));
        this.createShellComposites(uiFactory);
        this.createShellListeners();
        this.loadIcons();
        this.loadInitialBounds();
    }

    private void createShellComposites(UIFactory uiFactory) {
        TGConfigManager tgConfig = TGConfigManager.getInstance(this.context);
        TGMainToolBar tgToolBar = TGMainToolBar.getInstance(this.context);
        tgToolBar.createToolBar((UIContainer)this.window, tgConfig.getBooleanValue("show.main-toolbar"));
        UITableLayout topContainerLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel topContainer = uiFactory.createPanel((UIContainer)this.window, false);
        topContainer.setLayout((UILayout)topContainerLayout);
        topContainerLayout.set("ignore_invisible", (Object)true);
        TGEditToolBar tgEditToolBar = TGEditToolBar.getInstance(this.context);
        tgEditToolBar.createToolBar((UIContainer)topContainer, tgConfig.getBooleanValue("show.edit-toolbar"));
        topContainerLayout.set((UIControl)tgEditToolBar.getControl(), Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), null, null, Float.valueOf(0.0f));
        topContainerLayout.set((UIControl)tgEditToolBar.getControl(), "packed_height", (Object)Float.valueOf(0.0f));
        TGTabFolder tgTabFolder = TGTabFolder.getInstance(this.context);
        tgTabFolder.init((UIContainer)topContainer);
        topContainerLayout.set((UIControl)tgTabFolder.getControl(), Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), null, null, Float.valueOf(0.0f));
        topContainerLayout.set((UIControl)tgTabFolder.getControl(), "packed_height", (Object)Float.valueOf(0.0f));
        TGWindowDivider tgWindowDivider = new TGWindowDivider(this.context);
        tgWindowDivider.createDivider((UIContainer)this.window);
        TGTableViewer tgTableViewer = TGTableViewer.getInstance(this.context);
        tgTableViewer.init((UIContainer)this.window);
        UIPanel bottom = uiFactory.createPanel((UIContainer)this.window, false);
        bottom.setLayout((UILayout)new UITableLayout(Float.valueOf(0.0f)));
        bottom.getLayout().set("ignore_invisible", (Object)true);
        TGFretBoardEditor tgFretBoardEditor = TGFretBoardEditor.getInstance(this.context);
        tgFretBoardEditor.createFretBoard(bottom, tgConfig.getBooleanValue("show.fretboard"));
        this.window.setLayout((UILayout)new TGWindowLayout((UIControl)tgToolBar.getControl(), (UIControl)topContainer, (UIControl)tgWindowDivider.getControl(), (UIControl)tgTableViewer.getControl(), (UIControl)bottom));
    }

    private void loadInitialBounds() {
        TGConfigManager config = TGConfigManager.getInstance(this.context);
        boolean maximized = config.getBooleanValue("window.maximized");
        if (maximized) {
            this.window.maximize();
        } else {
            float width = config.getFloatValue("window.width");
            float height = config.getFloatValue("window.height");
            if (width > 0.0f && height > 0.0f) {
                UIRectangle uiRectangle = new UIRectangle();
                uiRectangle.setSize(new UISize(width, height));
                this.window.setBounds(uiRectangle);
            }
        }
    }

    private void createShellListeners() {
        TGSkinManager tgSkinManager = TGSkinManager.getInstance(this.context);
        tgSkinManager.addLoader(this);
    }

    public void loadDefaultCursor() {
        this.loadCursor(UICursor.NORMAL);
    }

    public void loadBusyCursor() {
        this.loadCursor(UICursor.WAIT);
    }

    public void loadCursor(UICursor cursor) {
        if (!this.isDisposed()) {
            if (this.cursorController == null || !this.cursorController.isControlling((UIControl)this.getWindow())) {
                this.cursorController = new TGCursorController(this.context, (UIControl)this.getWindow());
            }
            this.cursorController.loadCursor(cursor);
        }
    }

    public void moveToTop() {
        if (!this.isDisposed()) {
            this.getWindow().moveToTop();
        }
    }

    public boolean isDisposed() {
        return this.getWindow() == null || this.getWindow().isDisposed();
    }

    public UIWindow getWindow() {
        return this.window;
    }

    public void loadTitle() {
        this.loadTitleProcess.process();
    }

    public void loadTitleInCurrentThread() {
        if (!this.isDisposed()) {
            String titleLayout = TGConfigManager.getInstance(this.context).getStringValue("window.title");
            String title = TGExpressionResolver.getInstance((TGContext)this.context).resolve(titleLayout);
            this.window.setText(title != null ? title : "TuxGuitar");
        }
    }

    public void loadIcons() {
        if (!this.isDisposed()) {
            this.getWindow().setImage(TGIconManager.getInstance(this.context).getAppIcon());
            this.getWindow().layout();
        }
    }

    public void createSyncProcesses() {
        this.loadTitleProcess = new TGSyncProcess(this.context, new Runnable(){

            @Override
            public void run() {
                TGWindow.this.loadTitleInCurrentThread();
            }
        });
    }

    public void processEvent(final TGEvent event) {
        TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){

            @Override
            public void run() {
                if ("ui-skin".equals(event.getEventType())) {
                    TGWindow.this.loadIcons();
                }
            }
        });
    }

    public static TGWindow getInstance(TGContext context) {
        return (TGWindow)TGSingletonUtil.getInstance((TGContext)context, (String)TGWindow.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGWindow>(){

            public TGWindow createInstance(TGContext context) {
                return new TGWindow(context);
            }
        });
    }
}

