/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.track;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.system.icons.TGIconManager;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.util.TGMessageDialogUtil;
import org.herac.tuxguitar.app.util.TGMusicKeyUtils;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.app.view.dialog.track.TGTrackTuningChooserDialog;
import org.herac.tuxguitar.app.view.dialog.track.TGTrackTuningChooserHandler;
import org.herac.tuxguitar.app.view.dialog.track.TGTrackTuningModel;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.app.view.util.TGSyncProcessLocked;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UIMouseDoubleClickListener;
import org.herac.tuxguitar.ui.event.UIMouseEvent;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UICheckBox;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UIDropDownSelect;
import org.herac.tuxguitar.ui.widget.UILabel;
import org.herac.tuxguitar.ui.widget.UILayoutContainer;
import org.herac.tuxguitar.ui.widget.UILegendPanel;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UISelectItem;
import org.herac.tuxguitar.ui.widget.UITable;
import org.herac.tuxguitar.ui.widget.UITableItem;
import org.herac.tuxguitar.ui.widget.UIWindow;

public class TGTrackTuningDialog {
    private static final String[] NOTE_NAMES = TGMusicKeyUtils.getSharpKeyNames("tuning");
    private static final float MINIMUM_BUTTON_WIDTH = 80.0f;
    private static final float MINIMUM_BUTTON_HEIGHT = 25.0f;
    private static final int MAX_OCTAVES = 10;
    private static final int MAX_NOTES = 12;
    private TGViewContext context;
    private UIWindow dialog;
    private List<TGTrackTuningModel> tuning;
    private List<TGTrackTuningModel[]> tuningPresets;
    private UITable<TGTrackTuningModel> tuningTable;
    private UIDropDownSelect<TGTrackTuningModel[]> tuningPresetsSelect;
    private UICheckBox stringTransposition;
    private UICheckBox stringTranspositionTryKeepString;
    private UICheckBox stringTranspositionApplyToChords;
    private UIDropDownSelect<Integer> offsetCombo;

    public TGTrackTuningDialog(TGViewContext context) {
        this.context = context;
        this.tuning = new ArrayList<TGTrackTuningModel>();
        this.tuningPresets = new ArrayList<TGTrackTuningModel[]>();
    }

    public void show() {
        TGTrack track;
        TGSongManager songManager = this.findSongManager();
        if (!songManager.isPercussionChannel((track = this.findTrack()).getSong(), track.getChannelId())) {
            UIFactory factory = this.getUIFactory();
            UIWindow parent = (UIWindow)this.context.getAttribute("parent");
            UITableLayout dialogLayout = new UITableLayout();
            this.dialog = factory.createWindow(parent, true, false);
            this.dialog.setLayout((UILayout)dialogLayout);
            this.dialog.setText(TuxGuitar.getProperty("tuning"));
            UITableLayout leftPanelLayout = new UITableLayout();
            UILegendPanel leftPanel = factory.createLegendPanel((UIContainer)this.dialog);
            leftPanel.setLayout((UILayout)leftPanelLayout);
            leftPanel.setText(TuxGuitar.getProperty("tuning.strings"));
            dialogLayout.set((UIControl)leftPanel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            UITableLayout rightPanelLayout = new UITableLayout();
            UILegendPanel rightPanel = factory.createLegendPanel((UIContainer)this.dialog);
            rightPanel.setLayout((UILayout)rightPanelLayout);
            rightPanel.setText(TuxGuitar.getProperty("options"));
            dialogLayout.set((UIControl)rightPanel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            UITableLayout bottomPanelLayout = new UITableLayout(Float.valueOf(0.0f));
            UIPanel bottomPanel = factory.createPanel((UIContainer)this.dialog, false);
            bottomPanel.setLayout((UILayout)bottomPanelLayout);
            dialogLayout.set((UIControl)bottomPanel, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(2));
            this.initTuningTable((UILayoutContainer)leftPanel);
            this.initTuningOptions((UILayoutContainer)rightPanel, track);
            this.initButtons((UILayoutContainer)bottomPanel);
            this.updateTuningFromTrack(track);
            TGDialogUtil.openDialog(this.dialog, 5);
        }
    }

    private void initTuningTable(UILayoutContainer parent) {
        UIFactory factory = this.getUIFactory();
        UITableLayout parentLayout = (UITableLayout)parent.getLayout();
        UITableLayout panelLayout = new UITableLayout();
        UIPanel panel = factory.createPanel((UIContainer)parent, false);
        panel.setLayout((UILayout)panelLayout);
        parentLayout.set((UIControl)panel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.createTuningPresets();
        this.tuningPresetsSelect = factory.createDropDownSelect((UIContainer)panel);
        panelLayout.set(this.tuningPresetsSelect, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(false));
        this.tuningPresetsSelect.addItem(new UISelectItem(TuxGuitar.getProperty("tuning.preset.select")));
        for (TGTrackTuningModel[] tuningPreset : this.tuningPresets) {
            this.tuningPresetsSelect.addItem(new UISelectItem(this.createTuningPresetLabel(tuningPreset), (Object)tuningPreset));
        }
        this.tuningPresetsSelect.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGTrackTuningDialog.this.onSelectPreset();
            }
        });
        this.tuningTable = factory.createTable((UIContainer)panel, true);
        this.tuningTable.setColumns(2);
        this.tuningTable.setColumnName(0, TuxGuitar.getProperty("tuning.label"));
        this.tuningTable.setColumnName(1, TuxGuitar.getProperty("tuning.value"));
        this.tuningTable.addMouseDoubleClickListener(new UIMouseDoubleClickListener(){

            public void onMouseDoubleClick(UIMouseEvent event) {
                TGTrackTuningDialog.this.onEditTuningModel();
            }
        });
        panelLayout.set(this.tuningTable, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_TOP, Boolean.valueOf(true), Boolean.valueOf(true));
        panelLayout.set(this.tuningTable, "packed_width", (Object)Float.valueOf(250.0f));
        panelLayout.set(this.tuningTable, "packed_height", (Object)Float.valueOf(200.0f));
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttonsPanel = factory.createPanel((UIContainer)panel, false);
        buttonsPanel.setLayout((UILayout)buttonsLayout);
        panelLayout.set((UIControl)buttonsPanel, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), null, null, Float.valueOf(0.0f));
        UIButton buttonAdd = factory.createButton((UIContainer)buttonsPanel);
        buttonAdd.setImage(TGIconManager.getInstance(this.context.getContext()).getListAdd());
        buttonAdd.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGTrackTuningDialog.this.onAddTuningModel();
            }
        });
        UIButton buttonEdit = factory.createButton((UIContainer)buttonsPanel);
        buttonEdit.setImage(TGIconManager.getInstance(this.context.getContext()).getListEdit());
        buttonEdit.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGTrackTuningDialog.this.onEditTuningModel();
            }
        });
        UIButton buttonDelete = factory.createButton((UIContainer)buttonsPanel);
        buttonDelete.setImage(TGIconManager.getInstance(this.context.getContext()).getListRemove());
        buttonDelete.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGTrackTuningDialog.this.onRemoveTuningModel();
            }
        });
        buttonsLayout.set((UIControl)buttonAdd, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
        buttonsLayout.set((UIControl)buttonDelete, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
        buttonsLayout.set((UIControl)buttonEdit, Integer.valueOf(1), Integer.valueOf(3), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(false));
    }

    private void initTuningOptions(UILayoutContainer parent, TGTrack track) {
        UIFactory factory = this.getUIFactory();
        UITableLayout parentLayout = (UITableLayout)parent.getLayout();
        UITableLayout panelLayout = new UITableLayout();
        UIPanel panel = factory.createPanel((UIContainer)parent, false);
        panel.setLayout((UILayout)panelLayout);
        parentLayout.set((UIControl)panel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UITableLayout topLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel top = factory.createPanel((UIContainer)panel, false);
        top.setLayout((UILayout)topLayout);
        panelLayout.set((UIControl)top, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_TOP, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), null, null, Float.valueOf(0.0f));
        UITableLayout bottomLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel bottom = factory.createPanel((UIContainer)panel, false);
        bottom.setLayout((UILayout)bottomLayout);
        panelLayout.set((UIControl)bottom, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_BOTTOM, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), null, null, Float.valueOf(0.0f));
        UILabel offsetLabel = factory.createLabel((UIContainer)top);
        offsetLabel.setText(TuxGuitar.getProperty("tuning.offset") + ":");
        topLayout.set((UIControl)offsetLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        this.offsetCombo = factory.createDropDownSelect((UIContainer)top);
        for (int i = -24; i <= 24; ++i) {
            this.offsetCombo.addItem(new UISelectItem(Integer.toString(i), (Object)i));
        }
        this.offsetCombo.setSelectedValue((Object)track.getOffset());
        topLayout.set(this.offsetCombo, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        this.stringTransposition = factory.createCheckBox((UIContainer)bottom);
        this.stringTransposition.setText(TuxGuitar.getProperty("tuning.strings.transpose"));
        this.stringTransposition.setSelected(true);
        bottomLayout.set((UIControl)this.stringTransposition, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        this.stringTranspositionApplyToChords = factory.createCheckBox((UIContainer)bottom);
        this.stringTranspositionApplyToChords.setText(TuxGuitar.getProperty("tuning.strings.transpose.apply-to-chords"));
        this.stringTranspositionApplyToChords.setSelected(true);
        bottomLayout.set((UIControl)this.stringTranspositionApplyToChords, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        this.stringTranspositionTryKeepString = factory.createCheckBox((UIContainer)bottom);
        this.stringTranspositionTryKeepString.setText(TuxGuitar.getProperty("tuning.strings.transpose.try-keep-strings"));
        this.stringTranspositionTryKeepString.setSelected(true);
        bottomLayout.set((UIControl)this.stringTranspositionTryKeepString, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        this.stringTransposition.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                UICheckBox stringTransposition = TGTrackTuningDialog.this.stringTransposition;
                UICheckBox stringTranspositionApplyToChords = TGTrackTuningDialog.this.stringTranspositionApplyToChords;
                UICheckBox stringTranspositionTryKeepString = TGTrackTuningDialog.this.stringTranspositionTryKeepString;
                stringTranspositionApplyToChords.setEnabled(stringTransposition.isEnabled() && stringTransposition.isSelected());
                stringTranspositionTryKeepString.setEnabled(stringTransposition.isEnabled() && stringTransposition.isSelected());
            }
        });
    }

    private void initButtons(UILayoutContainer parent) {
        UIFactory factory = this.getUIFactory();
        UITableLayout parentLayout = (UITableLayout)parent.getLayout();
        UIButton buttonOK = factory.createButton((UIContainer)parent);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setDefaultButton();
        buttonOK.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                new TGSyncProcessLocked(TGTrackTuningDialog.this.getContext().getContext(), new Runnable(){

                    @Override
                    public void run() {
                        if (TGTrackTuningDialog.this.updateTrackTuning()) {
                            TGTrackTuningDialog.this.dialog.dispose();
                        }
                    }
                }).process();
            }
        });
        parentLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonCancel = factory.createButton((UIContainer)parent);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGTrackTuningDialog.this.dialog.dispose();
            }
        });
        parentLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        parentLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
    }

    private void onSelectPreset() {
        TGTrackTuningModel[] models = (TGTrackTuningModel[])this.tuningPresetsSelect.getSelectedValue();
        if (models != null) {
            this.updateTuningFromPreset(models);
        }
    }

    private void onAddTuningModel() {
        new TGTrackTuningChooserDialog(this).select(new TGTrackTuningChooserHandler(){

            @Override
            public void handleSelection(TGTrackTuningModel model) {
                TGTrackTuningDialog.this.addTuningModel(model);
            }
        });
    }

    private void onEditTuningModel() {
        final TGTrackTuningModel editingModel = (TGTrackTuningModel)this.tuningTable.getSelectedValue();
        if (editingModel != null) {
            new TGTrackTuningChooserDialog(this).select(new TGTrackTuningChooserHandler(){

                @Override
                public void handleSelection(TGTrackTuningModel model) {
                    editingModel.setValue(model.getValue());
                    TGTrackTuningDialog.this.updateTuningControls();
                }
            }, editingModel);
        }
    }

    private void onRemoveTuningModel() {
        TGTrackTuningModel model = (TGTrackTuningModel)this.tuningTable.getSelectedValue();
        if (model != null) {
            this.removeTuningModel(model);
        }
    }

    private boolean isUsingPreset(TGTrackTuningModel[] preset) {
        if (this.tuning.size() == preset.length) {
            for (int i = 0; i < this.tuning.size(); ++i) {
                if (this.tuning.get(i).getValue().equals(preset[i].getValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void updateTuningPresetSelection() {
        TGTrackTuningModel[] selection = null;
        for (TGTrackTuningModel[] preset : this.tuningPresets) {
            if (!this.isUsingPreset(preset)) continue;
            selection = preset;
        }
        this.tuningPresetsSelect.setIgnoreEvents(true);
        this.tuningPresetsSelect.setSelectedValue(selection);
        this.tuningPresetsSelect.setIgnoreEvents(false);
    }

    private void updateTuningTable() {
        TGTrackTuningModel selection = (TGTrackTuningModel)this.tuningTable.getSelectedValue();
        this.tuningTable.removeItems();
        for (TGTrackTuningModel model : this.tuning) {
            UITableItem item = new UITableItem((Object)model);
            item.setText(0, this.getValueLabel(model.getValue()));
            item.setText(1, this.getValueLabel(model.getValue(), true));
            this.tuningTable.addItem(item);
        }
        if (selection != null) {
            this.tuningTable.setSelectedValue((Object)selection);
        }
    }

    private void updateTuningControls() {
        this.updateTuningTable();
        this.updateTuningPresetSelection();
    }

    private void updateTuningFromTrack(TGTrack track) {
        this.tuning.clear();
        for (int i = 0; i < track.stringCount(); ++i) {
            TGString string = track.getString(i + 1);
            TGTrackTuningModel model = new TGTrackTuningModel();
            model.setValue(string.getValue());
            this.tuning.add(model);
        }
        this.updateTuningControls();
    }

    private void addTuningModel(TGTrackTuningModel model) {
        if (this.tuning.add(model)) {
            this.updateTuningControls();
        }
    }

    private void removeTuningModel(TGTrackTuningModel model) {
        if (this.tuning.remove(model)) {
            this.updateTuningControls();
        }
    }

    private void updateTuningModels(List<TGTrackTuningModel> models) {
        this.tuning.clear();
        if (this.tuning.addAll(models)) {
            this.updateTuningControls();
        }
    }

    private void updateTuningFromPreset(TGTrackTuningModel[] preset) {
        ArrayList<TGTrackTuningModel> models = new ArrayList<TGTrackTuningModel>();
        for (TGTrackTuningModel presetModel : preset) {
            TGTrackTuningModel model = new TGTrackTuningModel();
            model.setValue(presetModel.getValue());
            models.add(model);
        }
        this.updateTuningModels(models);
    }

    private boolean updateTrackTuning() {
        boolean transposeTryKeepString;
        TGSongManager songManager = this.findSongManager();
        TGSong song = this.findSong();
        TGTrack track = this.findTrack();
        ArrayList<TGString> strings = new ArrayList<TGString>();
        for (int i = 0; i < this.tuning.size(); ++i) {
            strings.add(TGSongManager.newString((TGFactory)this.findSongManager().getFactory(), (int)(i + 1), (int)this.tuning.get(i).getValue()));
        }
        Integer offset = songManager.isPercussionChannel(song, track.getChannelId()) ? 0 : (Integer)this.offsetCombo.getSelectedValue();
        boolean offsetChanges = offset != null && !offset.equals(track.getOffset());
        boolean tuningChanges = this.hasTuningChanges(track, strings);
        boolean transposeStrings = this.shouldTransposeStrings(track, track.getChannelId());
        boolean transposeApplyToChords = transposeStrings && this.stringTranspositionApplyToChords.isSelected();
        boolean bl = transposeTryKeepString = transposeStrings && this.stringTranspositionTryKeepString.isSelected();
        if (this.validateTrackTuning(strings)) {
            if (tuningChanges || offsetChanges) {
                TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context.getContext(), "action.track.change-tuning");
                tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, (Object)song);
                tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, (Object)track);
                if (tuningChanges) {
                    tgActionProcessor.setAttribute("strings", strings);
                    tgActionProcessor.setAttribute("transposeStrings", (Object)transposeStrings);
                    tgActionProcessor.setAttribute("transposeTryKeepString", (Object)transposeTryKeepString);
                    tgActionProcessor.setAttribute("transposeApplyToChords", (Object)transposeApplyToChords);
                }
                if (offsetChanges) {
                    tgActionProcessor.setAttribute("offset", (Object)offset);
                }
                tgActionProcessor.process();
            }
            return true;
        }
        return false;
    }

    private boolean validateTrackTuning(List<TGString> strings) {
        if (strings.size() < 1 || strings.size() > 25) {
            TGMessageDialogUtil.errorMessage(this.getContext().getContext(), this.dialog, TuxGuitar.getProperty("tuning.strings.range-error", new String[]{Integer.toString(1), Integer.toString(25)}));
            return false;
        }
        return true;
    }

    private boolean shouldTransposeStrings(TGTrack track, int selectedChannelId) {
        if (this.stringTransposition.isSelected()) {
            boolean percussionChannelNew = this.findSongManager().isPercussionChannel(track.getSong(), selectedChannelId);
            boolean percussionChannelOld = this.findSongManager().isPercussionChannel(track.getSong(), track.getChannelId());
            return !percussionChannelNew && !percussionChannelOld;
        }
        return false;
    }

    private boolean hasTuningChanges(TGTrack track, List<TGString> newStrings) {
        List oldStrings = track.getStrings();
        if (oldStrings.size() != newStrings.size()) {
            return true;
        }
        for (int i = 0; i < oldStrings.size(); ++i) {
            TGString oldString = (TGString)oldStrings.get(i);
            boolean stringExists = false;
            for (int j = 0; j < newStrings.size(); ++j) {
                TGString newString = newStrings.get(j);
                if (!newString.isEqual(oldString)) continue;
                stringExists = true;
            }
            if (stringExists) continue;
            return true;
        }
        return false;
    }

    public String createTuningPresetLabel(TGTrackTuningModel[] tuningPreset) {
        StringBuilder label = new StringBuilder();
        for (int i = 0; i < tuningPreset.length; ++i) {
            if (i > 0) {
                label.append(" ");
            }
            label.append(this.getValueLabel(tuningPreset[tuningPreset.length - i - 1].getValue()));
        }
        return label.toString();
    }

    public TGTrackTuningModel[] createTuningPreset(int[] values) {
        TGTrackTuningModel[] models = new TGTrackTuningModel[values.length];
        for (int i = 0; i < models.length; ++i) {
            models[i] = new TGTrackTuningModel();
            models[i].setValue(values[i]);
        }
        return models;
    }

    public void createTuningPresets() {
        this.tuningPresets.clear();
        for (int[] tuningValues : TGSongManager.DEFAULT_TUNING_VALUES) {
            this.tuningPresets.add(this.createTuningPreset(tuningValues));
        }
    }

    public String[] getValueLabels() {
        String[] valueNames = new String[120];
        for (int i = 0; i < valueNames.length; ++i) {
            valueNames[i] = this.getValueLabel(i, true);
        }
        return valueNames;
    }

    public String getValueLabel(Integer value) {
        return this.getValueLabel(value, false);
    }

    public String getValueLabel(Integer value, boolean octave) {
        StringBuilder sb = new StringBuilder();
        if (value != null) {
            sb.append(NOTE_NAMES[value % NOTE_NAMES.length]);
            if (octave) {
                sb.append(value / 12);
            }
        }
        return sb.toString();
    }

    public TGSongManager findSongManager() {
        return (TGSongManager)this.context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG_MANAGER);
    }

    public TGSong findSong() {
        return (TGSong)this.context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
    }

    public TGTrack findTrack() {
        return (TGTrack)this.context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK);
    }

    public TGViewContext getContext() {
        return this.context;
    }

    public UIFactory getUIFactory() {
        return TGApplication.getInstance(this.context.getContext()).getFactory();
    }

    public UIWindow getDialog() {
        return this.dialog;
    }
}

