/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.settings;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.action.impl.view.TGOpenViewAction;
import org.herac.tuxguitar.app.system.config.TGConfigDefaults;
import org.herac.tuxguitar.app.system.config.TGConfigManager;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.component.tab.TablatureEditor;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.app.view.dialog.confirm.TGConfirmDialog;
import org.herac.tuxguitar.app.view.dialog.confirm.TGConfirmDialogController;
import org.herac.tuxguitar.app.view.dialog.settings.items.LanguageOption;
import org.herac.tuxguitar.app.view.dialog.settings.items.MainOption;
import org.herac.tuxguitar.app.view.dialog.settings.items.SkinOption;
import org.herac.tuxguitar.app.view.dialog.settings.items.SoundOption;
import org.herac.tuxguitar.app.view.dialog.settings.items.StylesOption;
import org.herac.tuxguitar.app.view.dialog.settings.items.TGSettingsOption;
import org.herac.tuxguitar.app.view.util.TGCursorController;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.resource.UICursor;
import org.herac.tuxguitar.ui.toolbar.UIToolBar;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UILayoutContainer;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.properties.TGProperties;

public class TGSettingsEditor {
    private TGViewContext context;
    private TGCursorController cursorController;
    private TGConfigManager config;
    private TGProperties defaults;
    private UIWindow dialog;
    private List<TGSettingsOption> options;
    private List<Runnable> runnables;

    public TGSettingsEditor(TGViewContext context) {
        this.context = context;
        this.config = TGConfigManager.getInstance(this.context.getContext());
    }

    public void show() {
        UIFactory uiFactory = this.getUIFactory();
        UIWindow uiParent = (UIWindow)this.context.getAttribute("parent");
        UITableLayout dialogLayout = new UITableLayout();
        this.dialog = uiFactory.createWindow(uiParent, true, false);
        this.dialog.setLayout((UILayout)dialogLayout);
        this.dialog.setText(TuxGuitar.getProperty("settings.config"));
        UIPanel mainComposite = uiFactory.createPanel((UIContainer)this.dialog, false);
        mainComposite.setLayout((UILayout)new UITableLayout());
        dialogLayout.set((UIControl)mainComposite, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.createComposites((UILayoutContainer)mainComposite);
        UITableLayout buttonsLayout = new UITableLayout();
        UIPanel buttons = uiFactory.createPanel((UIContainer)this.dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(false));
        UIButton buttonDefaults = uiFactory.createButton((UIContainer)buttons);
        buttonDefaults.setText(TuxGuitar.getProperty("defaults"));
        buttonDefaults.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGSettingsEditor.this.dispose();
                TGSettingsEditor.this.setDefaults();
                TGSettingsEditor.this.applyConfigWithConfirmation(true);
            }
        });
        buttonsLayout.set((UIControl)buttonDefaults, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
        buttonOK.setDefaultButton();
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGSettingsEditor.this.updateOptions();
                TGSettingsEditor.this.dispose();
                TGSettingsEditor.this.applyConfigWithConfirmation(false);
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGSettingsEditor.this.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(3), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        TGDialogUtil.openDialog(this.dialog, 5);
    }

    private void createComposites(UILayoutContainer parent) {
        UIFactory uiFactory = this.getUIFactory();
        UITableLayout parentLayout = (UITableLayout)parent.getLayout();
        UIToolBar toolBar = uiFactory.createVerticalToolBar((UIContainer)parent);
        parentLayout.set((UIControl)toolBar, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(true));
        UIPanel option = uiFactory.createPanel((UIContainer)parent, false);
        option.setLayout((UILayout)new UITableLayout(Float.valueOf(0.0f)));
        parentLayout.set((UIControl)option, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.initOptions(toolBar, (UILayoutContainer)option);
        if (this.options.size() > 0) {
            this.select(this.options.get(0));
        }
    }

    private void initOptions(UIToolBar toolBar, UILayoutContainer parent) {
        this.options = new ArrayList<TGSettingsOption>();
        this.options.add(new MainOption(this, toolBar, parent));
        this.options.add(new StylesOption(this, toolBar, parent));
        this.options.add(new LanguageOption(this, toolBar, parent));
        this.options.add(new SkinOption(this, toolBar, parent));
        this.options.add(new SoundOption(this, toolBar, parent));
        for (TGSettingsOption option : this.options) {
            option.createOption();
        }
    }

    public void loadCursor(UICursor cursor) {
        if (!this.isDisposed()) {
            if (this.cursorController == null || !this.cursorController.isControlling((UIControl)this.dialog)) {
                this.cursorController = new TGCursorController(this.context.getContext(), (UIControl)this.dialog);
            }
            this.cursorController.loadCursor(cursor);
        }
    }

    public void pack() {
        this.dialog.pack();
    }

    public void select(TGSettingsOption option) {
        this.hideAll();
        option.setVisible(true);
        this.dialog.redraw();
    }

    private void hideAll() {
        for (TGSettingsOption option : this.options) {
            option.setVisible(false);
        }
    }

    protected void updateOptions() {
        for (TGSettingsOption option : this.options) {
            option.updateConfig();
        }
        this.config.save();
    }

    protected void setDefaults() {
        for (TGSettingsOption option : this.options) {
            option.updateDefaults();
        }
        this.config.save();
    }

    protected void applyConfigWithConfirmation(final boolean force) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context.getContext(), "action.gui.open-view");
        tgActionProcessor.setAttribute(TGOpenViewAction.ATTRIBUTE_CONTROLLER, (Object)new TGConfirmDialogController());
        tgActionProcessor.setAttribute("message", (Object)TuxGuitar.getProperty("settings.config.apply-changes-question"));
        tgActionProcessor.setAttribute("style", (Object)(TGConfirmDialog.BUTTON_YES | TGConfirmDialog.BUTTON_NO));
        tgActionProcessor.setAttribute("defaultButton", (Object)TGConfirmDialog.BUTTON_NO);
        tgActionProcessor.setAttribute("yesRunnable", (Object)new Runnable(){

            @Override
            public void run() {
                TGSettingsEditor.this.applyConfig(force);
            }
        });
        tgActionProcessor.process();
    }

    protected void applyConfig(boolean force) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context.getContext(), "action.system.reload-settings");
        tgActionProcessor.setAttribute("force", (Object)force);
        tgActionProcessor.process();
    }

    protected void dispose() {
        for (TGSettingsOption option : this.options) {
            option.dispose();
        }
        this.getWindow().dispose();
    }

    public TGProperties getDefaults() {
        if (this.defaults == null) {
            this.defaults = TGConfigDefaults.createDefaults();
        }
        return this.defaults;
    }

    public TGConfigManager getConfig() {
        return this.config;
    }

    public TablatureEditor getEditor() {
        return TuxGuitar.getInstance().getTablatureEditor();
    }

    public TGViewContext getViewContext() {
        return this.context;
    }

    public UIWindow getWindow() {
        return this.dialog;
    }

    public UIFactory getUIFactory() {
        return TGApplication.getInstance(this.context.getContext()).getFactory();
    }

    public void addSyncThread(Runnable runnable) {
        this.runnables.add(runnable);
    }

    public boolean isDisposed() {
        return this.dialog == null || this.dialog.isDisposed();
    }
}

