/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.channel;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.system.icons.TGIconManager;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.app.view.dialog.channel.TGChannelHandle;
import org.herac.tuxguitar.app.view.dialog.channel.TGChannelList;
import org.herac.tuxguitar.app.view.dialog.channel.TGChannelSettingsHandlerManager;
import org.herac.tuxguitar.app.view.util.TGCursorController;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.app.view.util.TGProcess;
import org.herac.tuxguitar.app.view.util.TGSyncProcess;
import org.herac.tuxguitar.app.view.util.TGSyncProcessLocked;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.player.base.MidiPlayer;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UIDisposeEvent;
import org.herac.tuxguitar.ui.event.UIDisposeListener;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.resource.UICursor;
import org.herac.tuxguitar.ui.resource.UIRectangle;
import org.herac.tuxguitar.ui.resource.UISize;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UILabel;
import org.herac.tuxguitar.ui.widget.UILayoutContainer;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UIScale;
import org.herac.tuxguitar.ui.widget.UISeparator;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.singleton.TGSingletonFactory;
import org.herac.tuxguitar.util.singleton.TGSingletonUtil;

public class TGChannelManagerDialog
implements TGEventListener {
    private static final float MINIMUN_HEIGHT = 450.0f;
    private UIWindow dialog;
    private TGContext context;
    private TGChannelHandle channelHandle;
    private TGChannelList channelList;
    private TGChannelSettingsHandlerManager channelSettingsHandlerManager;
    private TGCursorController cursorController;
    private TGProcess loadPropertiesProcess;
    private TGProcess loadIconsProcess;
    private TGProcess updateItemsProcess;
    private UIButton addChannelButton;
    private UIScale volumeScale;
    private UILabel volumeValueLabel;
    private UILabel volumeValueTitleLabel;
    private String volumeTip;
    private int volumeValue;

    public TGChannelManagerDialog(TGContext context) {
        this.context = context;
        this.channelHandle = new TGChannelHandle(context);
        this.channelSettingsHandlerManager = new TGChannelSettingsHandlerManager(context);
        this.createSyncProcesses();
    }

    public void show(TGViewContext viewContext) {
        UIFactory uiFactory = this.getUIFactory();
        UIWindow uiParent = (UIWindow)viewContext.getAttribute("parent");
        UITableLayout dialogLayout = new UITableLayout();
        this.dialog = uiFactory.createWindow(uiParent, false, true);
        this.dialog.setLayout((UILayout)dialogLayout);
        UITableLayout compositeLayout = new UITableLayout();
        UIPanel composite = uiFactory.createPanel((UIContainer)this.dialog, false);
        composite.setLayout((UILayout)compositeLayout);
        dialogLayout.set((UIControl)composite, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIControl mainControl = this.createChannelList((UILayoutContainer)composite);
        compositeLayout.set(mainControl, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIPanel rightControl = this.createRightComposite((UILayoutContainer)composite);
        compositeLayout.set((UIControl)rightControl, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(true));
        this.updateItems(true);
        this.loadProperties();
        this.loadIcons();
        this.addListeners();
        this.dialog.addDisposeListener(new UIDisposeListener(){

            public void onDispose(UIDisposeEvent event) {
                TGChannelManagerDialog.this.removeListeners();
                TuxGuitar.getInstance().updateCache(true);
            }
        });
        this.dialog.computePackedSize(null, null);
        this.dialog.layout(new UIRectangle(this.createPreferredSize(this.dialog.getPackedSize())));
        TGDialogUtil.openDialog(this.dialog, 4);
    }

    public TGContext getContext() {
        return this.context;
    }

    public UIFactory getUIFactory() {
        return TGApplication.getInstance(this.context).getFactory();
    }

    public UIWindow getWindow() {
        return this.dialog;
    }

    public boolean isDisposed() {
        return this.dialog == null || this.dialog.isDisposed();
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.dialog.dispose();
        }
    }

    public void addListeners() {
        TuxGuitar.getInstance().getSkinManager().addLoader(this);
        TuxGuitar.getInstance().getLanguageManager().addLoader(this);
        TuxGuitar.getInstance().getEditorManager().addUpdateListener((TGEventListener)this);
    }

    public void removeListeners() {
        TuxGuitar.getInstance().getSkinManager().removeLoader(this);
        TuxGuitar.getInstance().getLanguageManager().removeLoader(this);
        TuxGuitar.getInstance().getEditorManager().removeUpdateListener((TGEventListener)this);
    }

    private UISize createPreferredSize(UISize size) {
        UISize preferredSize = new UISize(size.getWidth(), size.getHeight());
        if (preferredSize.getHeight() < 450.0f) {
            preferredSize.setHeight(450.0f);
        }
        return preferredSize;
    }

    private UIPanel createRightComposite(UILayoutContainer parent) {
        UIFactory uiFactory = this.getUIFactory();
        UITableLayout rightCompositeLayout = new UITableLayout();
        UIPanel rightComposite = uiFactory.createPanel((UIContainer)parent, true);
        rightComposite.setLayout((UILayout)rightCompositeLayout);
        UITableLayout toolbarCompositeLayout = new UITableLayout();
        UIPanel toolbarComposite = uiFactory.createPanel((UIContainer)rightComposite, true);
        toolbarComposite.setLayout((UILayout)toolbarCompositeLayout);
        rightCompositeLayout.set((UIControl)toolbarComposite, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_TOP, Boolean.valueOf(true), Boolean.valueOf(false));
        this.addChannelButton = uiFactory.createButton((UIContainer)toolbarComposite);
        this.addChannelButton.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGChannelManagerDialog.this.getHandle().addChannel();
            }
        });
        toolbarCompositeLayout.set((UIControl)this.addChannelButton, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UITableLayout volumeCompositeLayout = new UITableLayout();
        UIPanel volumeComposite = uiFactory.createPanel((UIContainer)rightComposite, true);
        volumeComposite.setLayout((UILayout)volumeCompositeLayout);
        rightCompositeLayout.set((UIControl)volumeComposite, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.volumeScale = uiFactory.createVerticalScale((UIContainer)volumeComposite);
        this.volumeScale.setMaximum(10);
        this.volumeScale.setMinimum(0);
        this.volumeScale.setIncrement(1);
        volumeCompositeLayout.set((UIControl)this.volumeScale, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_CENTER, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UISeparator separator = uiFactory.createHorizontalSeparator((UIContainer)volumeComposite);
        volumeCompositeLayout.set((UIControl)separator, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(false));
        UITableLayout volumeValueLayout = new UITableLayout();
        UIPanel volumeValueComposite = uiFactory.createPanel((UIContainer)volumeComposite, false);
        volumeValueComposite.setLayout((UILayout)volumeValueLayout);
        volumeCompositeLayout.set((UIControl)volumeValueComposite, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(false));
        this.volumeValueTitleLabel = uiFactory.createLabel((UIContainer)volumeValueComposite);
        volumeValueLayout.set((UIControl)this.volumeValueTitleLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        this.volumeValueLabel = uiFactory.createLabel((UIContainer)volumeValueComposite);
        volumeValueLayout.set((UIControl)this.volumeValueLabel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        this.volumeScale.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGChannelManagerDialog.this.changeVolume();
            }
        });
        return rightComposite;
    }

    private UIControl createChannelList(UILayoutContainer parent) {
        this.channelList = new TGChannelList(this);
        this.channelList.show(parent);
        return this.channelList.getControl();
    }

    private void changeVolume() {
        MidiPlayer midiPlayer = MidiPlayer.getInstance((TGContext)this.context);
        int volume = this.volumeScale.getValue();
        if (volume != midiPlayer.getVolume()) {
            midiPlayer.setVolume(volume);
            this.volumeScale.setToolTipText(this.volumeTip + ": " + volume);
            this.volumeValueLabel.setText(Integer.toString(volume));
            this.volumeValue = volume;
        }
    }

    public void updateItems() {
        this.updateItems(false);
    }

    public void updateItems(boolean force) {
        if (!this.isDisposed()) {
            this.loadCursor(UICursor.WAIT);
            this.channelList.updateItems();
            int volume = MidiPlayer.getInstance((TGContext)this.context).getVolume();
            if (force || this.volumeValue != volume) {
                this.volumeScale.setIgnoreEvents(true);
                this.volumeScale.setValue(volume);
                this.volumeScale.setIgnoreEvents(false);
                this.volumeValueLabel.setText(Integer.toString(volume));
                this.volumeValue = volume;
            }
            this.loadCursor(UICursor.NORMAL);
        }
    }

    public void loadProperties() {
        if (!this.isDisposed()) {
            this.addChannelButton.setText(TuxGuitar.getProperty("add"));
            this.volumeValueTitleLabel.setText(TuxGuitar.getProperty("instruments.volume") + ":");
            this.volumeTip = TuxGuitar.getProperty("instruments.volume");
            this.volumeScale.setToolTipText(this.volumeTip + ": " + MidiPlayer.getInstance((TGContext)this.context).getVolume());
            this.dialog.setText(TuxGuitar.getProperty("instruments.dialog-title"));
            this.channelList.loadProperties();
        }
    }

    public void loadIcons() {
        if (!this.isDisposed()) {
            this.dialog.setImage(TGIconManager.getInstance(this.getContext()).getAppIcon());
            this.channelList.loadIcons();
        }
    }

    public void loadCursor(UICursor cursor) {
        if (!this.isDisposed()) {
            if (this.cursorController == null || !this.cursorController.isControlling((UIControl)this.dialog)) {
                this.cursorController = new TGCursorController(this.context, (UIControl)this.dialog);
            }
            this.cursorController.loadCursor(cursor);
        }
    }

    public TGChannelHandle getHandle() {
        return this.channelHandle;
    }

    public TGChannelSettingsHandlerManager getChannelSettingsHandlerManager() {
        return this.channelSettingsHandlerManager;
    }

    public void createSyncProcesses() {
        this.loadPropertiesProcess = new TGSyncProcess(this.context, new Runnable(){

            @Override
            public void run() {
                TGChannelManagerDialog.this.loadProperties();
            }
        });
        this.loadIconsProcess = new TGSyncProcess(this.context, new Runnable(){

            @Override
            public void run() {
                TGChannelManagerDialog.this.loadIcons();
            }
        });
        this.updateItemsProcess = new TGSyncProcessLocked(this.context, new Runnable(){

            @Override
            public void run() {
                TGChannelManagerDialog.this.updateItems();
            }
        });
    }

    public void processUpdateEvent(TGEvent event) {
        int type = (Integer)event.getAttribute("updateMode");
        if (type == 1) {
            this.updateItemsProcess.process();
        }
    }

    public void processEvent(TGEvent event) {
        if ("ui-skin".equals(event.getEventType())) {
            this.loadIconsProcess.process();
        } else if ("language".equals(event.getEventType())) {
            this.loadPropertiesProcess.process();
        } else if ("ui-update".equals(event.getEventType())) {
            this.processUpdateEvent(event);
        }
    }

    public static TGChannelManagerDialog getInstance(TGContext context) {
        return (TGChannelManagerDialog)TGSingletonUtil.getInstance((TGContext)context, (String)TGChannelManagerDialog.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGChannelManagerDialog>(){

            public TGChannelManagerDialog createInstance(TGContext context) {
                return new TGChannelManagerDialog(context);
            }
        });
    }
}

