/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.herac.tuxguitar.resource.TGResourceException;
import org.herac.tuxguitar.resource.TGResourceLoader;
import org.herac.tuxguitar.resource.TGResourceManager;
import org.herac.tuxguitar.util.TGContext;

public class TGServiceReader {
    private static final String SERVICE_PATH = new String("META-INF/services/");

    public static <T> Iterator<T> lookupProviders(Class<T> spi, TGContext context) {
        return TGServiceReader.lookupProviders(spi, TGResourceManager.getInstance(context));
    }

    public static <T> Iterator<T> lookupProviders(Class<T> spi, TGResourceLoader loader) {
        try {
            if (spi == null || loader == null) {
                throw new IllegalArgumentException();
            }
            return new IteratorImpl<T>(spi, loader, loader.getResources(SERVICE_PATH + spi.getName()));
        }
        catch (TGResourceException e) {
            return new ArrayList().iterator();
        }
    }

    private static final class IteratorImpl<T>
    implements Iterator<T> {
        private Class<T> spi;
        private TGResourceLoader loader;
        private Enumeration<URL> urls;
        private Iterator<String> iterator;

        public IteratorImpl(Class<T> spi, TGResourceLoader loader, Enumeration<URL> urls) {
            this.spi = spi;
            this.loader = loader;
            this.urls = urls;
            this.initialize();
        }

        private void initialize() {
            ArrayList<String> providers = new ArrayList<String>();
            while (this.urls.hasMoreElements()) {
                URL url = this.urls.nextElement();
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        String provider = this.uncommentLine(line).trim();
                        if (provider == null || provider.length() <= 0) continue;
                        providers.add(provider);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.iterator = providers.iterator();
        }

        private String uncommentLine(String line) {
            int index = line.indexOf(35);
            if (index >= 0) {
                return line.substring(0, index);
            }
            return line;
        }

        @Override
        public boolean hasNext() {
            return this.iterator != null && this.iterator.hasNext();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                Object provider = this.loader.loadClass(this.iterator.next()).newInstance();
                if (this.spi.isInstance(provider)) {
                    return provider;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

