/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.util;

import org.herac.tuxguitar.thread.TGThreadManager;
import org.herac.tuxguitar.util.TGContext;

public class TGLock {
    private int lockCount = 0;
    private Object lock = new Object();
    private Object lockThread = null;
    private TGThreadManager threadManager;

    public TGLock(TGContext context) {
        this.threadManager = TGThreadManager.getInstance(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() {
        Object thread = this.threadManager.getThreadId();
        boolean lockSuccess = false;
        Object object = this.lock;
        synchronized (object) {
            lockSuccess = !this.isLocked(thread);
            if (lockSuccess) {
                this.lockThread = thread;
                ++this.lockCount;
            }
        }
        if (!lockSuccess) {
            while (this.isLocked(thread)) {
                this.threadManager.yield();
            }
            this.lock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(boolean force) {
        Object object = this.lock;
        synchronized (object) {
            --this.lockCount;
            if (this.lockCount == 0 || force) {
                this.lockCount = 0;
                this.lockThread = null;
            }
        }
    }

    public void unlock() {
        this.unlock(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryLock() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isLocked()) {
                return false;
            }
            this.lock();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocked(Object thread) {
        Object object = this.lock;
        synchronized (object) {
            return this.lockThread != null && !this.lockThread.equals(thread);
        }
    }

    public boolean isLocked() {
        return this.isLocked(this.threadManager.getThreadId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUnderLockControl(Object thread) {
        Object object = this.lock;
        synchronized (object) {
            return this.lockThread != null && !this.isLocked(thread);
        }
    }

    public boolean isUnderLockControl() {
        return this.isUnderLockControl(this.threadManager.getThreadId());
    }
}

