/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.community.browser;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.dialog.browser.main.TGBrowserDialog;
import org.herac.tuxguitar.app.view.main.TGWindow;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.community.TGCommunitySingleton;
import org.herac.tuxguitar.community.auth.TGCommunityAuthDialog;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UILabel;
import org.herac.tuxguitar.ui.widget.UILegendPanel;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UIReadOnlyTextField;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;

public class TGBrowserAuthDialog {
    private TGContext context;
    private Runnable onSuccess;

    public TGBrowserAuthDialog(TGContext context, Runnable onSuccess) {
        this.context = context;
        this.onSuccess = onSuccess;
    }

    public void open() {
        TGBrowserDialog browser = TGBrowserDialog.getInstance((TGContext)this.context);
        this.open(!browser.isDisposed() ? browser.getWindow() : TGWindow.getInstance((TGContext)this.context).getWindow());
    }

    public void open(UIWindow parent) {
        UIFactory uiFactory = TGApplication.getInstance((TGContext)this.context).getFactory();
        UITableLayout dialogLayout = new UITableLayout();
        final UIWindow dialog = uiFactory.createWindow(parent, true, false);
        dialog.setLayout((UILayout)dialogLayout);
        dialog.setImage(TuxGuitar.getInstance().getIconManager().getAppIcon());
        dialog.setText(TuxGuitar.getProperty((String)"tuxguitar-community.browser-dialog.title"));
        UITableLayout groupLayout = new UITableLayout();
        UILegendPanel group = uiFactory.createLegendPanel((UIContainer)dialog);
        group.setLayout((UILayout)groupLayout);
        group.setText(TuxGuitar.getProperty((String)"tuxguitar-community.browser-dialog.account"));
        dialogLayout.set((UIControl)group, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UILabel usernameLabel = uiFactory.createLabel((UIContainer)group);
        usernameLabel.setText(TuxGuitar.getProperty((String)"tuxguitar-community.browser-dialog.account.user") + ":");
        groupLayout.set((UIControl)usernameLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        final UIReadOnlyTextField usernameText = uiFactory.createReadOnlyTextField((UIContainer)group);
        usernameText.setText(TGCommunitySingleton.getInstance(this.getContext()).getAuth().getUsername());
        groupLayout.set((UIControl)usernameText, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(250.0f), null, null);
        UIButton usernameChooser = uiFactory.createButton((UIContainer)group);
        usernameChooser.setText("...");
        usernameChooser.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                new TGCommunityAuthDialog(TGBrowserAuthDialog.this.getContext(), new Runnable(){

                    @Override
                    public void run() {
                        TGCommunitySingleton.getInstance(TGBrowserAuthDialog.this.getContext()).getAuth().update();
                        usernameText.setText(TGCommunitySingleton.getInstance(TGBrowserAuthDialog.this.getContext()).getAuth().getUsername());
                    }
                }, null).open(dialog);
            }
        });
        groupLayout.set((UIControl)usernameChooser, Integer.valueOf(1), Integer.valueOf(3), UITableLayout.ALIGN_CENTER, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
        buttonOK.setText(TuxGuitar.getProperty((String)"ok"));
        buttonOK.setDefaultButton();
        buttonOK.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGBrowserAuthDialog.this.onFinish(dialog, TGBrowserAuthDialog.this.onSuccess);
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty((String)"cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGBrowserAuthDialog.this.onFinish(dialog, null);
            }
        });
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
        TGDialogUtil.openDialog((UIWindow)dialog, (int)5);
    }

    public void onFinish(UIWindow dialog, Runnable runnable) {
        dialog.dispose();
        if (runnable != null) {
            runnable.run();
        }
    }

    public TGContext getContext() {
        return this.context;
    }
}

