/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.midiport.vst.remote.command;

import java.io.IOException;
import java.nio.charset.Charset;
import org.herac.tuxguitar.player.impl.midiport.vst.remote.VSTConnection;
import org.herac.tuxguitar.player.impl.midiport.vst.remote.command.VSTCommand;

public abstract class VSTAbstractCommand<T>
implements VSTCommand<T> {
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private VSTConnection connection;

    public VSTAbstractCommand(VSTConnection connection) {
        this.connection = connection;
    }

    public VSTConnection getConnection() {
        return this.connection;
    }

    public void readBytes(byte[] buffer) throws IOException {
        this.getConnection().getInputStream().read(buffer);
    }

    public byte[] readBytes(int length) throws IOException {
        byte[] bytes = new byte[length];
        this.readBytes(bytes);
        return bytes;
    }

    public Boolean readBoolean() throws IOException {
        byte[] buffer = this.readBytes(1);
        return buffer[0] == 1;
    }

    public Integer readInteger() throws IOException {
        byte[] buffer = this.readBytes(4);
        return ((buffer[0] & 0xFF) << 0) + ((buffer[1] & 0xFF) << 8) + ((buffer[2] & 0xFF) << 16) + ((buffer[3] & 0xFF) << 24);
    }

    public Float readFloat() throws IOException {
        return Float.valueOf(Float.intBitsToFloat(this.readInteger()));
    }

    public String readString() throws IOException {
        byte[] bytes = this.readBytes(this.readInteger());
        return new String(bytes, CHARSET);
    }

    public void writeBytes(byte[] bytes) throws IOException {
        this.getConnection().getOutputStream().write(bytes);
        this.getConnection().getOutputStream().flush();
    }

    public void writeBoolean(Boolean value) throws IOException {
        this.writeBytes(new byte[]{value != false ? (byte)1 : 0});
    }

    public void writeInteger(Integer value) throws IOException {
        byte[] buffer = new byte[]{(byte)(value >>> 0 & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value >>> 16 & 0xFF), (byte)(value >>> 24 & 0xFF)};
        this.writeBytes(buffer);
    }

    public void writeFloat(float value) throws IOException {
        this.writeInteger(Float.floatToIntBits(value));
    }

    public void writeString(String value) throws IOException {
        byte[] bytes = value.getBytes(CHARSET);
        this.writeInteger(bytes.length);
        this.writeBytes(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T safeProcess(T defaultValue) {
        VSTConnection vSTConnection = this.connection;
        synchronized (vSTConnection) {
            try {
                return this.process();
            }
            catch (IOException e) {
                this.getConnection().close();
                e.printStackTrace();
            }
        }
        return defaultValue;
    }

    public T safeProcess() {
        return this.safeProcess(null);
    }
}

