/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.midiport.vst.remote;

import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.event.TGEventManager;
import org.herac.tuxguitar.midi.synth.ui.TGAudioProcessorUICallback;
import org.herac.tuxguitar.player.impl.midiport.vst.remote.VSTEffect;
import org.herac.tuxguitar.player.impl.midiport.vst.remote.VSTParamsEvent;
import org.herac.tuxguitar.player.impl.midiport.vst.remote.VSTSession;
import org.herac.tuxguitar.thread.TGThreadManager;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UIDisposeEvent;
import org.herac.tuxguitar.ui.event.UIDisposeListener;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UIScrollBarPanelLayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UILabel;
import org.herac.tuxguitar.ui.widget.UILegendPanel;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UIScale;
import org.herac.tuxguitar.ui.widget.UIScrollBarPanel;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGException;
import org.herac.tuxguitar.util.TGSynchronizer;

public class VSTEffectEditor
implements TGEventListener {
    private VSTEffect effect;
    private TGContext context;
    private UIWindow dialog;
    private TGAudioProcessorUICallback callback;
    private UIScale[] scaleParameterValue;
    private UILabel[] labelParameterValue;
    private Integer paramCount;

    public VSTEffectEditor(TGContext context, VSTEffect effect, TGAudioProcessorUICallback callback) {
        this.context = context;
        this.effect = effect;
        this.callback = callback;
    }

    public void open(UIWindow parent) {
        UIFactory uiFactory = TGApplication.getInstance((TGContext)this.context).getFactory();
        UITableLayout dialogLayout = new UITableLayout();
        this.dialog = uiFactory.createWindow(parent, false, false);
        this.dialog.setLayout((UILayout)dialogLayout);
        this.dialog.setText("VST Effect");
        UITableLayout groupLayout = new UITableLayout();
        UILegendPanel group = uiFactory.createLegendPanel((UIContainer)this.dialog);
        group.setLayout((UILayout)groupLayout);
        group.setText("VST Effect Parameters");
        dialogLayout.set((UIControl)group, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        final UIScrollBarPanel scrollBarPanel = uiFactory.createScrollBarPanel((UIContainer)group, true, false, false);
        scrollBarPanel.setLayout((UILayout)new UIScrollBarPanelLayout(false, true, true, true, false, true));
        scrollBarPanel.getVScroll().setIncrement(10);
        scrollBarPanel.getVScroll().addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                scrollBarPanel.layout();
            }
        });
        groupLayout.set((UIControl)scrollBarPanel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(400.0f), Float.valueOf(400.0f), null);
        UITableLayout panelLayout = new UITableLayout();
        UIPanel panel = uiFactory.createPanel((UIContainer)scrollBarPanel, false);
        panel.setLayout((UILayout)panelLayout);
        this.paramCount = Math.min(this.effect.getNumParams(), 50);
        this.scaleParameterValue = new UIScale[this.paramCount.intValue()];
        this.labelParameterValue = new UILabel[this.paramCount.intValue()];
        for (int i = 0; i < this.paramCount; ++i) {
            final int index = i;
            String name = this.effect.getParameterName(i);
            String label = this.effect.getParameterLabel(i);
            UILabel labelParameterName = uiFactory.createLabel((UIContainer)panel);
            labelParameterName.setText(name != null ? name : "");
            panelLayout.set((UIControl)labelParameterName, Integer.valueOf(1 + i), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
            UILabel labelParameterLabel = uiFactory.createLabel((UIContainer)panel);
            labelParameterLabel.setText(label != null ? label : "");
            panelLayout.set((UIControl)labelParameterLabel, Integer.valueOf(1 + i), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
            this.scaleParameterValue[i] = uiFactory.createHorizontalScale((UIContainer)panel);
            this.scaleParameterValue[i].setMaximum(100);
            this.scaleParameterValue[i].setMinimum(0);
            this.scaleParameterValue[i].setIncrement(1);
            panelLayout.set((UIControl)this.scaleParameterValue[i], Integer.valueOf(1 + i), Integer.valueOf(3), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(false));
            this.labelParameterValue[i] = uiFactory.createLabel((UIContainer)panel);
            panelLayout.set((UIControl)this.labelParameterValue[i], Integer.valueOf(1 + i), Integer.valueOf(4), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
            this.scaleParameterValue[i].addSelectionListener(new UISelectionListener(){

                public void onSelect(UISelectionEvent event) {
                    float selection = (float)VSTEffectEditor.this.scaleParameterValue[index].getValue() / 100.0f;
                    VSTEffectEditor.this.labelParameterValue[index].setText(Float.toString(selection));
                    VSTEffectEditor.this.effect.setParameter(index, selection);
                    VSTEffectEditor.this.callback.onChange();
                }
            });
        }
        if (this.effect.isEditorAvailable()) {
            UIButton nativeEditor = uiFactory.createButton((UIContainer)this.dialog);
            nativeEditor.setText("Native Editor");
            nativeEditor.addSelectionListener(new UISelectionListener(){

                public void onSelect(UISelectionEvent event) {
                    TGThreadManager.getInstance((TGContext)VSTEffectEditor.this.context).start(new Runnable(){

                        @Override
                        public void run() throws TGException {
                            VSTEffectEditor.this.toggleNativeEditor();
                        }
                    });
                }
            });
            dialogLayout.set((UIControl)nativeEditor, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(false));
        }
        this.updateItems();
        this.addEventListeners();
        this.dialog.addDisposeListener(new UIDisposeListener(){

            public void onDispose(UIDisposeEvent event) {
                VSTEffectEditor.this.removeEventListeners();
            }
        });
        TGDialogUtil.openDialog((UIWindow)this.dialog, (int)5);
    }

    public void addEventListeners() {
        TGEventManager.getInstance((TGContext)this.context).addListener("vst-params", (TGEventListener)this);
    }

    public void removeEventListeners() {
        TGEventManager.getInstance((TGContext)this.context).removeListener("vst-params", (TGEventListener)this);
    }

    public void updateItems() {
        int paramCount = Math.min(this.effect.getNumParams(), 50);
        for (int i = 0; i < paramCount && i < this.paramCount; ++i) {
            float value = this.effect.getParameter(i);
            this.scaleParameterValue[i].setIgnoreEvents(true);
            this.scaleParameterValue[i].setValue(Math.round(100.0f * value));
            this.scaleParameterValue[i].setIgnoreEvents(false);
            this.labelParameterValue[i].setText(Float.toString(value));
        }
    }

    public void close() {
        if (this.isOpen()) {
            this.dialog.dispose();
            this.dialog = null;
        }
    }

    public boolean isOpen() {
        return this.dialog != null && !this.dialog.isDisposed();
    }

    public void toggleNativeEditor() {
        if (this.effect.isNativeEditorOpen()) {
            this.effect.closeNativeEditor();
        } else {
            this.effect.openNativeEditor();
        }
    }

    public void openInUiThread(final UIWindow parent) {
        TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){

            @Override
            public void run() {
                VSTEffectEditor.this.open(parent);
            }
        });
    }

    public void updateItemsUiThread() {
        TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){

            @Override
            public void run() {
                VSTEffectEditor.this.updateItems();
            }
        });
    }

    public void processEvent(TGEvent event) {
        if ("vst-params".equals(event.getEventType())) {
            VSTSession session = (VSTSession)event.getAttribute("session");
            if (VSTParamsEvent.ACTION_RESTORE.equals(event.getAttribute("action")) && !this.effect.isClosed() && this.effect.getSession().getId().equals(session.getId())) {
                this.updateItemsUiThread();
            }
        }
    }
}

