/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.midi.synth.impl;

import com.sun.media.sound.EmergencySoundbank;
import com.sun.media.sound.ModelPatch;
import com.sun.media.sound.SF2Instrument;
import java.io.File;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Patch;
import javax.sound.midi.Soundbank;
import org.herac.tuxguitar.midi.synth.impl.GervillProcessorFactory;
import org.herac.tuxguitar.midi.synth.impl.GervillProgram;
import org.herac.tuxguitar.midi.synth.impl.GervillSettings;
import org.herac.tuxguitar.midi.synth.impl.GervillSoundbankCallback;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGExpressionResolver;

public class GervillSoundbankFactory {
    private static Instrument[][] defaultInstruments;
    private int locks;

    public boolean isBusy() {
        return this.locks != 0;
    }

    public void create(final TGContext context, final GervillProgram program, final GervillSoundbankCallback callback) {
        ++this.locks;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    GervillSoundbankFactory.this.createInstrument(context, program, callback);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    GervillSoundbankFactory.this.locks--;
                }
            }
        }).start();
    }

    private void createInstrument(TGContext context, GervillProgram program, GervillSoundbankCallback callback) throws Exception {
        Instrument instrument = this.createInstrument(context, program);
        if (instrument != null) {
            callback.onCreate(instrument);
        }
    }

    private Instrument createInstrument(TGContext context, GervillProgram program) throws Exception {
        Instrument instrument = null;
        if (program.getSoundbankPath() != null && program.getSoundbankPath().length() > 0) {
            Soundbank soundbank = this.createSoundbank(context, program.getSoundbankPath());
            boolean percussion = program.getBank() == 128;
            ModelPatch patch = new ModelPatch(percussion ? 0 : program.getBank(), program.getProgram(), percussion);
            instrument = soundbank.getInstrument(patch);
        }
        if (instrument == null) {
            instrument = this.getDefaultInstrument(context, program);
        }
        if (instrument != null) {
            ((SF2Instrument)instrument).setPatch(new Patch(0, 0));
        }
        return instrument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Instrument getDefaultInstrument(TGContext context, GervillProgram program) throws Exception {
        Class<GervillProcessorFactory> clazz = GervillProcessorFactory.class;
        synchronized (GervillProcessorFactory.class) {
            if (defaultInstruments == null) {
                defaultInstruments = new Instrument[129][128];
                Soundbank soundbank = null;
                String soundbankPath = new GervillSettings(context).getSoundbankPath();
                if (soundbankPath != null && soundbankPath.length() > 0) {
                    soundbank = this.createSoundbank(context, soundbankPath);
                }
                if (soundbank == null) {
                    soundbank = EmergencySoundbank.createSoundbank();
                }
                if (soundbank != null) {
                    Instrument[] instruments;
                    for (Instrument instrument : instruments = soundbank.getInstruments()) {
                        ModelPatch patch = (ModelPatch)instrument.getPatch();
                        if (patch.getProgram() >= 128 || patch.getBank() >= 128) continue;
                        GervillSoundbankFactory.defaultInstruments[patch.isPercussion() ? 128 : patch.getBank()][patch.getProgram()] = instrument;
                    }
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return defaultInstruments[program.getBank()][program.getProgram()];
        }
    }

    private Soundbank createSoundbank(TGContext context, String soundbankPath) {
        try {
            return MidiSystem.getSoundbank(new File(TGExpressionResolver.getInstance((TGContext)context).resolve(soundbankPath)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

