/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.ui.swt.widget;

import java.awt.Point;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.ui.resource.UIImage;
import org.herac.tuxguitar.ui.swt.SWTComponent;
import org.herac.tuxguitar.ui.swt.resource.SWTImage;
import org.herac.tuxguitar.ui.widget.UISplashWindow;

public class SWTSplashWindow
extends SWTComponent<Shell>
implements UISplashWindow {
    private UIImage image;
    private UIImage splashImage;

    public SWTSplashWindow(Display display) {
        super(new Shell(display, 262152));
        ((Shell)this.getControl()).setLayout((Layout)new FillLayout());
        ((Shell)this.getControl()).addPaintListener((PaintListener)new SWTPaintListener(this));
    }

    public String getText() {
        return ((Shell)this.getControl()).getText();
    }

    public void setText(String text) {
        ((Shell)this.getControl()).setText(text);
    }

    public UIImage getImage() {
        return this.image;
    }

    public void setImage(UIImage image) {
        this.image = image;
        ((Shell)this.getControl()).setImage(this.image != null ? ((SWTImage)this.image).getHandle() : null);
    }

    public UIImage getSplashImage() {
        return this.splashImage;
    }

    public void setSplashImage(UIImage splashImage) {
        this.splashImage = splashImage;
    }

    public void dispose() {
        ((Shell)this.getControl()).dispose();
    }

    public boolean isDisposed() {
        return ((Shell)this.getControl()).isDisposed();
    }

    public void open() {
        ((Shell)this.getControl()).setBounds(this.getPreferredBounds());
        ((Shell)this.getControl()).open();
        ((Shell)this.getControl()).redraw();
        ((Shell)this.getControl()).update();
    }

    public Rectangle getPreferredBounds() {
        Point iBounds = this.getSplashImageSize();
        Rectangle mBounds = ((Shell)this.getControl()).getMonitor().getClientArea();
        int x = (mBounds.x + mBounds.width) / 2 - iBounds.x / 2;
        int y = (mBounds.y + mBounds.height) / 2 - iBounds.y / 2;
        int width = iBounds.x;
        int height = iBounds.y;
        return new Rectangle(x, y, width, height);
    }

    public Point getSplashImageSize() {
        if (this.getSplashImage() != null && !this.getSplashImage().isDisposed()) {
            this.getSplashImage().getWidth();
            return new Point(Math.round(this.getSplashImage().getWidth()), Math.round(this.getSplashImage().getHeight()));
        }
        return new Point(0, 0);
    }

    public class SWTPaintListener
    implements PaintListener {
        private SWTSplashWindow window;

        public SWTPaintListener(SWTSplashWindow window) {
            this.window = window;
        }

        public void paintControl(PaintEvent e) {
            if (this.window.getSplashImage() != null && !this.window.getSplashImage().isDisposed()) {
                e.gc.drawImage(((SWTImage)this.window.getSplashImage()).getHandle(), 0, 0);
            }
        }
    }
}

