/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.ui.swt.widget;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.herac.tuxguitar.ui.UIComponent;
import org.herac.tuxguitar.ui.event.UIMouseDragListener;
import org.herac.tuxguitar.ui.event.UIMouseEvent;
import org.herac.tuxguitar.ui.event.UIMouseUpListener;
import org.herac.tuxguitar.ui.event.UIMouseWheelEvent;
import org.herac.tuxguitar.ui.event.UIMouseWheelListener;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.event.UISelectionListenerManager;
import org.herac.tuxguitar.ui.swt.resource.SWTPainter;
import org.herac.tuxguitar.ui.swt.widget.SWTContainer;
import org.herac.tuxguitar.ui.swt.widget.SWTControl;
import org.herac.tuxguitar.ui.widget.UIKnob;

public class SWTCustomKnob
extends SWTControl<Composite>
implements UIKnob,
UIMouseDragListener,
UIMouseUpListener,
UIMouseWheelListener,
PaintListener {
    private static final int DEFAULT_MAXIMUM = 100;
    private static final int DEFAULT_MINIMUM = 0;
    private static final int DEFAULT_INCREMENT = 1;
    private static final float DEFAULT_PACKED_WIDTH = 32.0f;
    private static final float DEFAULT_PACKED_HEIGHT = 32.0f;
    private static final float MARGIN = 2.0f;
    private int maximum = 100;
    private int minimum = 0;
    private int increment = 1;
    private int value;
    private float lastDragY;
    private UISelectionListenerManager selectionHandler = new UISelectionListenerManager();

    public SWTCustomKnob(SWTContainer<? extends Composite> parent) {
        super(new Composite(parent.getControl(), 0x20000000), parent);
        this.addMouseUpListener(this);
        this.addMouseDragListener(this);
        this.addMouseWheelListener(this);
        ((Composite)this.getControl()).addPaintListener((PaintListener)this);
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        if (this.value != value) {
            this.value = value;
            this.invalidate();
            this.fireSelectionEvent();
        }
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setMaximum(int maximum) {
        if (this.maximum != maximum) {
            if (this.minimum > maximum) {
                this.minimum = maximum;
            }
            if (this.value > maximum) {
                this.value = maximum;
            }
            this.maximum = maximum;
            this.invalidate();
        }
    }

    public int getMinimum() {
        return this.minimum;
    }

    public void setMinimum(int minimum) {
        if (this.minimum != minimum) {
            if (this.maximum < minimum) {
                this.maximum = minimum;
            }
            if (this.value < minimum) {
                this.value = minimum;
            }
            this.minimum = minimum;
            this.invalidate();
        }
    }

    public int getIncrement() {
        return this.increment;
    }

    public void setIncrement(int increment) {
        this.increment = increment;
        this.invalidate();
    }

    public void addSelectionListener(UISelectionListener listener) {
        this.selectionHandler.addListener(listener);
    }

    public void removeSelectionListener(UISelectionListener listener) {
        this.selectionHandler.removeListener(listener);
    }

    public void fireSelectionEvent() {
        if (!this.isIgnoreEvents()) {
            this.selectionHandler.onSelect(new UISelectionEvent((UIComponent)this));
        }
    }

    @Override
    public void computePackedSize(Float fixedWidth, Float fixedHeight) {
        super.computePackedSize(Float.valueOf(fixedWidth != null ? fixedWidth.floatValue() : 32.0f), Float.valueOf(fixedHeight != null ? fixedHeight.floatValue() : 32.0f));
    }

    public void invalidate() {
        ((Composite)this.getControl()).redraw();
    }

    public void paintControl(PaintEvent e) {
        Rectangle area = ((Composite)this.getControl()).getClientArea();
        float ovalSize = (float)Math.min(area.width, area.height) - 2.0f;
        float x = (float)area.x + (float)area.width / 2.0f;
        float y = (float)area.y + (float)area.height / 2.0f;
        float value = this.value - this.minimum;
        float maximum = this.maximum - this.minimum;
        float percent = 0.5f + (value > 0.0f && maximum > 0.0f ? value / maximum * 1.5f : 0.0f);
        float valueSize = ovalSize / 10.0f;
        float valueX = x + (float)Math.round((double)(ovalSize / 3.0f) * Math.cos(Math.PI * (double)percent));
        float valueY = y + (float)Math.round((double)(ovalSize / 3.0f) * Math.sin(Math.PI * (double)percent));
        SWTPainter uiPainter = new SWTPainter(e.gc);
        uiPainter.initPath(1);
        uiPainter.moveTo(x, y);
        uiPainter.addCircle(y, y, ovalSize);
        uiPainter.closePath();
        uiPainter.initPath(1);
        uiPainter.moveTo(valueX, valueY);
        uiPainter.addCircle(valueX, valueY, valueSize);
        uiPainter.closePath();
    }

    public void onMouseWheel(UIMouseWheelEvent event) {
        this.setValue(Math.round(Math.max(Math.min((float)this.value + Math.signum(event.getValue().intValue()) * (float)this.increment, (float)this.maximum), (float)this.minimum)));
    }

    public void onMouseDrag(UIMouseEvent event) {
        float dragY = event.getPosition().getY();
        float move = this.lastDragY - dragY;
        this.lastDragY = dragY;
        this.setValue(Math.round(Math.max(Math.min((float)this.value + move * (float)this.increment, (float)this.maximum), (float)this.minimum)));
    }

    public void onMouseUp(UIMouseEvent event) {
        this.lastDragY = 0.0f;
    }
}

