/*
 * Decompiled with CFR 0.152.
 */
package org.classpath.icedtea.pulseaudio;

import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.Control;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;

abstract class PulseAudioLine
implements Line {
    protected List<LineListener> lineListeners = new ArrayList<LineListener>();
    protected List<Control> controls = new ArrayList<Control>();
    protected boolean isOpen = false;

    PulseAudioLine() {
    }

    public void addLineListener(LineListener lineListener) {
        this.lineListeners.add(lineListener);
    }

    public void close() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Line is not open");
        }
        this.lineListeners.clear();
        this.isOpen = false;
    }

    protected void fireLineEvent(LineEvent lineEvent) {
        for (LineListener lineListener : this.lineListeners) {
            lineListener.update(lineEvent);
        }
    }

    public Control getControl(Control.Type type) {
        if (this.isOpen()) {
            for (Control control : this.controls) {
                if (control.getType() != type) continue;
                return control;
            }
        }
        throw new IllegalArgumentException(type.toString() + " not supported");
    }

    public Control[] getControls() {
        if (!this.isOpen()) {
            return new Control[0];
        }
        return this.controls.toArray(new Control[0]);
    }

    public boolean isControlSupported(Control.Type type) {
        for (Control control : this.controls) {
            if (!control.getType().equals(type)) continue;
            return true;
        }
        return false;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void removeLineListener(LineListener lineListener) {
        this.lineListeners.remove(lineListener);
    }
}

