/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.lilypond;

import org.herac.tuxguitar.app.io.TGSongStreamSettingsHandler;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.io.base.TGSongStreamContext;
import org.herac.tuxguitar.io.lilypond.LilypondSettings;
import org.herac.tuxguitar.io.lilypond.LilypondSettingsDialog;
import org.herac.tuxguitar.io.lilypond.LilypondSongExporter;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.util.TGContext;

public class LilypondSettingsHandler
implements TGSongStreamSettingsHandler {
    private TGContext context;

    public LilypondSettingsHandler(TGContext context) {
        this.context = context;
    }

    public String getProviderId() {
        return LilypondSongExporter.PROVIDER_ID;
    }

    public void handleSettings(final TGSongStreamContext context, final Runnable callback) {
        TGSong song = (TGSong)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
        final LilypondSettings settings = LilypondSettings.getDefaults();
        new LilypondSettingsDialog(this.context, song).open(settings, new Runnable(){

            public void run() {
                if (settings != null) {
                    context.setAttribute(LilypondSettings.class.getName(), (Object)settings);
                    callback.run();
                }
            }
        });
    }
}

