/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.graphics.control;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.herac.tuxguitar.graphics.TGResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TGResourceBuffer {
    private List<Object> registry;
    private Map<Object, TGResource> buffer = new HashMap<Object, TGResource>();

    public TGResourceBuffer() {
        this.registry = new ArrayList<Object>();
    }

    public <T extends TGResource> T getResource(Object key) {
        if (this.buffer.containsKey(key)) {
            return (T)this.buffer.get(key);
        }
        return null;
    }

    public void setResource(Object key, TGResource resource) {
        if (this.buffer.containsKey(key)) {
            this.disposeResource(key);
        }
        this.buffer.put(key, resource);
    }

    public void disposeResource(Object key) {
        Object resource = this.getResource(key);
        if (resource != null && !resource.isDisposed()) {
            resource.dispose();
        }
        this.buffer.remove(key);
    }

    public void disposeAllResources() {
        ArrayList<Object> keys = new ArrayList<Object>(this.buffer.keySet());
        for (Object e : keys) {
            this.disposeResource(e);
        }
    }

    public void disposeUnregisteredResources() {
        ArrayList<Object> keys = new ArrayList<Object>(this.buffer.keySet());
        for (Object e : keys) {
            if (this.isRegistered(e)) continue;
            this.disposeResource(e);
        }
    }

    public void clearRegistry() {
        this.registry.clear();
    }

    public void register(Object key) {
        if (!this.isRegistered(key)) {
            this.registry.add(key);
        }
    }

    public void unregister(Object key) {
        if (this.isRegistered(key)) {
            this.registry.remove(key);
        }
    }

    public boolean isRegistered(Object key) {
        return this.registry.contains(key);
    }

    public boolean isResourceDisposed(Object key) {
        Object resource = this.getResource(key);
        return resource == null || resource.isDisposed();
    }
}

