/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.ui.swt.resource;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.ui.resource.UIColor;
import org.herac.tuxguitar.ui.resource.UIFont;
import org.herac.tuxguitar.ui.resource.UIImage;
import org.herac.tuxguitar.ui.resource.UIPainter;
import org.herac.tuxguitar.ui.swt.SWTComponent;
import org.herac.tuxguitar.ui.swt.resource.SWTColor;
import org.herac.tuxguitar.ui.swt.resource.SWTFont;
import org.herac.tuxguitar.ui.swt.resource.SWTImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWTPainter
extends SWTComponent<GC>
implements UIPainter {
    private static final boolean FORCE_OS_DEFAULTS = Boolean.TRUE.toString().equals(System.getProperty("swt.painter.force-os-defaults"));
    private boolean pathEmpty;
    private int style;
    private Path path;

    public SWTPainter() {
        super(null);
    }

    public SWTPainter(GC gc) {
        super(gc);
    }

    public SWTPainter(Image image) {
        this(new GC((Drawable)image));
    }

    public void initPath(int style) {
        this.style = style;
        this.path = new Path(((GC)this.getControl()).getDevice());
        this.pathEmpty = true;
        this.setAntialias(true);
    }

    public void initPath() {
        this.initPath(1);
    }

    public void closePath() {
        if (!this.pathEmpty) {
            if ((this.style & 1) != 0) {
                ((GC)this.getControl()).drawPath(this.path);
            }
            if ((this.style & 2) != 0) {
                ((GC)this.getControl()).fillPath(this.path);
            }
        }
        this.style = 0;
        this.path.dispose();
        this.pathEmpty = true;
        this.setAntialias(false);
    }

    public GC getGC() {
        return (GC)this.getControl();
    }

    public void dispose() {
        ((GC)this.getControl()).dispose();
    }

    public boolean isDisposed() {
        return ((GC)this.getControl()).isDisposed();
    }

    public void drawString(String string, float x, float y) {
        this.setAdvanced(false);
        ((GC)this.getControl()).drawString(string, this.toInt(x), this.toInt(y));
    }

    public void drawString(String string, float x, float y, boolean isTransparent) {
        this.setAdvanced(false);
        ((GC)this.getControl()).drawString(string, this.toInt(x), this.toInt(y), isTransparent);
    }

    public void drawImage(UIImage image, float srcX, float srcY, float srcWidth, float srcHeight, float destX, float destY, float destWidth, float destHeight) {
        this.setAdvanced(false);
        ((GC)this.getControl()).drawImage(this.getImage(image), this.toInt(srcX), this.toInt(srcY), this.toInt(srcWidth), this.toInt(srcHeight), this.toInt(destX), this.toInt(destY), this.toInt(destWidth), this.toInt(destHeight));
    }

    public void drawImage(UIImage image, float x, float y) {
        this.setAdvanced(false);
        ((GC)this.getControl()).drawImage(this.getImage(image), this.toInt(x), this.toInt(y));
    }

    public void cubicTo(float arg0, float arg1, float arg2, float arg3, float arg4, float arg5) {
        this.path.cubicTo(arg0, arg1, arg2, arg3, arg4, arg5);
        this.pathEmpty = false;
    }

    public void lineTo(float arg0, float arg1) {
        this.path.lineTo(arg0, arg1);
        this.pathEmpty = false;
    }

    public void moveTo(float arg0, float arg1) {
        this.path.moveTo(arg0, arg1);
        this.pathEmpty = false;
    }

    public void addString(String arg0, float arg1, float arg2, UIFont font) {
        this.path.addString(arg0, arg1, arg2, this.getFont(font));
        this.pathEmpty = false;
    }

    public void addArc(float arg0, float arg1, float arg2, float arg3, float arg4, float arg5) {
        this.path.addArc(arg0, arg1, arg2, arg3, arg4, arg5);
        this.pathEmpty = false;
    }

    public void addOval(float arg0, float arg1, float arg2, float arg3) {
        this.path.addArc(arg0, arg1, arg2, arg3, 0.0f, 360.0f);
        this.pathEmpty = false;
    }

    public void addRectangle(float x, float y, float width, float height) {
        this.path.addRectangle(x, y, width, height);
        this.pathEmpty = false;
    }

    public void addRectangle(Rectangle rectangle) {
        this.path.addRectangle((float)rectangle.x, (float)rectangle.y, (float)rectangle.width, (float)rectangle.height);
        this.pathEmpty = false;
    }

    public void setFont(UIFont font) {
        ((GC)this.getControl()).setFont(this.getFont(font));
    }

    public void setForeground(UIColor color) {
        ((GC)this.getControl()).setForeground(this.getColor(color));
    }

    public void setBackground(UIColor color) {
        ((GC)this.getControl()).setBackground(this.getColor(color));
    }

    public void setLineWidth(float width) {
        ((GC)this.getControl()).setLineAttributes(new LineAttributes(width == 0.0f ? 1.0f : width));
    }

    public void setLineStyleSolid() {
        ((GC)this.getControl()).setLineStyle(1);
    }

    public void setLineStyleDot() {
        ((GC)this.getControl()).setLineStyle(3);
    }

    public void setLineStyleDash() {
        ((GC)this.getControl()).setLineStyle(2);
    }

    public void setLineStyleDashDot() {
        ((GC)this.getControl()).setLineStyle(4);
    }

    public void setAlpha(int alpha) {
        ((GC)this.getControl()).setAlpha(alpha);
    }

    public void setAntialias(boolean enabled) {
        if (!FORCE_OS_DEFAULTS) {
            ((GC)this.getControl()).setAntialias(enabled ? 1 : 0);
        }
    }

    public void setAdvanced(boolean advanced) {
        if (!FORCE_OS_DEFAULTS) {
            ((GC)this.getControl()).setAdvanced(advanced);
        }
    }

    public float getFontSize() {
        FontData[] fd = ((GC)this.getControl()).getFont().getFontData();
        if (fd != null && fd.length > 0) {
            return fd[0].getHeight();
        }
        return 0.0f;
    }

    public float getFMTopLine() {
        return -(this.getFMAscent() / 10.0f * 2.0f);
    }

    public float getFMMiddleLine() {
        return -(this.getFMAscent() / 10.0f * 6.0f);
    }

    public float getFMBaseLine() {
        return -this.getFMAscent();
    }

    public float getFMAscent() {
        this.setAdvanced(false);
        FontMetrics fm = ((GC)this.getControl()).getFontMetrics();
        return fm.getAscent() + fm.getLeading();
    }

    public float getFMHeight() {
        this.setAdvanced(false);
        return ((GC)this.getControl()).getFontMetrics().getHeight();
    }

    public float getFMWidth(String text) {
        this.setAdvanced(false);
        return ((GC)this.getControl()).stringExtent((String)text).x;
    }

    public Image getImage(UIImage image) {
        if (image instanceof SWTImage) {
            return ((SWTImage)image).getHandle();
        }
        return null;
    }

    public Color getColor(UIColor color) {
        if (color instanceof SWTColor) {
            return ((SWTColor)color).getHandle();
        }
        return null;
    }

    public Font getFont(UIFont font) {
        if (font instanceof SWTFont) {
            return ((SWTFont)font).getHandle();
        }
        return null;
    }

    public int toInt(float value) {
        return Math.round(value);
    }
}

