/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.toolbar.edit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.action.TGActionProcessorListener;
import org.herac.tuxguitar.app.system.icons.TGIconManager;
import org.herac.tuxguitar.app.view.component.tab.Caret;
import org.herac.tuxguitar.app.view.toolbar.edit.TGEditToolBar;
import org.herac.tuxguitar.app.view.toolbar.edit.TGEditToolBarSection;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.resource.UIImage;
import org.herac.tuxguitar.ui.toolbar.UIToolBar;
import org.herac.tuxguitar.ui.toolbar.UIToolCheckableItem;

public class TGEditToolBarSectionDynamic
extends TGEditToolBarSection {
    private static final String SECTION_TITLE = "dynamic";
    private static final String VELOCITY_VALUE = "velocity";
    private List<UIToolCheckableItem> menuItems;
    private Map<Integer, String> dynamicNameKeys = new HashMap<Integer, String>();

    public TGEditToolBarSectionDynamic(TGEditToolBar toolBar) {
        super(toolBar, SECTION_TITLE);
        this.dynamicNameKeys.put(15, "dynamic.piano-pianissimo");
        this.dynamicNameKeys.put(31, "dynamic.pianissimo");
        this.dynamicNameKeys.put(47, "dynamic.piano");
        this.dynamicNameKeys.put(63, "dynamic.mezzo-piano");
        this.dynamicNameKeys.put(79, "dynamic.mezzo-forte");
        this.dynamicNameKeys.put(95, "dynamic.forte");
        this.dynamicNameKeys.put(111, "dynamic.fortissimo");
        this.dynamicNameKeys.put(127, "dynamic.forte-fortissimo");
    }

    public void createSectionToolBars() {
        UIToolBar toolBar = this.createToolBar();
        this.menuItems = new ArrayList<UIToolCheckableItem>();
        this.menuItems.add(this.createToolItem(toolBar, 15));
        this.menuItems.add(this.createToolItem(toolBar, 31));
        this.menuItems.add(this.createToolItem(toolBar, 47));
        this.menuItems.add(this.createToolItem(toolBar, 63));
        toolBar = this.createToolBar();
        this.menuItems.add(this.createToolItem(toolBar, 79));
        this.menuItems.add(this.createToolItem(toolBar, 95));
        this.menuItems.add(this.createToolItem(toolBar, 111));
        this.menuItems.add(this.createToolItem(toolBar, 127));
        this.loadIcons();
        this.loadProperties();
    }

    public void loadProperties() {
        for (UIToolCheckableItem menuItem : this.menuItems) {
            Integer velocity = (Integer)menuItem.getData(VELOCITY_VALUE);
            String nameKey = this.getNameKey(velocity);
            if (nameKey == null) continue;
            menuItem.setToolTipText(this.getText(nameKey));
        }
    }

    public void loadIcons() {
        for (UIToolCheckableItem menuItem : this.menuItems) {
            Integer velocity = (Integer)menuItem.getData(VELOCITY_VALUE);
            UIImage icon = this.getDynamicIcon(velocity);
            if (icon == null) continue;
            menuItem.setImage(icon);
        }
    }

    public void updateItems() {
        Caret caret = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret();
        int selection = caret.getSelectedNote() != null ? caret.getSelectedNote().getVelocity() : caret.getVelocity();
        boolean running = TuxGuitar.getInstance().getPlayer().isRunning();
        for (UIToolCheckableItem menuItem : this.menuItems) {
            menuItem.setEnabled(!running);
            Integer velocity = (Integer)menuItem.getData(VELOCITY_VALUE);
            String nameKey = this.getNameKey(velocity);
            if (nameKey == null) continue;
            menuItem.setChecked(velocity == selection);
        }
    }

    private UIToolCheckableItem createToolItem(UIToolBar toolBar, int velocity) {
        UIToolCheckableItem menuItem = toolBar.createCheckItem();
        menuItem.setData(VELOCITY_VALUE, (Object)velocity);
        menuItem.addSelectionListener((UISelectionListener)this.createChangeVelocityAction(velocity));
        return menuItem;
    }

    private String getNameKey(int velocity) {
        if (this.dynamicNameKeys.containsKey(velocity)) {
            return this.dynamicNameKeys.get(velocity);
        }
        return null;
    }

    private UIImage getDynamicIcon(int velocity) {
        TGIconManager iconManager = this.getIconManager();
        if (velocity == 15) {
            return iconManager.getDynamicPPP();
        }
        if (velocity == 31) {
            return iconManager.getDynamicPP();
        }
        if (velocity == 47) {
            return iconManager.getDynamicP();
        }
        if (velocity == 63) {
            return iconManager.getDynamicMP();
        }
        if (velocity == 79) {
            return iconManager.getDynamicMF();
        }
        if (velocity == 95) {
            return iconManager.getDynamicF();
        }
        if (velocity == 111) {
            return iconManager.getDynamicFF();
        }
        if (velocity == 127) {
            return iconManager.getDynamicFFF();
        }
        return null;
    }

    public TGActionProcessorListener createChangeVelocityAction(Integer velocity) {
        TGActionProcessorListener tgActionProcessor = this.createActionProcessor("action.note.general.velocity");
        tgActionProcessor.setAttribute(VELOCITY_VALUE, velocity);
        return tgActionProcessor;
    }
}

