/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.toolbar.edit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.action.TGActionProcessorListener;
import org.herac.tuxguitar.app.view.component.tab.TablatureEditor;
import org.herac.tuxguitar.app.view.toolbar.edit.TGEditToolBar;
import org.herac.tuxguitar.app.view.toolbar.edit.TGEditToolBarSection;
import org.herac.tuxguitar.document.TGDocumentManager;
import org.herac.tuxguitar.editor.action.duration.TGSetDivisionTypeDurationAction;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGDivisionType;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.menu.UIMenuCheckableItem;
import org.herac.tuxguitar.ui.resource.UIImage;
import org.herac.tuxguitar.ui.toolbar.UIToolActionItem;
import org.herac.tuxguitar.ui.toolbar.UIToolActionMenuItem;
import org.herac.tuxguitar.ui.toolbar.UIToolBar;
import org.herac.tuxguitar.ui.toolbar.UIToolCheckableItem;
import org.herac.tuxguitar.util.TGContext;

public class TGEditToolBarSectionDuration
extends TGEditToolBarSection {
    private static final String SECTION_TITLE = "duration";
    private static final String DURATION_VALUE = "duration";
    private UIToolCheckableItem dotted;
    private UIToolCheckableItem doubleDotted;
    private UIToolActionMenuItem divisionTypeItem;
    private UIToolCheckableItem tiedNote;
    private List<UIToolCheckableItem> durationToolItems;
    private List<UIMenuCheckableItem> divisionTypeMenuItems;
    private Map<Integer, String> durationNameKeys;
    private Map<Integer, String> durationActions;

    public TGEditToolBarSectionDuration(TGEditToolBar toolBar) {
        super(toolBar, "duration");
        this.createDurationNames();
        this.createDurationActions();
    }

    public void createSectionToolBars() {
        UIToolBar toolBar1 = this.createToolBar();
        UIToolBar toolBar2 = this.createToolBar();
        this.durationToolItems = new ArrayList<UIToolCheckableItem>();
        this.durationToolItems.add(this.createDurationToolItem(toolBar1, 1));
        this.durationToolItems.add(this.createDurationToolItem(toolBar1, 2));
        this.durationToolItems.add(this.createDurationToolItem(toolBar1, 4));
        this.durationToolItems.add(this.createDurationToolItem(toolBar1, 8));
        this.durationToolItems.add(this.createDurationToolItem(toolBar1, 16));
        this.durationToolItems.add(this.createDurationToolItem(toolBar1, 32));
        this.durationToolItems.add(this.createDurationToolItem(toolBar2, 64));
        this.dotted = toolBar2.createCheckItem();
        this.dotted.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.duration.change-dotted"));
        this.doubleDotted = toolBar2.createCheckItem();
        this.doubleDotted.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.duration.change-double-dotted"));
        this.divisionTypeItem = toolBar2.createActionMenuItem();
        this.divisionTypeItem.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGEditToolBarSectionDuration.this.toggleDivisionType();
            }
        });
        this.divisionTypeMenuItems = new ArrayList<UIMenuCheckableItem>();
        for (int i = 0; i < TGDivisionType.ALTERED_DIVISION_TYPES.length; ++i) {
            this.divisionTypeMenuItems.add(this.createDivisionTypeMenuItem(TGDivisionType.ALTERED_DIVISION_TYPES[i]));
        }
        this.tiedNote = toolBar2.createCheckItem();
        this.tiedNote.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.general.tied"));
        this.loadIcons();
        this.loadProperties();
    }

    public void updateItems() {
        TGNote note = this.getTablature().getCaret().getSelectedNote();
        TGDuration duration = this.getTablature().getCaret().getDuration();
        boolean running = TuxGuitar.getInstance().getPlayer().isRunning();
        this.dotted.setChecked(duration.isDotted());
        this.dotted.setEnabled(!running);
        this.doubleDotted.setChecked(duration.isDoubleDotted());
        this.doubleDotted.setEnabled(!running);
        this.divisionTypeItem.setEnabled(!running);
        this.tiedNote.setEnabled(!running);
        this.tiedNote.setChecked(note != null && note.isTiedNote());
        this.updateDurationToolItems(duration.getValue(), running);
        this.updateDivisionTypeMenuItems(duration.getDivision(), running);
    }

    public void loadProperties() {
        TGDuration duration = this.getTablature().getCaret().getDuration();
        this.dotted.setToolTipText(this.getText("duration.dotted"));
        this.doubleDotted.setToolTipText(this.getText("duration.doubledotted"));
        this.divisionTypeItem.setToolTipText(this.getText("duration.division-type"));
        this.tiedNote.setToolTipText(this.getText("note.tiednote"));
        this.loadDurationToolProperties(duration.getValue());
        this.loadDivisionTypeMenuProperties();
    }

    public void loadIcons() {
        this.dotted.setImage(this.getIconManager().getDurationDotted());
        this.doubleDotted.setImage(this.getIconManager().getDurationDoubleDotted());
        this.divisionTypeItem.setImage(this.getIconManager().getDivisionType());
        this.tiedNote.setImage(this.getIconManager().getNoteTied());
        this.loadDurationToolIcons();
    }

    private UIToolCheckableItem createDurationToolItem(UIToolBar toolBar, int value) {
        UIToolCheckableItem toolItem = toolBar.createCheckItem();
        toolItem.setData("duration", (Object)value);
        String action = this.findDurationAction(value);
        if (action != null) {
            toolItem.addSelectionListener((UISelectionListener)this.createActionProcessor(action));
        }
        return toolItem;
    }

    private void updateDurationToolItems(int selection, boolean running) {
        for (UIToolCheckableItem uiToolItem : this.durationToolItems) {
            Integer value = (Integer)uiToolItem.getData("duration");
            String nameKey = this.findDurationNameKey(value);
            if (nameKey == null) continue;
            uiToolItem.setEnabled(!running);
            uiToolItem.setChecked(value == selection);
        }
    }

    private void loadDurationToolIcons() {
        for (UIToolActionItem uIToolActionItem : this.durationToolItems) {
            Integer value = (Integer)uIToolActionItem.getData("duration");
            UIImage icon = this.findDurationIcon(value);
            if (icon == null) continue;
            uIToolActionItem.setImage(icon);
        }
    }

    private void loadDurationToolProperties(int selection) {
        for (UIToolActionItem uIToolActionItem : this.durationToolItems) {
            Integer value = (Integer)uIToolActionItem.getData("duration");
            String nameKey = this.findDurationNameKey(value);
            if (nameKey == null) continue;
            uIToolActionItem.setToolTipText(this.getText(nameKey));
        }
    }

    private void createDurationNames() {
        this.durationNameKeys = new HashMap<Integer, String>();
        this.durationNameKeys.put(1, "duration.whole");
        this.durationNameKeys.put(2, "duration.half");
        this.durationNameKeys.put(4, "duration.quarter");
        this.durationNameKeys.put(8, "duration.eighth");
        this.durationNameKeys.put(16, "duration.sixteenth");
        this.durationNameKeys.put(32, "duration.thirtysecond");
        this.durationNameKeys.put(64, "duration.sixtyfourth");
    }

    private void createDurationActions() {
        this.durationActions = new HashMap<Integer, String>();
        this.durationActions.put(1, "action.note.duration.set-whole");
        this.durationActions.put(2, "action.note.duration.set-half");
        this.durationActions.put(4, "action.note.duration.set-quarter");
        this.durationActions.put(8, "action.note.duration.set-eighth");
        this.durationActions.put(16, "action.note.duration.set-sixteenth");
        this.durationActions.put(32, "action.note.duration.set-thirty-second");
        this.durationActions.put(64, "action.note.duration.set-sixty-fourth");
    }

    private String findDurationNameKey(int value) {
        if (this.durationNameKeys.containsKey(value)) {
            return this.durationNameKeys.get(value);
        }
        return null;
    }

    private String findDurationAction(int value) {
        if (this.durationActions.containsKey(value)) {
            return this.durationActions.get(value);
        }
        return null;
    }

    private UIImage findDurationIcon(int value) {
        return this.getIconManager().getDuration(value);
    }

    private void toggleDivisionType() {
        TGDuration duration = TablatureEditor.getInstance(this.getToolBar().getContext()).getTablature().getCaret().getDuration();
        TGDivisionType divisionType = null;
        divisionType = duration.getDivision().isEqual(TGDivisionType.NORMAL) ? this.createDivisionType(TGDivisionType.TRIPLET) : this.createDivisionType(TGDivisionType.NORMAL);
        this.createDivisionTypeAction(divisionType).process();
    }

    private UIMenuCheckableItem createDivisionTypeMenuItem(TGDivisionType divisionType) {
        UIMenuCheckableItem uiMenuItem = this.divisionTypeItem.getMenu().createCheckItem();
        uiMenuItem.setData(TGDivisionType.class.getName(), (Object)divisionType);
        uiMenuItem.addSelectionListener((UISelectionListener)this.createDivisionTypeAction(divisionType));
        return uiMenuItem;
    }

    private void updateDivisionTypeMenuItems(TGDivisionType selection, boolean running) {
        for (UIMenuCheckableItem uiMenuItem : this.divisionTypeMenuItems) {
            TGDivisionType divisionType = (TGDivisionType)uiMenuItem.getData(TGDivisionType.class.getName());
            uiMenuItem.setChecked(divisionType.isEqual(selection));
        }
    }

    private void loadDivisionTypeMenuProperties() {
        for (UIMenuCheckableItem uiMenuItem : this.divisionTypeMenuItems) {
            TGDivisionType divisionType = (TGDivisionType)uiMenuItem.getData(TGDivisionType.class.getName());
            uiMenuItem.setText(Integer.toString(divisionType.getEnters()));
        }
    }

    private TGDivisionType createDivisionType(TGDivisionType tgDivisionTypeSrc) {
        TGFactory tgFactory = TGDocumentManager.getInstance((TGContext)this.getToolBar().getContext()).getSongManager().getFactory();
        TGDivisionType tgDivisionTypeDst = tgFactory.newDivisionType();
        tgDivisionTypeDst.copyFrom(tgDivisionTypeSrc);
        return tgDivisionTypeDst;
    }

    private TGActionProcessorListener createDivisionTypeAction(TGDivisionType tgDivisionType) {
        TGActionProcessorListener tgActionProcessor = this.createActionProcessor("action.note.duration.set-division-type");
        tgActionProcessor.setAttribute(TGSetDivisionTypeDurationAction.PROPERTY_DIVISION_TYPE, this.createDivisionType(tgDivisionType));
        return tgActionProcessor;
    }
}

