/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.menu.impl;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.view.menu.TGMenuItem;
import org.herac.tuxguitar.graphics.control.TGMeasureImpl;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.menu.UIMenu;
import org.herac.tuxguitar.ui.menu.UIMenuActionItem;
import org.herac.tuxguitar.ui.menu.UIMenuItem;
import org.herac.tuxguitar.ui.menu.UIMenuSubMenuItem;

public class MeasureMenuItem
extends TGMenuItem {
    private UIMenuSubMenuItem measureMenuItem;
    private UIMenuActionItem first;
    private UIMenuActionItem last;
    private UIMenuActionItem next;
    private UIMenuActionItem previous;
    private UIMenuActionItem addMeasure;
    private UIMenuActionItem cleanMeasure;
    private UIMenuActionItem removeMeasure;
    private UIMenuActionItem copyMeasure;
    private UIMenuActionItem pasteMeasure;

    public MeasureMenuItem(UIMenu parent) {
        this.measureMenuItem = parent.createSubMenuItem();
    }

    public void showItems() {
        this.first = this.measureMenuItem.getMenu().createActionItem();
        this.first.addSelectionListener((UISelectionListener)this.createActionProcessor("action.measure.go-first"));
        this.previous = this.measureMenuItem.getMenu().createActionItem();
        this.previous.addSelectionListener((UISelectionListener)this.createActionProcessor("action.measure.go-previous"));
        this.next = this.measureMenuItem.getMenu().createActionItem();
        this.next.addSelectionListener((UISelectionListener)this.createActionProcessor("action.measure.go-next"));
        this.last = this.measureMenuItem.getMenu().createActionItem();
        this.last.addSelectionListener((UISelectionListener)this.createActionProcessor("action.measure.go-last"));
        this.measureMenuItem.getMenu().createSeparator();
        this.addMeasure = this.measureMenuItem.getMenu().createActionItem();
        this.addMeasure.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-measure-add-dialog"));
        this.cleanMeasure = this.measureMenuItem.getMenu().createActionItem();
        this.cleanMeasure.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-measure-clean-dialog"));
        this.removeMeasure = this.measureMenuItem.getMenu().createActionItem();
        this.removeMeasure.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-measure-remove-dialog"));
        this.measureMenuItem.getMenu().createSeparator();
        this.copyMeasure = this.measureMenuItem.getMenu().createActionItem();
        this.copyMeasure.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-measure-copy-dialog"));
        this.pasteMeasure = this.measureMenuItem.getMenu().createActionItem();
        this.pasteMeasure.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-measure-paste-dialog"));
        this.loadIcons();
        this.loadProperties();
    }

    public void update() {
        TGMeasureImpl measure = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getMeasure();
        boolean running = TuxGuitar.getInstance().getPlayer().isRunning();
        boolean isFirst = measure.getNumber() == 1;
        boolean isLast = measure.getNumber() == measure.getTrack().countMeasures();
        this.first.setEnabled(!isFirst);
        this.previous.setEnabled(!isFirst);
        this.next.setEnabled(!isLast);
        this.last.setEnabled(!isLast);
        this.addMeasure.setEnabled(!running);
        this.cleanMeasure.setEnabled(!running);
        this.removeMeasure.setEnabled(!running);
        this.copyMeasure.setEnabled(!running);
        this.pasteMeasure.setEnabled(!running && !TuxGuitar.getInstance().getTablatureEditor().getClipBoard().isEmpty());
    }

    public void loadProperties() {
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.measureMenuItem, "measure", null);
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.first, "measure.first", "action.measure.go-first");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.last, "measure.last", "action.measure.go-last");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.previous, "measure.previous", "action.measure.go-previous");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.next, "measure.next", "action.measure.go-next");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.addMeasure, "measure.add", "action.gui.open-measure-add-dialog");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.cleanMeasure, "measure.clean", "action.gui.open-measure-clean-dialog");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.removeMeasure, "measure.remove", "action.gui.open-measure-remove-dialog");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.copyMeasure, "measure.copy", "action.gui.open-measure-copy-dialog");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.pasteMeasure, "measure.paste", "action.gui.open-measure-paste-dialog");
    }

    public void loadIcons() {
    }
}

