/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.menu.impl;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.action.TGActionProcessorListener;
import org.herac.tuxguitar.app.action.impl.file.TGExportFileAction;
import org.herac.tuxguitar.app.action.impl.file.TGExportSongAction;
import org.herac.tuxguitar.app.action.impl.file.TGImportFileAction;
import org.herac.tuxguitar.app.action.impl.file.TGImportSongAction;
import org.herac.tuxguitar.app.action.impl.file.TGReadURLAction;
import org.herac.tuxguitar.app.helper.TGFileHistory;
import org.herac.tuxguitar.app.view.menu.TGMenuItem;
import org.herac.tuxguitar.editor.action.file.TGLoadTemplateAction;
import org.herac.tuxguitar.editor.template.TGTemplate;
import org.herac.tuxguitar.editor.template.TGTemplateManager;
import org.herac.tuxguitar.io.base.TGLocalFileExporter;
import org.herac.tuxguitar.io.base.TGLocalFileImporter;
import org.herac.tuxguitar.io.base.TGRawExporter;
import org.herac.tuxguitar.io.base.TGRawImporter;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.menu.UIMenu;
import org.herac.tuxguitar.ui.menu.UIMenuActionItem;
import org.herac.tuxguitar.ui.menu.UIMenuItem;
import org.herac.tuxguitar.ui.menu.UIMenuSubMenuItem;
import org.herac.tuxguitar.util.TGContext;

public class FileMenuItem
extends TGMenuItem {
    private UIMenuSubMenuItem fileMenuItem;
    private UIMenuSubMenuItem newSong;
    private UIMenuActionItem newSongDefault;
    private UIMenuActionItem open;
    private UIMenuActionItem openURL;
    private UIMenuActionItem save;
    private UIMenuActionItem saveAs;
    private UIMenuActionItem close;
    private UIMenuActionItem closeOthers;
    private UIMenuActionItem closeAll;
    private UIMenuSubMenuItem importItem;
    private UIMenuSubMenuItem exportItem;
    private UIMenuActionItem printPreview;
    private UIMenuActionItem print;
    private UIMenuSubMenuItem historyItem;
    private UIMenuActionItem[] historyFiles;
    private UIMenuActionItem exit;
    private List<UIMenuActionItem> importItems;
    private List<UIMenuActionItem> exportItems;

    public FileMenuItem(UIMenu parent) {
        this.fileMenuItem = parent.createSubMenuItem();
        this.importItems = new ArrayList<UIMenuActionItem>();
        this.exportItems = new ArrayList<UIMenuActionItem>();
    }

    public void showItems() {
        this.newSong = this.fileMenuItem.getMenu().createSubMenuItem();
        this.newSongDefault = this.newSong.getMenu().createActionItem();
        this.newSongDefault.addSelectionListener((UISelectionListener)this.createNewSongFromTemplateActionProcessor(null));
        this.addNewSongTemplates();
        this.open = this.fileMenuItem.getMenu().createActionItem();
        this.open.addSelectionListener((UISelectionListener)this.createActionProcessor("action.file.open"));
        this.openURL = this.fileMenuItem.getMenu().createActionItem();
        this.openURL.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-url-dialog"));
        this.fileMenuItem.getMenu().createSeparator();
        this.close = this.fileMenuItem.getMenu().createActionItem();
        this.close.addSelectionListener((UISelectionListener)this.createActionProcessor("action.file.close-current"));
        this.closeOthers = this.fileMenuItem.getMenu().createActionItem();
        this.closeOthers.addSelectionListener((UISelectionListener)this.createActionProcessor("action.file.close-others"));
        this.closeAll = this.fileMenuItem.getMenu().createActionItem();
        this.closeAll.addSelectionListener((UISelectionListener)this.createActionProcessor("action.file.close-all"));
        this.fileMenuItem.getMenu().createSeparator();
        this.save = this.fileMenuItem.getMenu().createActionItem();
        this.save.addSelectionListener((UISelectionListener)this.createActionProcessor("action.file.save"));
        this.saveAs = this.fileMenuItem.getMenu().createActionItem();
        this.saveAs.addSelectionListener((UISelectionListener)this.createActionProcessor("action.file.save-as"));
        int countImporters = TuxGuitar.getInstance().getFileFormatManager().countImporters();
        int countExporters = TuxGuitar.getInstance().getFileFormatManager().countExporters();
        if (countImporters + countExporters > 0) {
            this.fileMenuItem.getMenu().createSeparator();
            this.importItems.clear();
            if (countImporters > 0) {
                this.importItem = this.fileMenuItem.getMenu().createSubMenuItem();
                this.addImporters();
            }
            this.exportItems.clear();
            if (countExporters > 0) {
                this.exportItem = this.fileMenuItem.getMenu().createSubMenuItem();
                this.addExporters();
            }
        }
        this.fileMenuItem.getMenu().createSeparator();
        this.printPreview = this.fileMenuItem.getMenu().createActionItem();
        this.printPreview.addSelectionListener((UISelectionListener)this.createActionProcessor("action.file.print-preview"));
        this.print = this.fileMenuItem.getMenu().createActionItem();
        this.print.addSelectionListener((UISelectionListener)this.createActionProcessor("action.file.print"));
        this.fileMenuItem.getMenu().createSeparator();
        this.historyItem = this.fileMenuItem.getMenu().createSubMenuItem();
        this.updateHistoryFiles();
        this.fileMenuItem.getMenu().createSeparator();
        this.exit = this.fileMenuItem.getMenu().createActionItem();
        this.exit.addSelectionListener((UISelectionListener)this.createActionProcessor("action.file.exit"));
        this.loadIcons();
        this.loadProperties();
    }

    private void addNewSongTemplates() {
        TGTemplateManager templateManager = TGTemplateManager.getInstance((TGContext)this.findContext());
        if (templateManager.countTemplates() > 0) {
            this.newSong.getMenu().createSeparator();
            Iterator it = templateManager.getTemplates();
            while (it.hasNext()) {
                TGTemplate tgTemplate = (TGTemplate)it.next();
                UIMenuActionItem uiMenuItem = this.newSong.getMenu().createActionItem();
                uiMenuItem.setText(tgTemplate.getName());
                uiMenuItem.addSelectionListener((UISelectionListener)this.createNewSongFromTemplateActionProcessor(tgTemplate));
            }
        }
    }

    private void addImporters() {
        UIMenuActionItem uiMenuItem;
        TGLocalFileImporter importer;
        int i;
        ArrayList<TGRawImporter> importersRaw = new ArrayList<TGRawImporter>();
        ArrayList<TGLocalFileImporter> importersFile = new ArrayList<TGLocalFileImporter>();
        Iterator importers = TuxGuitar.getInstance().getFileFormatManager().getImporters();
        while (importers.hasNext()) {
            TGRawImporter importer2 = (TGRawImporter)importers.next();
            if (importer2 instanceof TGLocalFileImporter) {
                importersFile.add((TGLocalFileImporter)importer2);
                continue;
            }
            importersRaw.add(importer2);
        }
        for (i = 0; i < importersFile.size(); ++i) {
            importer = (TGLocalFileImporter)importersFile.get(i);
            uiMenuItem = this.importItem.getMenu().createActionItem();
            uiMenuItem.setData(TGRawImporter.class.getName(), (Object)importer);
            uiMenuItem.addSelectionListener((UISelectionListener)this.createImportFileActionProcessor(importer));
            this.importItems.add(uiMenuItem);
        }
        if (!importersFile.isEmpty() && !importersRaw.isEmpty()) {
            this.importItem.getMenu().createSeparator();
        }
        for (i = 0; i < importersRaw.size(); ++i) {
            importer = (TGRawImporter)importersRaw.get(i);
            uiMenuItem = this.importItem.getMenu().createActionItem();
            uiMenuItem.setData(TGRawImporter.class.getName(), (Object)importer);
            uiMenuItem.addSelectionListener((UISelectionListener)this.createImportSongActionProcessor((TGRawImporter)importer));
            this.importItems.add(uiMenuItem);
        }
    }

    private void addExporters() {
        UIMenuActionItem uiMenuItem;
        TGLocalFileExporter exporter;
        int i;
        ArrayList<TGRawExporter> exportersRaw = new ArrayList<TGRawExporter>();
        ArrayList<TGLocalFileExporter> exportersFile = new ArrayList<TGLocalFileExporter>();
        Iterator exporters = TuxGuitar.getInstance().getFileFormatManager().getExporters();
        while (exporters.hasNext()) {
            TGRawExporter exporter2 = (TGRawExporter)exporters.next();
            if (exporter2 instanceof TGLocalFileExporter) {
                exportersFile.add((TGLocalFileExporter)exporter2);
                continue;
            }
            exportersRaw.add(exporter2);
        }
        for (i = 0; i < exportersFile.size(); ++i) {
            exporter = (TGLocalFileExporter)exportersFile.get(i);
            uiMenuItem = this.exportItem.getMenu().createActionItem();
            uiMenuItem.setData(TGRawExporter.class.getName(), (Object)exporter);
            uiMenuItem.addSelectionListener((UISelectionListener)this.createExportFileActionProcessor(exporter));
            this.exportItems.add(uiMenuItem);
        }
        if (!exportersFile.isEmpty() && !exportersRaw.isEmpty()) {
            this.exportItem.getMenu().createSeparator();
        }
        for (i = 0; i < exportersRaw.size(); ++i) {
            exporter = (TGRawExporter)exportersRaw.get(i);
            uiMenuItem = this.exportItem.getMenu().createActionItem();
            uiMenuItem.setData(TGRawExporter.class.getName(), (Object)exporter);
            uiMenuItem.addSelectionListener((UISelectionListener)this.createExportSongActionProcessor((TGRawExporter)exporter));
            this.exportItems.add(uiMenuItem);
        }
    }

    private void disposeHistoryFiles() {
        for (int i = 0; i < this.historyFiles.length; ++i) {
            this.historyFiles[i].dispose();
        }
    }

    private void updateHistoryFiles() {
        List<URL> urls = TGFileHistory.getInstance(this.findContext()).getURLs();
        this.historyFiles = new UIMenuActionItem[urls.size()];
        for (int i = 0; i < this.historyFiles.length; ++i) {
            URL url = urls.get(i);
            this.historyFiles[i] = this.historyItem.getMenu().createActionItem();
            this.historyFiles[i].setText(this.decode(url.toString()));
            this.historyFiles[i].addSelectionListener((UISelectionListener)this.createOpenUrlActionProcessor(url));
        }
        this.historyItem.setEnabled(this.historyFiles.length > 0);
    }

    public TGActionProcessorListener createOpenUrlActionProcessor(URL url) {
        TGActionProcessorListener tgActionProcessorListener = this.createActionProcessor("action.url.read");
        tgActionProcessorListener.setAttribute(TGReadURLAction.ATTRIBUTE_URL, url);
        return tgActionProcessorListener;
    }

    public TGActionProcessorListener createNewSongFromTemplateActionProcessor(TGTemplate template) {
        TGActionProcessorListener tgActionProcessorListener = this.createActionProcessor("action.song.new-from-template");
        tgActionProcessorListener.setAttribute(TGLoadTemplateAction.ATTRIBUTE_TEMPLATE, template);
        return tgActionProcessorListener;
    }

    public TGActionProcessorListener createImportFileActionProcessor(TGLocalFileImporter importer) {
        TGActionProcessorListener tgActionProcessorListener = this.createActionProcessor("action.file.import");
        tgActionProcessorListener.setAttribute(TGImportFileAction.ATTRIBUTE_PROVIDER, importer);
        return tgActionProcessorListener;
    }

    public TGActionProcessorListener createImportSongActionProcessor(TGRawImporter importer) {
        TGActionProcessorListener tgActionProcessorListener = this.createActionProcessor("action.song.import");
        tgActionProcessorListener.setAttribute(TGImportSongAction.ATTRIBUTE_PROVIDER, importer);
        return tgActionProcessorListener;
    }

    public TGActionProcessorListener createExportFileActionProcessor(TGLocalFileExporter exporter) {
        TGActionProcessorListener tgActionProcessorListener = this.createActionProcessor("action.file.export");
        tgActionProcessorListener.setAttribute(TGExportFileAction.ATTRIBUTE_PROVIDER, exporter);
        return tgActionProcessorListener;
    }

    public TGActionProcessorListener createExportSongActionProcessor(TGRawExporter exporter) {
        TGActionProcessorListener tgActionProcessorListener = this.createActionProcessor("action.song.export");
        tgActionProcessorListener.setAttribute(TGExportSongAction.ATTRIBUTE_PROVIDER, exporter);
        return tgActionProcessorListener;
    }

    private String decode(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return url;
        }
    }

    public void update() {
        TGFileHistory fileHistory = TGFileHistory.getInstance(this.findContext());
        if (fileHistory.isChanged()) {
            this.disposeHistoryFiles();
            this.updateHistoryFiles();
            fileHistory.setChanged(false);
        }
    }

    public void loadProperties() {
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.fileMenuItem, "file", null);
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.newSong, "file.new", null);
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.newSongDefault, "file.new-song.default-template", "action.song.new-from-template");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.open, "file.open", "action.file.open");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.openURL, "file.open-url", "action.gui.open-url-dialog");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.close, "file.close", "action.file.close-current");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.closeOthers, "file.close-others", "action.file.close-others");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.closeAll, "file.close-all", "action.file.close-all");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.save, "file.save", "action.file.save");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.saveAs, "file.save-as", "action.file.save-as");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.printPreview, "file.print-preview", "action.file.print-preview");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.print, "file.print", "action.file.print");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.historyItem, "file.history", null);
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.exit, "file.exit", "action.file.exit");
        if (this.importItem != null) {
            this.setMenuItemTextAndAccelerator((UIMenuItem)this.importItem, "file.import", "action.file.import");
            for (UIMenuActionItem item : this.importItems) {
                TGRawImporter itemImporter = (TGRawImporter)item.getData(TGRawImporter.class.getName());
                if (itemImporter instanceof TGLocalFileImporter) {
                    item.setText(TuxGuitar.getProperty("file.import") + " " + itemImporter.getImportName());
                    continue;
                }
                item.setText(itemImporter.getImportName());
            }
        }
        if (this.exportItem != null) {
            this.setMenuItemTextAndAccelerator((UIMenuItem)this.exportItem, "file.export", "action.file.export");
            for (UIMenuActionItem item : this.exportItems) {
                TGRawExporter itemExporter = (TGRawExporter)item.getData(TGRawExporter.class.getName());
                if (itemExporter instanceof TGLocalFileExporter) {
                    item.setText(TuxGuitar.getProperty("file.export") + " " + itemExporter.getExportName());
                    continue;
                }
                item.setText(itemExporter.getExportName());
            }
        }
    }

    public void loadIcons() {
        this.newSong.setImage(TuxGuitar.getInstance().getIconManager().getFileNew());
        this.open.setImage(TuxGuitar.getInstance().getIconManager().getFileOpen());
        this.save.setImage(TuxGuitar.getInstance().getIconManager().getFileSave());
        this.saveAs.setImage(TuxGuitar.getInstance().getIconManager().getFileSaveAs());
        this.printPreview.setImage(TuxGuitar.getInstance().getIconManager().getFilePrintPreview());
        this.print.setImage(TuxGuitar.getInstance().getIconManager().getFilePrint());
    }
}

