/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.menu.impl;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.action.TGActionProcessorListener;
import org.herac.tuxguitar.app.view.component.tab.TablatureEditor;
import org.herac.tuxguitar.app.view.menu.TGMenuItem;
import org.herac.tuxguitar.document.TGDocumentManager;
import org.herac.tuxguitar.editor.action.duration.TGSetDivisionTypeDurationAction;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGDivisionType;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.menu.UIMenu;
import org.herac.tuxguitar.ui.menu.UIMenuActionItem;
import org.herac.tuxguitar.ui.menu.UIMenuItem;
import org.herac.tuxguitar.ui.menu.UIMenuSubMenuItem;
import org.herac.tuxguitar.util.TGContext;

public class DurationMenuItem
extends TGMenuItem {
    private UIMenuSubMenuItem durationMenuItem;
    private UIMenuActionItem whole;
    private UIMenuActionItem half;
    private UIMenuActionItem quarter;
    private UIMenuActionItem eighth;
    private UIMenuActionItem sixteenth;
    private UIMenuActionItem thirtySecond;
    private UIMenuActionItem sixtyFourth;
    private UIMenuActionItem dotted;
    private UIMenuActionItem doubleDotted;
    private UIMenuActionItem division;

    public DurationMenuItem(UIMenuSubMenuItem durationMenuItem) {
        this.durationMenuItem = durationMenuItem;
    }

    public DurationMenuItem(UIMenu parent) {
        this(parent.createSubMenuItem());
    }

    public void showItems() {
        this.whole = this.durationMenuItem.getMenu().createActionItem();
        this.whole.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.duration.set-whole"));
        this.half = this.durationMenuItem.getMenu().createActionItem();
        this.half.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.duration.set-half"));
        this.quarter = this.durationMenuItem.getMenu().createActionItem();
        this.quarter.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.duration.set-quarter"));
        this.eighth = this.durationMenuItem.getMenu().createActionItem();
        this.eighth.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.duration.set-eighth"));
        this.sixteenth = this.durationMenuItem.getMenu().createActionItem();
        this.sixteenth.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.duration.set-sixteenth"));
        this.thirtySecond = this.durationMenuItem.getMenu().createActionItem();
        this.thirtySecond.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.duration.set-thirty-second"));
        this.sixtyFourth = this.durationMenuItem.getMenu().createActionItem();
        this.sixtyFourth.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.duration.set-sixty-fourth"));
        this.durationMenuItem.getMenu().createSeparator();
        this.dotted = this.durationMenuItem.getMenu().createActionItem();
        this.dotted.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.duration.change-dotted"));
        this.doubleDotted = this.durationMenuItem.getMenu().createActionItem();
        this.doubleDotted.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.duration.change-double-dotted"));
        this.division = this.durationMenuItem.getMenu().createActionItem();
        this.division.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                DurationMenuItem.this.toggleDivisionType();
            }
        });
        this.loadIcons();
        this.loadProperties();
    }

    public void update() {
        boolean running = TuxGuitar.getInstance().getPlayer().isRunning();
        this.whole.setEnabled(!running);
        this.half.setEnabled(!running);
        this.quarter.setEnabled(!running);
        this.eighth.setEnabled(!running);
        this.sixteenth.setEnabled(!running);
        this.thirtySecond.setEnabled(!running);
        this.sixtyFourth.setEnabled(!running);
        this.dotted.setEnabled(!running);
        this.doubleDotted.setEnabled(!running);
        this.division.setEnabled(!running);
    }

    public void loadProperties() {
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.durationMenuItem, "duration", null);
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.whole, "duration.whole", "action.note.duration.set-whole");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.half, "duration.half", "action.note.duration.set-half");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.quarter, "duration.quarter", "action.note.duration.set-quarter");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.eighth, "duration.eighth", "action.note.duration.set-eighth");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.sixteenth, "duration.sixteenth", "action.note.duration.set-sixteenth");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.thirtySecond, "duration.thirtysecond", "action.note.duration.set-thirty-second");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.sixtyFourth, "duration.sixtyfourth", "action.note.duration.set-sixty-fourth");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.dotted, "duration.dotted", "action.note.duration.change-dotted");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.doubleDotted, "duration.doubledotted", "action.note.duration.change-double-dotted");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.division, "duration.division-type", "action.note.duration.set-division-type");
    }

    public void loadIcons() {
        this.whole.setImage(TuxGuitar.getInstance().getIconManager().getDuration(1));
        this.half.setImage(TuxGuitar.getInstance().getIconManager().getDuration(2));
        this.quarter.setImage(TuxGuitar.getInstance().getIconManager().getDuration(4));
        this.eighth.setImage(TuxGuitar.getInstance().getIconManager().getDuration(8));
        this.sixteenth.setImage(TuxGuitar.getInstance().getIconManager().getDuration(16));
        this.thirtySecond.setImage(TuxGuitar.getInstance().getIconManager().getDuration(32));
        this.sixtyFourth.setImage(TuxGuitar.getInstance().getIconManager().getDuration(64));
        this.dotted.setImage(TuxGuitar.getInstance().getIconManager().getDurationDotted());
        this.doubleDotted.setImage(TuxGuitar.getInstance().getIconManager().getDurationDoubleDotted());
        this.division.setImage(TuxGuitar.getInstance().getIconManager().getDivisionType());
    }

    private void toggleDivisionType() {
        TGDuration duration = TablatureEditor.getInstance(this.findContext()).getTablature().getCaret().getDuration();
        TGDivisionType divisionType = duration.getDivision().isEqual(TGDivisionType.NORMAL) ? TGDivisionType.TRIPLET : TGDivisionType.NORMAL;
        this.createDivisionTypeAction(this.createDivisionType(divisionType)).process();
    }

    private TGDivisionType createDivisionType(TGDivisionType tgDivisionTypeSrc) {
        TGFactory tgFactory = TGDocumentManager.getInstance((TGContext)this.findContext()).getSongManager().getFactory();
        TGDivisionType tgDivisionTypeDst = tgFactory.newDivisionType();
        tgDivisionTypeDst.copyFrom(tgDivisionTypeSrc);
        return tgDivisionTypeDst;
    }

    private TGActionProcessorListener createDivisionTypeAction(TGDivisionType tgDivisionType) {
        TGActionProcessorListener tgActionProcessor = this.createActionProcessor("action.note.duration.set-division-type");
        tgActionProcessor.setAttribute(TGSetDivisionTypeDurationAction.PROPERTY_DIVISION_TYPE, tgDivisionType);
        return tgActionProcessor;
    }
}

