/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.transport;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.action.TGActionProcessorListener;
import org.herac.tuxguitar.app.editor.EditorCache;
import org.herac.tuxguitar.app.transport.TGTransport;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.component.tab.TablatureEditor;
import org.herac.tuxguitar.app.view.main.TGWindow;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.app.view.util.TGProcess;
import org.herac.tuxguitar.app.view.util.TGSyncProcess;
import org.herac.tuxguitar.app.view.util.TGSyncProcessLocked;
import org.herac.tuxguitar.document.TGDocumentManager;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.player.base.MidiPlayer;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UIDisposeEvent;
import org.herac.tuxguitar.ui.event.UIDisposeListener;
import org.herac.tuxguitar.ui.event.UIMouseDownListener;
import org.herac.tuxguitar.ui.event.UIMouseEvent;
import org.herac.tuxguitar.ui.event.UIMouseMoveListener;
import org.herac.tuxguitar.ui.event.UIMouseUpListener;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.resource.UIColor;
import org.herac.tuxguitar.ui.resource.UICursor;
import org.herac.tuxguitar.ui.resource.UIFont;
import org.herac.tuxguitar.ui.toolbar.UIToolActionItem;
import org.herac.tuxguitar.ui.toolbar.UIToolBar;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UILabel;
import org.herac.tuxguitar.ui.widget.UILayoutContainer;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UIProgressBar;
import org.herac.tuxguitar.ui.widget.UIToggleButton;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.singleton.TGSingletonFactory;
import org.herac.tuxguitar.util.singleton.TGSingletonUtil;

public class TGTransportDialog
implements TGEventListener {
    private static final int PLAY_MODE_DELAY = 250;
    public static final int STATUS_STOPPED = 1;
    public static final int STATUS_PAUSED = 2;
    public static final int STATUS_RUNNING = 3;
    private TGContext context;
    private UIWindow dialog;
    private UILabel label;
    private UIProgressBar tickProgress;
    private UIToggleButton metronome;
    private UIButton mode;
    private UIToolBar toolBar;
    private UIToolActionItem first;
    private UIToolActionItem last;
    private UIToolActionItem previous;
    private UIToolActionItem next;
    private UIToolActionItem stop;
    private UIToolActionItem play;
    private TGProcess loadPropertiesProcess;
    private TGProcess loadIconsProcess;
    private TGProcess updateItemsProcess;
    private TGProcess redrawPlayModeProcess;
    private boolean editingTickScale;
    private long redrawTime;
    private int status;

    public TGTransportDialog(TGContext context) {
        this.context = context;
        this.createSyncProcesses();
    }

    public void show() {
        UIFactory factory = this.getUIFactory();
        this.dialog = factory.createWindow(TGWindow.getInstance(this.context).getWindow(), false, false);
        this.dialog.setImage(TuxGuitar.getInstance().getIconManager().getAppIcon());
        this.dialog.setLayout((UILayout)new UITableLayout());
        this.dialog.setText(TuxGuitar.getProperty("transport"));
        this.initComposites();
        this.initToolBar();
        this.redrawProgress();
        this.addListeners();
        this.dialog.addDisposeListener(new UIDisposeListener(){

            public void onDispose(UIDisposeEvent event) {
                TGTransportDialog.this.removeListeners();
                TuxGuitar.getInstance().updateCache(true);
            }
        });
        TGDialogUtil.openDialog(this.dialog, 5);
    }

    public void addListeners() {
        TuxGuitar.getInstance().getIconManager().addLoader(this);
        TuxGuitar.getInstance().getLanguageManager().addLoader(this);
        TuxGuitar.getInstance().getEditorManager().addRedrawListener((TGEventListener)this);
        TuxGuitar.getInstance().getEditorManager().addUpdateListener((TGEventListener)this);
    }

    public void removeListeners() {
        TuxGuitar.getInstance().getIconManager().removeLoader(this);
        TuxGuitar.getInstance().getLanguageManager().removeLoader(this);
        TuxGuitar.getInstance().getEditorManager().removeRedrawListener((TGEventListener)this);
        TuxGuitar.getInstance().getEditorManager().removeUpdateListener((TGEventListener)this);
    }

    private void initComposites() {
        UIPanel composite = this.getUIFactory().createPanel((UIContainer)this.dialog, true);
        composite.setLayout((UILayout)new UITableLayout(Float.valueOf(0.0f)));
        UITableLayout parentLayout = (UITableLayout)this.dialog.getLayout();
        parentLayout.set((UIControl)composite, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.initOptions((UILayoutContainer)composite);
        this.initProgress((UILayoutContainer)composite);
    }

    private void initOptions(UILayoutContainer parent) {
        UIFactory factory = this.getUIFactory();
        UITableLayout parentLayout = (UITableLayout)parent.getLayout();
        UITableLayout compositeLayout = new UITableLayout();
        UIPanel composite = factory.createPanel((UIContainer)parent, false);
        composite.setLayout((UILayout)compositeLayout);
        parentLayout.set((UIControl)composite, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(true), null, null, null, null, Float.valueOf(0.0f));
        this.metronome = factory.createToggleButton((UIContainer)composite);
        this.metronome.addSelectionListener((UISelectionListener)new TGActionProcessorListener(this.context, "action.transport.metronome"));
        compositeLayout.set((UIControl)this.metronome, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(true));
        this.mode = factory.createButton((UIContainer)composite);
        this.mode.addSelectionListener((UISelectionListener)new TGActionProcessorListener(this.context, "action.gui.open-transport-mode-dialog"));
        compositeLayout.set((UIControl)this.mode, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(true));
        this.loadOptionIcons();
    }

    private void initProgress(UILayoutContainer parent) {
        UIPanel composite = this.getUIFactory().createPanel((UIContainer)parent, false);
        composite.setLayout((UILayout)new UITableLayout());
        UITableLayout parentLayout = (UITableLayout)parent.getLayout();
        parentLayout.set((UIControl)composite, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), null, null, null, null, Float.valueOf(0.0f));
        this.initLabel((UILayoutContainer)composite);
        this.initScale((UILayoutContainer)composite);
    }

    private void initLabel(UILayoutContainer parent) {
        UIFactory factory = this.getUIFactory();
        final UIFont font = factory.createFont("Minisystem", 36.0f, false, false);
        final UIColor background = factory.createColor(0, 0, 0);
        final UIColor foreground = factory.createColor(0, 0, 255);
        UITableLayout parentLayout = (UITableLayout)parent.getLayout();
        UITableLayout labelContainerLayout = new UITableLayout();
        UIPanel labelContainer = factory.createPanel((UIContainer)parent, false);
        labelContainer.setLayout((UILayout)labelContainerLayout);
        labelContainer.setBgColor(background);
        parentLayout.set((UIControl)labelContainer, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.label = factory.createLabel((UIContainer)labelContainer);
        this.label.setBgColor(background);
        this.label.setFgColor(foreground);
        this.label.setFont(font);
        labelContainer.addDisposeListener(new UIDisposeListener(){

            public void onDispose(UIDisposeEvent event) {
                font.dispose();
                background.dispose();
                foreground.dispose();
            }
        });
        labelContainerLayout.set((UIControl)this.label, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
    }

    private void initScale(UILayoutContainer parent) {
        UIFactory factory = this.getUIFactory();
        this.tickProgress = factory.createProgressBar((UIContainer)parent);
        this.tickProgress.setCursor(UICursor.HAND);
        this.tickProgress.setValue(960);
        this.tickProgress.addMouseDownListener(new UIMouseDownListener(){

            public void onMouseDown(UIMouseEvent event) {
                TGTransportDialog.this.setEditingTickScale(true);
                TGTransportDialog.this.updateProgressBar(event.getPosition().getX());
            }
        });
        this.tickProgress.addMouseUpListener(new UIMouseUpListener(){

            public void onMouseUp(UIMouseEvent event) {
                TGTransportDialog.this.gotoMeasure(TGTransportDialog.this.getSongManager().getMeasureHeaderAt(TGTransportDialog.this.getDocumentManager().getSong(), (long)TGTransportDialog.this.tickProgress.getValue()), true);
                TGTransportDialog.this.setEditingTickScale(false);
            }
        });
        this.tickProgress.addMouseMoveListener(new UIMouseMoveListener(){

            public void onMouseMove(UIMouseEvent event) {
                TGTransportDialog.this.updateProgressBar(event.getPosition().getX());
            }
        });
        UITableLayout parentLayout = (UITableLayout)parent.getLayout();
        parentLayout.set((UIControl)this.tickProgress, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        parentLayout.set((UIControl)this.tickProgress, "packed_height", (Object)Float.valueOf(10.0f));
    }

    private void updateProgressBar(float x) {
        if (this.isEditingTickScale()) {
            float width = this.tickProgress.getBounds().getWidth();
            float selection = (float)this.tickProgress.getMinimum() + x * (float)(this.tickProgress.getMaximum() - this.tickProgress.getMinimum()) / width;
            this.tickProgress.setValue(Math.round(Math.max(960.0f, selection)));
            this.redrawProgress();
        }
    }

    private void initToolBar() {
        if (this.toolBar != null && !this.toolBar.isDisposed()) {
            this.toolBar.dispose();
        }
        this.toolBar = this.getUIFactory().createHorizontalToolBar((UIContainer)this.dialog);
        this.first = this.toolBar.createActionItem();
        this.first.addSelectionListener((UISelectionListener)new TGActionProcessorListener(this.context, "action.measure.go-first"));
        this.previous = this.toolBar.createActionItem();
        this.previous.addSelectionListener((UISelectionListener)new TGActionProcessorListener(this.context, "action.measure.go-previous"));
        this.stop = this.toolBar.createActionItem();
        this.stop.addSelectionListener((UISelectionListener)new TGActionProcessorListener(this.context, "action.transport.stop"));
        this.play = this.toolBar.createActionItem();
        this.play.addSelectionListener((UISelectionListener)new TGActionProcessorListener(this.context, "action.transport.play"));
        this.next = this.toolBar.createActionItem();
        this.next.addSelectionListener((UISelectionListener)new TGActionProcessorListener(this.context, "action.measure.go-next"));
        this.last = this.toolBar.createActionItem();
        this.last.addSelectionListener((UISelectionListener)new TGActionProcessorListener(this.context, "action.measure.go-last"));
        UITableLayout uiLayout = (UITableLayout)this.dialog.getLayout();
        uiLayout.set((UIControl)this.toolBar, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.updateItems(true);
        this.loadProperties();
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void updateItems() {
        this.updateItems(false);
    }

    public void updateItems(boolean force) {
        if (!this.isDisposed()) {
            int lastStatus = this.getStatus();
            MidiPlayer player = MidiPlayer.getInstance((TGContext)this.context);
            if (player.isRunning()) {
                this.setStatus(3);
            } else if (player.isPaused()) {
                this.setStatus(2);
            } else {
                this.setStatus(1);
            }
            if (force || lastStatus != this.getStatus()) {
                if (this.getStatus() == 3) {
                    this.first.setImage(TuxGuitar.getInstance().getIconManager().getTransportFirst2());
                    this.last.setImage(TuxGuitar.getInstance().getIconManager().getTransportLast2());
                    this.previous.setImage(TuxGuitar.getInstance().getIconManager().getTransportPrevious2());
                    this.next.setImage(TuxGuitar.getInstance().getIconManager().getTransportNext2());
                    this.stop.setImage(TuxGuitar.getInstance().getIconManager().getTransportStop2());
                    this.play.setImage(TuxGuitar.getInstance().getIconManager().getTransportPause());
                } else if (this.getStatus() == 2) {
                    this.first.setImage(TuxGuitar.getInstance().getIconManager().getTransportFirst2());
                    this.last.setImage(TuxGuitar.getInstance().getIconManager().getTransportLast2());
                    this.previous.setImage(TuxGuitar.getInstance().getIconManager().getTransportPrevious2());
                    this.next.setImage(TuxGuitar.getInstance().getIconManager().getTransportNext2());
                    this.stop.setImage(TuxGuitar.getInstance().getIconManager().getTransportStop2());
                    this.play.setImage(TuxGuitar.getInstance().getIconManager().getTransportPlay2());
                } else if (this.getStatus() == 1) {
                    this.first.setImage(TuxGuitar.getInstance().getIconManager().getTransportFirst1());
                    this.last.setImage(TuxGuitar.getInstance().getIconManager().getTransportLast1());
                    this.previous.setImage(TuxGuitar.getInstance().getIconManager().getTransportPrevious1());
                    this.next.setImage(TuxGuitar.getInstance().getIconManager().getTransportNext1());
                    this.stop.setImage(TuxGuitar.getInstance().getIconManager().getTransportStop1());
                    this.play.setImage(TuxGuitar.getInstance().getIconManager().getTransportPlay1());
                }
                this.loadPlayText();
            }
            TGMeasureHeader first = this.getSongManager().getFirstMeasureHeader(this.getDocumentManager().getSong());
            TGMeasureHeader last = this.getSongManager().getLastMeasureHeader(this.getDocumentManager().getSong());
            this.tickProgress.setMinimum((int)first.getStart());
            this.tickProgress.setMaximum((int)(last.getStart() + last.getLength()) - 1);
            this.metronome.setSelected(player.isMetronomeEnabled());
            this.redrawProgress();
        }
    }

    public void loadProperties() {
        if (!this.isDisposed()) {
            this.dialog.setText(TuxGuitar.getProperty("transport"));
            this.stop.setToolTipText(TuxGuitar.getProperty("transport.stop"));
            this.first.setToolTipText(TuxGuitar.getProperty("transport.first"));
            this.last.setToolTipText(TuxGuitar.getProperty("transport.last"));
            this.previous.setToolTipText(TuxGuitar.getProperty("transport.previous"));
            this.next.setToolTipText(TuxGuitar.getProperty("transport.next"));
            this.metronome.setToolTipText(TuxGuitar.getProperty("transport.metronome"));
            this.mode.setToolTipText(TuxGuitar.getProperty("transport.mode"));
            this.loadPlayText();
        }
    }

    public void loadPlayText() {
        String property = TuxGuitar.getProperty(this.getStatus() == 3 ? "transport.pause" : "transport.start");
        this.play.setToolTipText(property);
    }

    public void loadIcons() {
        if (!this.isDisposed()) {
            this.initToolBar();
            this.loadOptionIcons();
            this.dialog.setImage(TuxGuitar.getInstance().getIconManager().getAppIcon());
            this.dialog.layout();
        }
    }

    private void loadOptionIcons() {
        this.metronome.setImage(TuxGuitar.getInstance().getIconManager().getTransportMetronome());
        this.mode.setImage(TuxGuitar.getInstance().getIconManager().getTransportMode());
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.dialog.dispose();
        }
    }

    public boolean isDisposed() {
        return this.dialog == null || this.dialog.isDisposed();
    }

    public boolean isEditingTickScale() {
        return this.editingTickScale;
    }

    public void setEditingTickScale(boolean editingTickScale) {
        this.editingTickScale = editingTickScale;
    }

    public UIFactory getUIFactory() {
        return TGApplication.getInstance(this.context).getFactory();
    }

    public TGDocumentManager getDocumentManager() {
        return TGDocumentManager.getInstance((TGContext)this.context);
    }

    public TGSongManager getSongManager() {
        return this.getDocumentManager().getSongManager();
    }

    public void gotoMeasure(TGMeasureHeader header, boolean moveCaret) {
        TGTransport.getInstance(this.context).gotoMeasure(header, moveCaret);
    }

    public void updateTickLabel(String value) {
        String oldValue = this.label.getText();
        this.label.setText(value);
        if (oldValue == null || oldValue.length() != value.length()) {
            UIPanel uiPanel = (UIPanel)this.label.getParent();
            uiPanel.layout();
        }
    }

    public void redrawProgress() {
        if (!this.isDisposed() && !TuxGuitar.getInstance().isLocked()) {
            if (this.isEditingTickScale()) {
                this.updateTickLabel(Long.toString(this.tickProgress.getValue()));
            } else if (!MidiPlayer.getInstance((TGContext)this.context).isRunning()) {
                long tickPosition = TablatureEditor.getInstance(this.context).getTablature().getCaret().getPosition();
                this.updateTickLabel(Long.toString(tickPosition));
                this.tickProgress.setValue((int)tickPosition);
            }
        }
    }

    public void redrawPlayingMode() {
        if (!this.isDisposed()) {
            MidiPlayer player = MidiPlayer.getInstance((TGContext)this.context);
            if (!this.isEditingTickScale() && player.isRunning()) {
                EditorCache editorCache = TuxGuitar.getInstance().getEditorCache();
                long time = System.currentTimeMillis();
                if (time > this.redrawTime + 250L) {
                    long position = editorCache.getPlayStart() + (player.getTickPosition() - editorCache.getPlayTick());
                    this.updateTickLabel(Long.toString(position));
                    this.tickProgress.setValue((int)position);
                    this.redrawTime = time;
                }
            }
        }
    }

    public void createSyncProcesses() {
        this.loadPropertiesProcess = new TGSyncProcess(this.context, new Runnable(){

            public void run() {
                TGTransportDialog.this.loadProperties();
            }
        });
        this.loadIconsProcess = new TGSyncProcessLocked(this.context, new Runnable(){

            public void run() {
                TGTransportDialog.this.loadIcons();
            }
        });
        this.updateItemsProcess = new TGSyncProcessLocked(this.context, new Runnable(){

            public void run() {
                TGTransportDialog.this.updateItems();
            }
        });
        this.redrawPlayModeProcess = new TGSyncProcessLocked(this.context, new Runnable(){

            public void run() {
                TGTransportDialog.this.redrawPlayingMode();
            }
        });
    }

    public void processRedrawEvent(TGEvent event) {
        int type = (Integer)event.getAttribute("redrawMode");
        if (type == 2 || type == 3) {
            this.redrawPlayModeProcess.process();
        }
    }

    public void processUpdateEvent(TGEvent event) {
        int type = (Integer)event.getAttribute("updateMode");
        if (type == 1) {
            this.updateItemsProcess.process();
        }
    }

    public void processEvent(TGEvent event) {
        if ("ui-icon".equals(event.getEventType())) {
            this.loadIconsProcess.process();
        } else if ("language".equals(event.getEventType())) {
            this.loadPropertiesProcess.process();
        } else if ("ui-redraw".equals(event.getEventType())) {
            this.processRedrawEvent(event);
        } else if ("ui-update".equals(event.getEventType())) {
            this.processUpdateEvent(event);
        }
    }

    public static TGTransportDialog getInstance(TGContext context) {
        return (TGTransportDialog)TGSingletonUtil.getInstance((TGContext)context, (String)TGTransportDialog.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGTransportDialog>(){

            public TGTransportDialog createInstance(TGContext context) {
                return new TGTransportDialog(context);
            }
        });
    }
}

