/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.bend;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.graphics.TGColorImpl;
import org.herac.tuxguitar.app.graphics.TGPainterImpl;
import org.herac.tuxguitar.app.system.color.TGColorManager;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.editor.action.effect.TGChangeBendNoteAction;
import org.herac.tuxguitar.graphics.TGColor;
import org.herac.tuxguitar.graphics.TGPainter;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.effects.TGEffectBend;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UIMouseEvent;
import org.herac.tuxguitar.ui.event.UIMouseUpListener;
import org.herac.tuxguitar.ui.event.UIPaintEvent;
import org.herac.tuxguitar.ui.event.UIPaintListener;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.resource.UIPosition;
import org.herac.tuxguitar.ui.resource.UIResourceFactory;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UICanvas;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UIListBoxSelect;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UISelectItem;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TGBendDialog {
    private static final int X_SPACING = 30;
    private static final int Y_SPACING = 15;
    private static final int X_LENGTH = 13;
    private static final int Y_LENGTH = 13;
    private int[] x;
    private int[] y;
    private int width;
    private int height;
    private List<UIPosition> points;
    private UICanvas editor;
    private TGColorManager colorManager;

    public TGBendDialog() {
        this.init();
    }

    private void init() {
        int i;
        this.x = new int[13];
        this.y = new int[13];
        this.width = 360;
        this.height = 180;
        this.points = new ArrayList<UIPosition>();
        for (i = 0; i < this.x.length; ++i) {
            this.x[i] = (i + 1) * 30;
        }
        for (i = 0; i < this.y.length; ++i) {
            this.y[i] = (i + 1) * 15;
        }
    }

    public void show(final TGViewContext context) {
        final TGMeasure measure = (TGMeasure)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE);
        final TGBeat beat = (TGBeat)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT);
        final TGString string = (TGString)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_STRING);
        TGNote note = (TGNote)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_NOTE);
        if (measure != null && beat != null && note != null && string != null) {
            final UIFactory uiFactory = TGApplication.getInstance(context.getContext()).getFactory();
            UIWindow uiParent = (UIWindow)context.getAttribute("parent2");
            UITableLayout dialogLayout = new UITableLayout();
            final UIWindow dialog = uiFactory.createWindow(uiParent, true, false);
            dialog.setLayout((UILayout)dialogLayout);
            dialog.setText(TuxGuitar.getProperty("bend.editor"));
            UITableLayout compositeLayout = new UITableLayout();
            UIPanel composite = uiFactory.createPanel((UIContainer)dialog, false);
            composite.setLayout((UILayout)compositeLayout);
            dialogLayout.set((UIControl)composite, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            UITableLayout leftCompositeLayout = new UITableLayout();
            UIPanel leftComposite = uiFactory.createPanel((UIContainer)composite, false);
            leftComposite.setLayout((UILayout)leftCompositeLayout);
            compositeLayout.set((UIControl)leftComposite, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            UITableLayout rightCompositeLayout = new UITableLayout();
            UIPanel rightComposite = uiFactory.createPanel((UIContainer)composite, false);
            rightComposite.setLayout((UILayout)rightCompositeLayout);
            compositeLayout.set((UIControl)rightComposite, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            this.colorManager = TGColorManager.getInstance(context.getContext());
            this.editor = uiFactory.createCanvas((UIContainer)leftComposite, true);
            this.editor.setBgColor(this.colorManager.getColor(1));
            this.editor.addPaintListener(new UIPaintListener(){

                public void onPaint(UIPaintEvent event) {
                    TGBendDialog.this.paintEditor(new TGPainterImpl((UIResourceFactory)uiFactory, event.getPainter()));
                }
            });
            this.editor.addMouseUpListener(new UIMouseUpListener(){

                public void onMouseUp(UIMouseEvent event) {
                    TGBendDialog.this.checkPoint(event.getPosition().getX(), event.getPosition().getY());
                    TGBendDialog.this.editor.redraw();
                }
            });
            leftCompositeLayout.set((UIControl)this.editor, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf((float)this.getWidth() + 60.0f), Float.valueOf((float)this.getHeight() + 30.0f), null);
            List<UISelectItem<TGEffectBend>> presetItems = this.createPresetItems();
            final UIListBoxSelect defaultBendList = uiFactory.createListBoxSelect((UIContainer)rightComposite);
            for (UISelectItem<TGEffectBend> presetItem : presetItems) {
                defaultBendList.addItem(presetItem);
            }
            defaultBendList.setSelectedItem(presetItems.get(0));
            defaultBendList.addSelectionListener(new UISelectionListener(){

                public void onSelect(UISelectionEvent event) {
                    TGEffectBend selection = (TGEffectBend)defaultBendList.getSelectedValue();
                    if (selection != null) {
                        TGBendDialog.this.setBend(selection);
                        TGBendDialog.this.editor.redraw();
                    }
                }
            });
            rightCompositeLayout.set((UIControl)defaultBendList, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            UIButton buttonClean = uiFactory.createButton((UIContainer)rightComposite);
            buttonClean.setText(TuxGuitar.getProperty("clean"));
            buttonClean.addSelectionListener(new UISelectionListener(){

                public void onSelect(UISelectionEvent event) {
                    TGBendDialog.this.changeBend(context.getContext(), measure, beat, string, null);
                    dialog.dispose();
                }
            });
            rightCompositeLayout.set((UIControl)buttonClean, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_BOTTOM, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
            UIButton buttonOK = uiFactory.createButton((UIContainer)rightComposite);
            buttonOK.setDefaultButton();
            buttonOK.setText(TuxGuitar.getProperty("ok"));
            buttonOK.addSelectionListener(new UISelectionListener(){

                public void onSelect(UISelectionEvent event) {
                    TGBendDialog.this.changeBend(context.getContext(), measure, beat, string, TGBendDialog.this.getBend());
                    dialog.dispose();
                }
            });
            rightCompositeLayout.set((UIControl)buttonOK, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_BOTTOM, Boolean.valueOf(true), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
            UIButton buttonCancel = uiFactory.createButton((UIContainer)rightComposite);
            buttonCancel.setText(TuxGuitar.getProperty("cancel"));
            buttonCancel.addSelectionListener(new UISelectionListener(){

                public void onSelect(UISelectionEvent event) {
                    dialog.dispose();
                }
            });
            rightCompositeLayout.set((UIControl)buttonCancel, Integer.valueOf(4), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_BOTTOM, Boolean.valueOf(true), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
            if (note.getEffect().isBend()) {
                this.setBend(note.getEffect().getBend());
            } else {
                this.setBend((TGEffectBend)presetItems.get(0).getValue());
            }
            TGDialogUtil.openDialog(dialog, 5);
        }
    }

    private void paintEditor(TGPainter painter) {
        int i;
        for (i = 0; i < this.x.length; ++i) {
            this.setStyleX(painter, i);
            painter.initPath();
            painter.setAntialias(false);
            painter.moveTo((float)this.x[i], 15.0f);
            painter.lineTo((float)this.x[i], (float)(15 + this.height));
            painter.closePath();
        }
        for (i = 0; i < this.y.length; ++i) {
            this.setStyleY(painter, i);
            painter.initPath();
            painter.setAntialias(false);
            painter.moveTo(30.0f, (float)this.y[i]);
            painter.lineTo((float)(30 + this.width), (float)this.y[i]);
            painter.closePath();
        }
        painter.setLineStyleSolid();
        painter.setLineWidth(2.0f);
        painter.setForeground((TGColor)new TGColorImpl(this.colorManager.getColor(3)));
        UIPosition prevPoint = null;
        for (UIPosition point : this.points) {
            if (prevPoint != null) {
                painter.initPath();
                painter.moveTo(prevPoint.getX(), prevPoint.getY());
                painter.lineTo(point.getX(), point.getY());
                painter.closePath();
            }
            prevPoint = point;
        }
        painter.setLineWidth(5.0f);
        painter.setForeground((TGColor)new TGColorImpl(this.colorManager.getColor(2)));
        for (UIPosition point : this.points) {
            painter.initPath();
            painter.setAntialias(false);
            painter.addRectangle(point.getX() - 2.0f, point.getY() - 2.0f, 5.0f, 5.0f);
            painter.closePath();
        }
        painter.setLineWidth(1.0f);
    }

    private void setStyleX(TGPainter painter, int i) {
        painter.setLineStyleSolid();
        if (i == 0 || i == 12) {
            painter.setForeground((TGColor)new TGColorImpl(this.colorManager.getColor(2)));
        } else {
            painter.setForeground((TGColor)new TGColorImpl(this.colorManager.getColor(4)));
            if (i % 3 > 0) {
                painter.setLineStyleDot();
            }
        }
    }

    private void setStyleY(TGPainter painter, int i) {
        painter.setLineStyleSolid();
        if (i == 0 || i == 12) {
            painter.setForeground((TGColor)new TGColorImpl(this.colorManager.getColor(2)));
        } else {
            painter.setForeground((TGColor)new TGColorImpl(this.colorManager.getColor(5)));
            if (i % 2 > 0) {
                painter.setLineStyleDot();
                painter.setForeground((TGColor)new TGColorImpl(this.colorManager.getColor(3)));
            } else if (i % 4 > 0) {
                painter.setLineStyleDot();
            }
        }
    }

    protected void checkPoint(float x, float y) {
        UIPosition point = new UIPosition(this.getX(x), this.getY(y));
        if (!this.removePoint(point)) {
            this.removePointsAtXLine(point.getX());
            this.addPoint(point);
            this.orderPoints();
        }
    }

    protected boolean removePoint(UIPosition point) {
        UIPosition pointToRemove = null;
        for (UIPosition currPoint : this.points) {
            if (currPoint.getX() != point.getX() || currPoint.getY() != point.getY()) continue;
            pointToRemove = currPoint;
            break;
        }
        if (pointToRemove != null) {
            this.points.remove(pointToRemove);
            return true;
        }
        return false;
    }

    protected void orderPoints() {
        for (int i = 0; i < this.points.size(); ++i) {
            UIPosition minPoint = null;
            for (int noteIdx = i; noteIdx < this.points.size(); ++noteIdx) {
                UIPosition point = this.points.get(noteIdx);
                if (minPoint != null && !(point.getX() < minPoint.getX())) continue;
                minPoint = point;
            }
            this.points.remove(minPoint);
            this.points.add(i, minPoint);
        }
    }

    protected void removePointsAtXLine(float x) {
        ArrayList<UIPosition> pointsToRemove = new ArrayList<UIPosition>();
        for (UIPosition point : this.points) {
            if (point.getX() != x) continue;
            pointsToRemove.add(point);
            break;
        }
        this.points.removeAll(pointsToRemove);
    }

    protected void addPoint(UIPosition point) {
        this.points.add(point);
    }

    protected float getX(float pointX) {
        float currPointX = -1.0f;
        for (int i = 0; i < this.x.length; ++i) {
            if (currPointX < 0.0f) {
                currPointX = this.x[i];
                continue;
            }
            float distanceX = Math.abs(pointX - currPointX);
            float currDistanceX = Math.abs(pointX - (float)this.x[i]);
            if (!(currDistanceX < distanceX)) continue;
            currPointX = this.x[i];
        }
        return currPointX;
    }

    protected float getY(float pointY) {
        float currPointY = -1.0f;
        for (int i = 0; i < this.y.length; ++i) {
            if (currPointY < 0.0f) {
                currPointY = this.y[i];
                continue;
            }
            float distanceX = Math.abs(pointY - currPointY);
            float currDistanceX = Math.abs(pointY - (float)this.y[i]);
            if (!(currDistanceX < distanceX)) continue;
            currPointY = this.y[i];
        }
        return currPointY;
    }

    public boolean isEmpty() {
        return this.points.isEmpty();
    }

    public TGEffectBend getBend() {
        if (this.points != null && !this.points.isEmpty()) {
            TGEffectBend bend = TuxGuitar.getInstance().getSongManager().getFactory().newEffectBend();
            for (UIPosition point : this.points) {
                this.addBendPoint(bend, point);
            }
            return bend;
        }
        return null;
    }

    private void addBendPoint(TGEffectBend effect, UIPosition point) {
        int i;
        int position = 0;
        int value = 0;
        for (i = 0; i < this.x.length; ++i) {
            if (point.getX() != (float)this.x[i]) continue;
            position = i;
        }
        for (i = 0; i < this.y.length; ++i) {
            if (point.getY() != (float)this.y[i]) continue;
            value = this.y.length - i - 1;
        }
        effect.addPoint(position, value);
    }

    public void setBend(TGEffectBend effect) {
        this.points.clear();
        for (TGEffectBend.BendPoint bendPoint : effect.getPoints()) {
            this.makePoint(bendPoint);
        }
    }

    private void makePoint(TGEffectBend.BendPoint bendPoint) {
        int indexX = bendPoint.getPosition();
        int indexY = this.y.length - bendPoint.getValue() - 1;
        if (indexX >= 0 && indexX < this.x.length && indexY >= 0 && indexY < this.y.length) {
            UIPosition point = new UIPosition(0.0f, 0.0f);
            point.setX((float)this.x[indexX]);
            point.setY((float)this.y[indexY]);
            this.points.add(point);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private List<UISelectItem<TGEffectBend>> createPresetItems() {
        TGEffectBend bend = null;
        TGFactory factory = TuxGuitar.getInstance().getSongManager().getFactory();
        ArrayList<UISelectItem<TGEffectBend>> items = new ArrayList<UISelectItem<TGEffectBend>>();
        bend = factory.newEffectBend();
        bend.addPoint(0, 0);
        bend.addPoint(6, 4);
        bend.addPoint(12, 4);
        items.add(new UISelectItem(TuxGuitar.getProperty("bend.bend"), (Object)bend));
        bend = factory.newEffectBend();
        bend.addPoint(0, 0);
        bend.addPoint(3, 4);
        bend.addPoint(6, 4);
        bend.addPoint(9, 0);
        bend.addPoint(12, 0);
        items.add(new UISelectItem(TuxGuitar.getProperty("bend.bend-release"), (Object)bend));
        bend = factory.newEffectBend();
        bend.addPoint(0, 0);
        bend.addPoint(2, 4);
        bend.addPoint(4, 4);
        bend.addPoint(6, 0);
        bend.addPoint(8, 0);
        bend.addPoint(10, 4);
        bend.addPoint(12, 4);
        items.add(new UISelectItem(TuxGuitar.getProperty("bend.bend-release-bend"), (Object)bend));
        bend = factory.newEffectBend();
        bend.addPoint(0, 4);
        bend.addPoint(12, 4);
        items.add(new UISelectItem(TuxGuitar.getProperty("bend.prebend"), (Object)bend));
        bend = factory.newEffectBend();
        bend.addPoint(0, 4);
        bend.addPoint(4, 4);
        bend.addPoint(8, 0);
        bend.addPoint(12, 0);
        items.add(new UISelectItem(TuxGuitar.getProperty("bend.prebend-release"), (Object)bend));
        return items;
    }

    public void changeBend(TGContext context, TGMeasure measure, TGBeat beat, TGString string, TGEffectBend effect) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(context, "action.note.effect.change-bend");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE, (Object)measure);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT, (Object)beat);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_STRING, (Object)string);
        tgActionProcessor.setAttribute(TGChangeBendNoteAction.ATTRIBUTE_EFFECT, (Object)effect);
        tgActionProcessor.process();
    }
}

