/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.about;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.graphics.TGImageImpl;
import org.herac.tuxguitar.app.graphics.TGPainterImpl;
import org.herac.tuxguitar.app.system.config.TGConfigManager;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.app.view.dialog.about.TGAboutContentReader;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UIDisposeEvent;
import org.herac.tuxguitar.ui.event.UIDisposeListener;
import org.herac.tuxguitar.ui.event.UIPaintEvent;
import org.herac.tuxguitar.ui.event.UIPaintListener;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.resource.UIColor;
import org.herac.tuxguitar.ui.resource.UIFont;
import org.herac.tuxguitar.ui.resource.UIImage;
import org.herac.tuxguitar.ui.resource.UIResourceFactory;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UICanvas;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UILabel;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UIReadOnlyTextBox;
import org.herac.tuxguitar.ui.widget.UITabFolder;
import org.herac.tuxguitar.ui.widget.UITabItem;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGVersion;

public class TGAboutDialog {
    private static final String RELEASE_NAME = "TuxGuitar " + TGVersion.CURRENT.getVersion();
    private static final String PROPERTY_PREFIX = "help.about.";
    private static final float IMAGE_WIDTH = 100.0f;
    private static final float IMAGE_HEIGHT = 100.0f;
    private static final float TAB_ITEM_WIDTH = 660.0f;
    private static final float TAB_ITEM_HEIGHT = 300.0f;
    protected UICanvas imageComposite;
    protected UIImage image;

    public void show(TGViewContext context) {
        TGConfigManager configManager = TGConfigManager.getInstance(context.getContext());
        final UIFactory uiFactory = TGApplication.getInstance(context.getContext()).getFactory();
        UIWindow uiParent = (UIWindow)context.getAttribute("parent2");
        UITableLayout dialogLayout = new UITableLayout();
        final UIWindow dialog = uiFactory.createWindow(uiParent, true, false);
        dialog.setLayout((UILayout)dialogLayout);
        dialog.setText(TuxGuitar.getProperty("help.about"));
        UITableLayout headerLayout = new UITableLayout();
        UIPanel header = uiFactory.createPanel((UIContainer)dialog, false);
        header.setLayout((UILayout)headerLayout);
        dialogLayout.set((UIControl)header, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.image = TuxGuitar.getInstance().getIconManager().getAboutDescription();
        this.imageComposite = uiFactory.createCanvas((UIContainer)header, false);
        this.imageComposite.addPaintListener(new UIPaintListener(){

            public void onPaint(UIPaintEvent event) {
                float width = TGAboutDialog.this.image.getWidth();
                float height = TGAboutDialog.this.image.getHeight();
                TGPainterImpl tgPainter = new TGPainterImpl((UIResourceFactory)uiFactory, event.getPainter());
                tgPainter.drawImage(new TGImageImpl((UIResourceFactory)uiFactory, TGAboutDialog.this.image), (100.0f - width) / 2.0f, (100.0f - height) / 2.0f);
            }
        });
        headerLayout.set((UIControl)this.imageComposite, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(100.0f), Float.valueOf(100.0f), null);
        final UIColor titleColor = uiFactory.createColor(192, 192, 192);
        final UIFont titleFont = uiFactory.createFont(configManager.getUIFontModelConfigValue("font.about.dialog.title"));
        UILabel title = uiFactory.createLabel((UIContainer)header);
        title.setFont(titleFont);
        title.setFgColor(titleColor);
        title.setText(RELEASE_NAME);
        title.addDisposeListener(new UIDisposeListener(){

            public void onDispose(UIDisposeEvent event) {
                titleFont.dispose();
                titleColor.dispose();
            }
        });
        headerLayout.set((UIControl)title, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        UITableLayout tabsLayout = new UITableLayout();
        UIPanel tabs = uiFactory.createPanel((UIContainer)dialog, false);
        tabs.setLayout((UILayout)tabsLayout);
        dialogLayout.set((UIControl)tabs, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        final UITabFolder tabFolder = uiFactory.createTabFolder((UIContainer)tabs, false);
        tabsLayout.set((UIControl)tabFolder, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
        tabsLayout.set((UIControl)tabFolder, "packed_width", (Object)Float.valueOf(660.0f));
        tabsLayout.set((UIControl)tabFolder, "packed_height", (Object)Float.valueOf(300.0f));
        TGAboutContentReader docReader = new TGAboutContentReader(context.getContext());
        this.createTabItem(uiFactory, tabFolder, "description", docReader.read("description").toString());
        this.createTabItem(uiFactory, tabFolder, "authors", docReader.read("authors").toString());
        this.createTabItem(uiFactory, tabFolder, "license", docReader.read("license").toString());
        tabFolder.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                int selectedIndex = tabFolder.getSelectedIndex();
                if (selectedIndex == 0) {
                    TGAboutDialog.this.image = TuxGuitar.getInstance().getIconManager().getAboutDescription();
                } else if (selectedIndex == 1) {
                    TGAboutDialog.this.image = TuxGuitar.getInstance().getIconManager().getAboutAuthors();
                } else if (selectedIndex == 2) {
                    TGAboutDialog.this.image = TuxGuitar.getInstance().getIconManager().getAboutLicense();
                }
                TGAboutDialog.this.imageComposite.redraw();
            }
        });
        UITableLayout buttonsLayout = new UITableLayout();
        UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonClose = uiFactory.createButton((UIContainer)buttons);
        buttonClose.setDefaultButton();
        buttonClose.setText(TuxGuitar.getProperty("close"));
        buttonClose.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonClose, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        tabFolder.setSelectedIndex(0);
        TGDialogUtil.openDialog(dialog, 5);
    }

    private void createTabItem(UIFactory uiFactory, UITabFolder tabFolder, String itemName, String itemText) {
        final UIColor white = uiFactory.createColor(255, 255, 255);
        UITabItem uiTabItem = tabFolder.createTab();
        uiTabItem.setText(TuxGuitar.getProperty(PROPERTY_PREFIX + itemName));
        UITableLayout controlLayout = new UITableLayout();
        UIPanel control = uiFactory.createPanel((UIContainer)uiTabItem, false);
        control.setLayout((UILayout)controlLayout);
        UIReadOnlyTextBox text = uiFactory.createReadOnlyTextBox((UIContainer)control, true, false);
        text.setBgColor(white);
        text.setText(itemText);
        text.addDisposeListener(new UIDisposeListener(){

            public void onDispose(UIDisposeEvent event) {
                white.dispose();
            }
        });
        controlLayout.set((UIControl)text, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
    }
}

