/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.action.listener.cache;

import org.herac.tuxguitar.action.TGActionContext;
import org.herac.tuxguitar.app.action.TGActionAdapterManager;
import org.herac.tuxguitar.app.action.TGActionMap;
import org.herac.tuxguitar.app.action.listener.cache.TGUpdateContext;
import org.herac.tuxguitar.app.action.listener.cache.TGUpdateController;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.util.TGAbstractContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TGUpdateListener
implements TGEventListener {
    private TGActionAdapterManager manager;
    private TGActionMap<TGUpdateController> controllers;

    public TGUpdateListener(TGActionAdapterManager manager) {
        this.manager = manager;
        this.controllers = new TGActionMap();
    }

    public TGActionMap<TGUpdateController> getControllers() {
        return this.controllers;
    }

    public void processUpdate(String actionId, TGActionContext actionContext) {
        TGUpdateController controller = this.controllers.get(actionId);
        if (controller != null) {
            controller.update(this.manager.getContext(), actionContext);
        }
    }

    public void processPreExecution(TGActionContext actionContext) {
        TGUpdateContext updateContext = TGUpdateContext.getInstance(this.manager.getContext(), actionContext);
        if (updateContext.getLevel().equals(0)) {
            updateContext.getBuffer().clear();
        }
        updateContext.incrementLevel();
    }

    public void processPostExecution(String actionId, TGActionContext actionContext) {
        TGUpdateContext updateContext = TGUpdateContext.getInstance(this.manager.getContext(), actionContext);
        updateContext.decrementLevel();
        this.processUpdate(actionId, actionContext);
        if (updateContext.getLevel().equals(0)) {
            updateContext.getBuffer().apply((TGAbstractContext)actionContext);
        }
    }

    public void processPreExecution(TGEvent event) {
        TGActionContext actionContext = (TGActionContext)event.getAttribute("sourceContext");
        this.processPreExecution(actionContext);
    }

    public void processPostExecution(TGEvent event) {
        String actionId = (String)event.getAttribute("actionId");
        TGActionContext actionContext = (TGActionContext)event.getAttribute("sourceContext");
        this.processPostExecution(actionId, actionContext);
    }

    public void processEvent(TGEvent event) {
        if ("action-pre-execution".equals(event.getEventType())) {
            this.processPreExecution(event);
        } else if ("action-post-execution".equals(event.getEventType())) {
            this.processPostExecution(event);
        }
    }
}

