/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.action.impl.file;

import org.herac.tuxguitar.action.TGActionContext;
import org.herac.tuxguitar.action.TGActionManager;
import org.herac.tuxguitar.app.action.impl.view.TGOpenViewAction;
import org.herac.tuxguitar.app.graphics.TGPainterImpl;
import org.herac.tuxguitar.app.graphics.TGResourceFactoryImpl;
import org.herac.tuxguitar.app.printer.PrintController;
import org.herac.tuxguitar.app.printer.PrintDocument;
import org.herac.tuxguitar.app.printer.PrintLayout;
import org.herac.tuxguitar.app.printer.PrintStyles;
import org.herac.tuxguitar.app.view.dialog.printer.TGPrintStylesDialog;
import org.herac.tuxguitar.app.view.dialog.printer.TGPrintStylesDialogController;
import org.herac.tuxguitar.app.view.dialog.printer.TGPrintStylesHandler;
import org.herac.tuxguitar.app.view.dialog.printer.TGPrinterChooserDialog;
import org.herac.tuxguitar.app.view.dialog.printer.TGPrinterChooserDialogController;
import org.herac.tuxguitar.app.view.dialog.printer.TGPrinterChooserHandler;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionBase;
import org.herac.tuxguitar.graphics.TGDimension;
import org.herac.tuxguitar.graphics.TGMargins;
import org.herac.tuxguitar.graphics.TGPainter;
import org.herac.tuxguitar.graphics.TGRectangle;
import org.herac.tuxguitar.graphics.control.TGFactoryImpl;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.ui.printer.UIPrinter;
import org.herac.tuxguitar.ui.printer.UIPrinterJob;
import org.herac.tuxguitar.ui.printer.UIPrinterPage;
import org.herac.tuxguitar.ui.resource.UIRectangle;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGSynchronizer;

public class TGPrintAction
extends TGActionBase {
    public static final String NAME = "action.file.print";
    public static final String ATTRIBUTE_STYLES = PrintStyles.class.getName();
    public static final String ATTRIBUTE_PRINTER = UIPrinter.class.getName();

    public TGPrintAction(TGContext context) {
        super(context, NAME);
    }

    protected void processAction(TGActionContext context) {
        PrintStyles styles = (PrintStyles)context.getAttribute(ATTRIBUTE_STYLES);
        if (styles == null) {
            this.configureStyles(context);
            return;
        }
        UIPrinter printer = (UIPrinter)context.getAttribute(ATTRIBUTE_PRINTER);
        if (printer == null) {
            this.configurePrinterData(context);
            return;
        }
        TGSongManager manager = new TGSongManager((TGFactory)new TGFactoryImpl());
        TGSong sourceSong = (TGSong)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
        TGSong targetSong = sourceSong.clone(manager.getFactory());
        TGRectangle printerArea = this.getPrinterArea(printer, 10.0f);
        TGDimension pageSize = new TGDimension(printerArea.getWidth(), printerArea.getHeight());
        TGMargins pageMargins = new TGMargins(printerArea.getY(), printerArea.getX(), 0.0f, 0.0f);
        PrintController controller = new PrintController(targetSong, manager, new TGResourceFactoryImpl(printer.getResourceFactory()));
        PrintLayout printLayout = new PrintLayout(controller, styles);
        printLayout.loadStyles(printer.getDpiScale().floatValue(), 1.0f);
        printLayout.updateSong();
        printLayout.makeDocument(new PrintDocumentImpl(printLayout, printer, pageSize, pageMargins));
        printLayout.getResourceBuffer().disposeAllResources();
    }

    public void configureStyles(final TGActionContext context) {
        context.setAttribute(TGOpenViewAction.ATTRIBUTE_CONTROLLER, (Object)new TGPrintStylesDialogController());
        context.setAttribute(TGPrintStylesDialog.ATTRIBUTE_HANDLER, (Object)new TGPrintStylesHandler(){

            public void updatePrintStyles(PrintStyles styles) {
                context.setAttribute(ATTRIBUTE_STYLES, (Object)styles);
                TGPrintAction.this.executeActionInNewThread(TGPrintAction.NAME, context);
            }
        });
        this.executeActionInNewThread("action.gui.open-view", context);
    }

    public void configurePrinterData(final TGActionContext context) {
        context.setAttribute(TGOpenViewAction.ATTRIBUTE_CONTROLLER, (Object)new TGPrinterChooserDialogController());
        context.setAttribute(TGPrinterChooserDialog.ATTRIBUTE_HANDLER, (Object)new TGPrinterChooserHandler(){

            public void updatePrinter(UIPrinter printer) {
                context.setAttribute(ATTRIBUTE_PRINTER, (Object)printer);
                TGPrintAction.this.executeActionInNewThread(TGPrintAction.NAME, context);
            }
        });
        this.executeActionInNewThread("action.gui.open-view", context);
    }

    public void executeActionInNewThread(final String id, final TGActionContext context) {
        new Thread(new Runnable(){

            public void run() {
                TGActionManager.getInstance((TGContext)TGPrintAction.this.getContext()).execute(id, context);
            }
        }).start();
    }

    protected TGRectangle getPrinterArea(UIPrinter printer, float margin) {
        Float scale = printer.getDpiScale();
        Float scaledMargin = Float.valueOf(margin * (scale != null ? scale.floatValue() : 1.0f));
        UIRectangle bounds = printer.getBounds();
        return new TGRectangle(bounds.getX() + scaledMargin.floatValue(), bounds.getY() + scaledMargin.floatValue(), bounds.getWidth() - scaledMargin.floatValue() * 2.0f, bounds.getHeight() - scaledMargin.floatValue() * 2.0f);
    }

    private class PrintDocumentImpl
    implements PrintDocument {
        private PrintLayout layout;
        private UIPrinter printer;
        private UIPrinterJob printerJob;
        private UIPrinterPage printerPage;
        private TGPainterImpl painter;
        private TGDimension size;
        private TGMargins margins;

        public PrintDocumentImpl(PrintLayout layout, UIPrinter printer, TGDimension size, TGMargins margins) {
            this.layout = layout;
            this.printer = printer;
            this.size = size;
            this.margins = margins;
            this.painter = new TGPainterImpl(printer.getResourceFactory());
        }

        public TGPainter getPainter() {
            return this.painter;
        }

        public TGDimension getSize() {
            return this.size;
        }

        public TGMargins getMargins() {
            return this.margins;
        }

        public void pageStart() {
            if (this.printerJob != null && !this.printerJob.isDisposed()) {
                this.printerPage = this.printerJob.createPage();
                this.painter.setHandle(this.printerPage.getPainter());
            }
        }

        public void pageFinish() {
            if (this.printerPage != null && !this.printerPage.isDisposed()) {
                this.printerPage.dispose();
            }
        }

        public void start() {
            this.printerJob = this.printer.createJob(this.getJobName());
        }

        public void finish() {
            if (this.printerJob != null && !this.printerJob.isDisposed()) {
                this.printerJob.dispose();
                this.printerJob = null;
                TGSynchronizer.getInstance((TGContext)TGPrintAction.this.getContext()).executeLater(new Runnable(){

                    public void run() {
                        PrintDocumentImpl.this.dispose();
                    }
                });
            }
        }

        public boolean isTransparentBackground() {
            return true;
        }

        public boolean isPaintable(int page) {
            Integer startPage = this.printer.getStartPage();
            if (startPage != null && startPage > 0 && startPage > page) {
                return false;
            }
            Integer endPage = this.printer.getEndPage();
            return endPage == null || endPage <= 0 || endPage >= page;
        }

        public String getJobName() {
            String prefix = "TuxGuitar";
            String song = this.layout.getSong().getName();
            return song != null && song.length() > 0 ? prefix + "-" + song : prefix;
        }

        public void dispose() {
            if (!this.printer.isDisposed()) {
                this.printer.dispose();
            }
        }
    }
}

