/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.gtp;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.herac.tuxguitar.gm.GMChannelRoute;
import org.herac.tuxguitar.gm.GMChannelRouter;
import org.herac.tuxguitar.gm.GMChannelRouterConfigurator;
import org.herac.tuxguitar.io.base.TGOutputStreamBase;
import org.herac.tuxguitar.io.gtp.GTPFileFormat;
import org.herac.tuxguitar.io.gtp.GTPSettings;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGSong;

public abstract class GTPOutputStream
extends GTPFileFormat
implements TGOutputStreamBase {
    private GMChannelRouter channelRouter;
    private OutputStream outputStream;

    public GTPOutputStream(GTPSettings settings) {
        super(settings);
    }

    public void init(TGFactory factory, OutputStream stream) {
        super.init(factory);
        this.outputStream = stream;
    }

    protected void skipBytes(int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            this.outputStream.write(0);
        }
    }

    protected void writeByte(byte v) throws IOException {
        this.outputStream.write(v);
    }

    protected void writeUnsignedByte(int v) throws IOException {
        this.outputStream.write(v);
    }

    protected void writeBytes(byte[] v) throws IOException {
        this.outputStream.write(v);
    }

    protected void writeBoolean(boolean v) throws IOException {
        this.outputStream.write(v ? 1 : 0);
    }

    protected void writeInt(int v) throws IOException {
        byte[] bytes = new byte[]{(byte)(v & 0xFF), (byte)(v >> 8 & 0xFF), (byte)(v >> 16 & 0xFF), (byte)(v >> 24 & 0xFF)};
        this.outputStream.write(bytes);
    }

    protected void writeString(byte[] bytes, int maximumLength) throws IOException {
        int length = maximumLength == 0 || maximumLength > bytes.length ? bytes.length : maximumLength;
        for (int i = 0; i < length; ++i) {
            this.outputStream.write(bytes[i]);
        }
    }

    protected void writeStringInteger(String string, String charset) throws IOException {
        byte[] bytes = string.getBytes(charset);
        this.writeInt(bytes.length);
        this.writeString(bytes, 0);
    }

    protected void writeStringInteger(String string) throws IOException {
        this.writeStringInteger(string, this.getSettings().getCharset());
    }

    protected void writeStringByte(String string, int size, String charset) throws IOException {
        byte[] bytes = string.getBytes(charset);
        this.writeByte((byte)(size == 0 || size > bytes.length ? bytes.length : size));
        this.writeString(bytes, size);
        this.skipBytes(size - bytes.length);
    }

    protected void writeStringByte(String string, int size) throws IOException {
        this.writeStringByte(string, size, this.getSettings().getCharset());
    }

    protected void writeStringByteSizeOfInteger(String string, String charset) throws IOException {
        byte[] bytes = string.getBytes(charset);
        this.writeInt(bytes.length + 1);
        this.writeStringByte(string, bytes.length, charset);
    }

    protected void writeStringByteSizeOfInteger(String string) throws IOException {
        this.writeStringByteSizeOfInteger(string, this.getSettings().getCharset());
    }

    protected void close() throws IOException {
        this.outputStream.flush();
        this.outputStream.close();
    }

    protected void configureChannelRouter(TGSong song) {
        this.channelRouter = new GMChannelRouter();
        GMChannelRouterConfigurator gmChannelRouterConfigurator = new GMChannelRouterConfigurator(this.channelRouter);
        gmChannelRouterConfigurator.configureRouter(song.getChannels());
    }

    protected GMChannelRoute getChannelRoute(int channelId) {
        GMChannelRoute gmChannelRoute = this.channelRouter.getRoute(channelId);
        if (gmChannelRoute == null || gmChannelRoute.getChannel1() < 0 || gmChannelRoute.getChannel2() < 0) {
            Integer defaultChannel = gmChannelRoute != null && gmChannelRoute.getChannel1() >= 0 ? gmChannelRoute.getChannel1() : 15;
            gmChannelRoute = new GMChannelRoute(channelId);
            gmChannelRoute.setChannel1(defaultChannel.intValue());
            gmChannelRoute.setChannel2(defaultChannel.intValue());
        }
        return gmChannelRoute;
    }

    protected boolean isPercussionChannel(TGSong song, int channelId) {
        Iterator it = song.getChannels();
        while (it.hasNext()) {
            TGChannel channel = (TGChannel)it.next();
            if (channel.getChannelId() != channelId) continue;
            return channel.isPercussionChannel();
        }
        return false;
    }
}

