/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gm;

import java.util.Iterator;
import org.herac.tuxguitar.gm.GMChannelRoute;
import org.herac.tuxguitar.gm.GMChannelRouter;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGChannelParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GMChannelRouterConfigurator {
    private GMChannelRouter router;

    public GMChannelRouterConfigurator(GMChannelRouter router) {
        this.router = router;
    }

    public void configureRouter(Iterator<TGChannel> tgChannels) {
        this.router.resetRoutes();
        while (tgChannels.hasNext()) {
            TGChannel tgChannel = tgChannels.next();
            GMChannelRoute cmChannelRoute = new GMChannelRoute(tgChannel.getChannelId());
            cmChannelRoute.setChannel1(this.getIntegerChannelParameter(tgChannel, "gm-channel-1", -1));
            cmChannelRoute.setChannel2(this.getIntegerChannelParameter(tgChannel, "gm-channel-2", -1));
            this.router.configureRoutes(cmChannelRoute, tgChannel.isPercussionChannel());
        }
    }

    private int getIntegerChannelParameter(TGChannel tgChannel, String key, int nullValue) {
        TGChannelParameter tgChannelParameter = this.findChannelParameter(tgChannel, key);
        if (tgChannelParameter != null && tgChannelParameter.getValue() != null) {
            return Integer.parseInt(tgChannelParameter.getValue());
        }
        return nullValue;
    }

    private TGChannelParameter findChannelParameter(TGChannel tgChannel, String key) {
        Iterator it = tgChannel.getParameters();
        while (it.hasNext()) {
            TGChannelParameter parameter = (TGChannelParameter)it.next();
            if (!parameter.getKey().equals(key)) continue;
            return parameter;
        }
        return null;
    }
}

