/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gm;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.gm.GMChannelRoute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GMChannelRouter {
    public static final short MAX_CHANNELS = 16;
    public static final short PERCUSSION_CHANNEL = 9;
    private List<GMChannelRoute> midiChannels = new ArrayList<GMChannelRoute>();

    public void resetRoutes() {
        this.midiChannels.clear();
    }

    public void removeRoute(GMChannelRoute route) {
        if (this.midiChannels.contains(route)) {
            this.midiChannels.remove(route);
        }
    }

    public GMChannelRoute getRoute(int channelId) {
        for (GMChannelRoute midiChannel : this.midiChannels) {
            if (midiChannel.getChannelId() != channelId) continue;
            return midiChannel;
        }
        return null;
    }

    public void configureRoutes(GMChannelRoute route, boolean percussionChannel) {
        List<GMChannelRoute> conflictingRoutes = null;
        if (this.midiChannels.contains(route)) {
            this.midiChannels.remove(route);
        }
        if (percussionChannel) {
            route.setChannel1(9);
            route.setChannel2(9);
        } else if (route.getChannel1() >= 0) {
            if (route.getChannel2() < 0) {
                route.setChannel2(route.getChannel1());
            }
            conflictingRoutes = this.findConflictingRoutes(route);
        } else {
            List<Integer> freeChannels = this.getFreeChannels();
            route.setChannel1(freeChannels.size() > 0 ? freeChannels.get(0) : -1);
            route.setChannel2(freeChannels.size() > 1 ? freeChannels.get(1).intValue() : route.getChannel1());
        }
        this.midiChannels.add(route);
        if (conflictingRoutes != null) {
            for (GMChannelRoute conflictingRoute : conflictingRoutes) {
                conflictingRoute.setChannel1(-1);
                conflictingRoute.setChannel2(-1);
                this.configureRoutes(conflictingRoute, false);
            }
        }
    }

    public List<GMChannelRoute> findConflictingRoutes(GMChannelRoute gmChannelRoute) {
        ArrayList<GMChannelRoute> routes = new ArrayList<GMChannelRoute>();
        for (GMChannelRoute route : this.midiChannels) {
            if (route.equals(gmChannelRoute) || route.getChannel1() != gmChannelRoute.getChannel1() && route.getChannel1() != gmChannelRoute.getChannel2() && route.getChannel2() != gmChannelRoute.getChannel1() && route.getChannel2() != gmChannelRoute.getChannel2()) continue;
            routes.add(route);
        }
        return routes;
    }

    public List<Integer> getFreeChannels() {
        return this.getFreeChannels(null);
    }

    public List<Integer> getFreeChannels(GMChannelRoute forRoute) {
        ArrayList<Integer> freeChannels = new ArrayList<Integer>();
        for (int ch = 0; ch < 16; ++ch) {
            if (ch == 9) continue;
            boolean isFreeChannel = true;
            for (GMChannelRoute route : this.midiChannels) {
                if (forRoute != null && forRoute.equals(route) || route.getChannel1() != ch && route.getChannel2() != ch) continue;
                isFreeChannel = false;
            }
            if (!isFreeChannel) continue;
            freeChannels.add(new Integer(ch));
        }
        return freeChannels;
    }
}

