/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.community.startup;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.community.TGCommunitySingleton;
import org.herac.tuxguitar.community.utils.TGCommunityWeb;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGException;
import org.herac.tuxguitar.util.TGSynchronizer;

public class TGCommunityStartupScreen {
    private static final int MAIN_WIDTH = 550;
    private static final int MAIN_HEIGHT = -1;
    private TGContext context;

    public TGCommunityStartupScreen(TGContext context) {
        this.context = context;
    }

    public void open() {
        try {
            final Shell parent = TuxGuitar.getInstance().getShell();
            TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){

                public void run() throws TGException {
                    TGCommunityStartupScreen.this.open(parent);
                }
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected void open(Shell parent) {
        final Shell dialog = DialogUtils.newDialog((Shell)TuxGuitar.getInstance().getShell(), (int)2144);
        dialog.setLayout((Layout)new GridLayout());
        dialog.setLayoutData((Object)new GridData(4, 4, true, true));
        dialog.setImage(TuxGuitar.getInstance().getIconManager().getAppIcon());
        dialog.setText(TuxGuitar.getProperty((String)"tuxguitar-community.welcome-dialog.title"));
        Composite composite = new Composite((Composite)dialog, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(550, -1));
        Composite top = new Composite(composite, 0);
        top.setLayout((Layout)new GridLayout(2, false));
        top.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite topLeft = new Composite(top, 0);
        topLeft.setLayout((Layout)new GridLayout());
        topLeft.setLayoutData((Object)new GridData(16384, 128, false, false));
        Label image = new Label(topLeft, 0);
        image.setImage(TuxGuitar.getInstance().getIconManager().getAppIcon());
        Composite topRight = new Composite(top, 0);
        topRight.setLayout((Layout)new GridLayout(2, false));
        topRight.setLayoutData((Object)new GridData(4, 4, true, true));
        this.addTitle(topRight, TuxGuitar.getProperty((String)"tuxguitar-community.welcome-dialog.title"));
        this.addTipItem(topRight);
        this.addComment(topRight, TuxGuitar.getProperty((String)"tuxguitar-community.welcome-dialog.tip-1"));
        this.addTipItem(topRight);
        this.addComment(topRight, TuxGuitar.getProperty((String)"tuxguitar-community.welcome-dialog.tip-2"));
        Composite bottom = new Composite(composite, 0);
        bottom.setLayout((Layout)new GridLayout());
        bottom.setLayoutData((Object)new GridData(4, 4, true, true));
        this.addComment(bottom, TuxGuitar.getProperty((String)"tuxguitar-community.welcome-dialog.tip-bottom"));
        Composite buttons = new Composite(composite, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(4, 4, true, true));
        final Button buttonDisabled = new Button(buttons, 32);
        buttonDisabled.setLayoutData((Object)new GridData(16384, 4, true, true));
        buttonDisabled.setText(TuxGuitar.getProperty((String)"tuxguitar-community.welcome-dialog.disable"));
        buttonDisabled.setSelection(this.isDisabled());
        Button buttonOK = new Button(buttons, 8);
        buttonOK.setText(TuxGuitar.getProperty((String)"ok"));
        buttonOK.setLayoutData((Object)this.getButtonOkData());
        buttonOK.setFocus();
        buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TGCommunityStartupScreen.this.setDisabled(buttonDisabled.getSelection());
                dialog.dispose();
            }
        });
        dialog.setDefaultButton(buttonOK);
        DialogUtils.openDialog((Shell)dialog, (int)10);
    }

    private GridData getButtonOkData() {
        GridData data = new GridData(131072, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    private void addTitle(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setLayoutData((Object)new GridData(4, 128, true, true, 2, 1));
        label.setText(text);
        FontData[] fontDatas = label.getFont().getFontData();
        if (fontDatas.length > 0) {
            int fHeight = fontDatas[0].getHeight() + 2;
            int fStyle = fontDatas[0].getStyle() | 1;
            final Font font = new Font((Device)label.getDisplay(), fontDatas[0].getName(), fHeight, fStyle);
            label.setFont(font);
            label.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent arg0) {
                    font.dispose();
                }
            });
        }
    }

    private void addTipItem(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setLayoutData((Object)new GridData(16384, 128, false, true));
        label.setText("\u066d");
    }

    private void addComment(Composite parent, String text) {
        Link link = new Link(parent, 16384);
        link.setLayoutData((Object)new GridData(4, 4, true, true));
        link.setText(text);
        link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                final String href = event.text;
                if (href != null) {
                    new Thread(new Runnable(){

                        public void run() throws TGException {
                            TGCommunityWeb.open(TGCommunityStartupScreen.this.getContext(), href);
                        }
                    }).start();
                }
            }
        });
    }

    public void setDisabled(boolean enabled) {
        TGCommunitySingleton.getInstance(this.context).getConfig().setValue("community.welcome.disabled", enabled);
    }

    public boolean isDisabled() {
        return TGCommunitySingleton.getInstance(this.context).getConfig().getBooleanValue("community.welcome.disabled");
    }

    public TGContext getContext() {
        return this.context;
    }
}

