/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.community.io;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.herac.tuxguitar.app.util.TGMessageDialogUtil;
import org.herac.tuxguitar.app.view.main.TGWindow;
import org.herac.tuxguitar.community.auth.TGCommunityAuthDialog;
import org.herac.tuxguitar.community.io.TGShareFile;
import org.herac.tuxguitar.community.io.TGShareFileDialog;
import org.herac.tuxguitar.community.io.TGShareSongConnection;
import org.herac.tuxguitar.community.io.TGShareSongResponse;
import org.herac.tuxguitar.io.tg.TGOutputStream;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGException;
import org.herac.tuxguitar.util.TGSynchronizer;
import org.herac.tuxguitar.util.error.TGErrorManager;

public class TGShareSong {
    private TGContext context;

    public TGShareSong(TGContext context) {
        this.context = context;
    }

    public void process(TGSong song) {
        try {
            TGShareFile file = new TGShareFile();
            file.setFile(this.getSongBytes(song));
            this.processDialog(file, null);
        }
        catch (Throwable throwable) {
            TGErrorManager.getInstance((TGContext)this.context).handleError(throwable);
        }
    }

    public void processDialog(final TGShareFile file, final String errors) {
        TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){

            public void run() {
                TGShareFileDialog fileDialog = new TGShareFileDialog(TGShareSong.this.getContext(), file, errors);
                fileDialog.open();
                if (fileDialog.isAccepted()) {
                    TGShareSong.this.processUpload(file);
                }
            }
        });
    }

    public void processAuthDialog(final TGShareFile file) {
        TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){

            public void run() throws TGException {
                TGCommunityAuthDialog authDialog = new TGCommunityAuthDialog(TGShareSong.this.getContext());
                authDialog.open();
                if (authDialog.isAccepted()) {
                    TGShareSong.this.processUpload(file);
                }
            }
        });
    }

    public void processUpload(final TGShareFile file) {
        this.setActiveMode();
        new Thread(new Runnable(){

            public void run() throws TGException {
                try {
                    TGShareSongConnection share = new TGShareSongConnection(TGShareSong.this.getContext());
                    share.uploadFile(file, TGShareSong.this);
                }
                catch (Throwable throwable) {
                    TGErrorManager.getInstance((TGContext)TGShareSong.this.getContext()).handleError(throwable);
                }
            }
        }).start();
    }

    public void processResult(TGShareSongResponse response, TGShareFile file) {
        this.setPassiveMode();
        try {
            String status = response.getStatus();
            if (status != null && status.equals("200")) {
                TGMessageDialogUtil.infoMessage((TGContext)this.context, (String)"File Uploaded", (String)"File upload completed!!");
            } else if (status != null && status.equals("401")) {
                this.processAuthDialog(file);
            } else if (status != null && status.equals("400")) {
                String message = new String();
                ArrayList<String> messages = new ArrayList<String>();
                response.loadMessages(messages);
                Iterator it = messages.iterator();
                while (it.hasNext()) {
                    message = message + (String)it.next() + "\r\n";
                }
                this.processDialog(file, message);
            } else {
                this.processDialog(file, "Error: " + status);
            }
        }
        catch (Throwable throwable) {
            TGErrorManager.getInstance((TGContext)this.context).handleError(throwable);
        }
    }

    private byte[] getSongBytes(TGSong song) throws Throwable {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        TGOutputStream tgStream = new TGOutputStream();
        tgStream.init(new TGFactory(), (OutputStream)out);
        tgStream.writeSong(song);
        out.close();
        return out.toByteArray();
    }

    public void setActiveMode() {
        TGWindow.getInstance((TGContext)this.context).loadBusyCursor();
    }

    public void setPassiveMode() {
        TGWindow.getInstance((TGContext)this.context).loadDefaultCursor();
    }

    public TGContext getContext() {
        return this.context;
    }
}

