/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.win32;

import org.eclipse.swt.internal.win32.OS;

public class TCHAR {
    int codePage;
    public char[] chars;
    public byte[] bytes;
    int byteCount;
    public static final int sizeof = OS.IsUnicode ? 2 : 1;

    public TCHAR(int n, int n2) {
        this.codePage = n;
        if (OS.IsUnicode) {
            this.chars = new char[n2];
        } else {
            this.byteCount = n2;
            this.bytes = new byte[this.byteCount];
        }
    }

    public TCHAR(int n, char c, boolean bl) {
        char[] cArray;
        if (bl) {
            char[] cArray2 = new char[2];
            cArray2[0] = c;
            cArray = cArray2;
            cArray2[1] = '\u0000';
        } else {
            char[] cArray3 = new char[1];
            cArray = cArray3;
            cArray3[0] = c;
        }
        this(n, cArray, false);
    }

    public TCHAR(int n, char[] cArray, boolean bl) {
        this.codePage = n;
        int n2 = cArray.length;
        if (OS.IsUnicode) {
            if (bl && (n2 == 0 || n2 > 0 && cArray[n2 - 1] != '\u0000')) {
                char[] cArray2 = new char[n2 + 1];
                System.arraycopy(cArray, 0, cArray2, 0, n2);
                cArray = cArray2;
            }
            this.chars = cArray;
        } else {
            int n3 = n != 0 ? n : 0;
            this.byteCount = n2 * 2 + (bl ? 1 : 0);
            this.bytes = new byte[this.byteCount];
            this.byteCount = OS.WideCharToMultiByte(n3, 0, cArray, n2, this.bytes, this.byteCount, null, null);
            if (bl) {
                ++this.byteCount;
            }
        }
    }

    public TCHAR(int n, String string, boolean bl) {
        this(n, TCHAR.getChars(string, bl), false);
    }

    static char[] getChars(String string, boolean bl) {
        int n = string.length();
        char[] cArray = new char[n + (bl ? 1 : 0)];
        string.getChars(0, n, cArray, 0);
        return cArray;
    }

    public int length() {
        if (OS.IsUnicode) {
            return this.chars.length;
        }
        return this.byteCount;
    }

    public int strlen() {
        if (OS.IsUnicode) {
            for (int i = 0; i < this.chars.length; ++i) {
                if (this.chars[i] != '\u0000') continue;
                return i;
            }
            return this.chars.length;
        }
        for (int i = 0; i < this.byteCount; ++i) {
            if (this.bytes[i] != 0) continue;
            return i;
        }
        return this.byteCount;
    }

    public int tcharAt(int n) {
        if (OS.IsUnicode) {
            return this.chars[n];
        }
        int n2 = this.bytes[n] & 0xFF;
        if (OS.IsDBCSLeadByte((byte)n2)) {
            n2 = n2 << 8 | this.bytes[n + 1] & 0xFF;
        }
        return n2;
    }

    public String toString() {
        return this.toString(0, this.length());
    }

    public String toString(int n, int n2) {
        if (OS.IsUnicode) {
            return new String(this.chars, n, n2);
        }
        byte[] byArray = this.bytes;
        if (n != 0) {
            byArray = new byte[n2];
            System.arraycopy(this.bytes, n, byArray, 0, n2);
        }
        char[] cArray = new char[n2];
        int n3 = this.codePage != 0 ? this.codePage : 0;
        int n4 = OS.MultiByteToWideChar(n3, 1, byArray, n2, cArray, n2);
        return new String(cArray, 0, n4);
    }
}

