/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.editor.undo.impl.track;

import org.herac.tuxguitar.editor.undo.TGCannotRedoException;
import org.herac.tuxguitar.editor.undo.TGCannotUndoException;
import org.herac.tuxguitar.editor.undo.impl.track.TGUndoableTrackBase;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.util.TGContext;

public class TGUndoableMoveTrackUp
extends TGUndoableTrackBase {
    private int doAction;
    private int trackNumber;

    private TGUndoableMoveTrackUp(TGContext context) {
        super(context);
    }

    public void redo() throws TGCannotRedoException {
        if (!this.canRedo()) {
            throw new TGCannotRedoException();
        }
        this.moveTrackUp(this.getSong(), this.getSongManager().getTrack(this.getSong(), this.trackNumber + 1));
        this.doAction = 1;
    }

    public void undo() throws TGCannotUndoException {
        if (!this.canUndo()) {
            throw new TGCannotUndoException();
        }
        this.moveTrackDown(this.getSong(), this.getSongManager().getTrack(this.getSong(), this.trackNumber));
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static TGUndoableMoveTrackUp startUndo(TGContext context) {
        TGUndoableMoveTrackUp undoable = new TGUndoableMoveTrackUp(context);
        undoable.doAction = 1;
        return undoable;
    }

    public TGUndoableMoveTrackUp endUndo(TGTrack track) {
        this.trackNumber = track.getNumber();
        return this;
    }
}

