/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.editor.undo.impl.custom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.editor.undo.TGCannotRedoException;
import org.herac.tuxguitar.editor.undo.TGCannotUndoException;
import org.herac.tuxguitar.editor.undo.impl.TGUndoableEditBase;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.util.TGContext;

public class TGUndoableTripletFeel
extends TGUndoableEditBase {
    private int doAction;
    private long position;
    private int redoableTripletFeel;
    private int undoableTripletFeel;
    private List<Object> nextTripletFeelPositions;
    private boolean toEnd;

    private TGUndoableTripletFeel(TGContext context) {
        super(context);
    }

    public void redo() throws TGCannotRedoException {
        if (!this.canRedo()) {
            throw new TGCannotRedoException();
        }
        this.changeTripletFeel(this.getSong(), this.getMeasureHeaderAt(this.position), this.redoableTripletFeel, this.toEnd);
        this.doAction = 1;
    }

    public void undo() throws TGCannotUndoException {
        if (!this.canUndo()) {
            throw new TGCannotUndoException();
        }
        this.changeTripletFeel(this.getSong(), this.getMeasureHeaderAt(this.position), this.undoableTripletFeel, this.toEnd);
        if (this.toEnd) {
            for (TripletFeelPosition tripletFeelPosition : this.nextTripletFeelPositions) {
                this.changeTripletFeel(this.getSong(), this.getMeasureHeaderAt(tripletFeelPosition.getPosition()), tripletFeelPosition.getTripletFeel(), true);
            }
        }
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static TGUndoableTripletFeel startUndo(TGContext context, TGMeasureHeader header) {
        TGUndoableTripletFeel undoable = new TGUndoableTripletFeel(context);
        undoable.doAction = 1;
        undoable.position = header.getStart();
        undoable.undoableTripletFeel = header.getTripletFeel();
        undoable.nextTripletFeelPositions = new ArrayList<Object>();
        int prevTripletFeel = undoable.undoableTripletFeel;
        Iterator it = TGUndoableTripletFeel.getSong(context).getMeasureHeaders();
        while (it.hasNext()) {
            TGMeasureHeader currHeader = (TGMeasureHeader)it.next();
            if (currHeader.getStart() <= undoable.position) continue;
            int currTripletFeel = currHeader.getTripletFeel();
            if (prevTripletFeel != currTripletFeel) {
                TGUndoableTripletFeel tGUndoableTripletFeel = undoable;
                tGUndoableTripletFeel.getClass();
                TripletFeelPosition tfp = tGUndoableTripletFeel.new TripletFeelPosition(currHeader.getStart(), currTripletFeel);
                undoable.nextTripletFeelPositions.add(tfp);
            }
            prevTripletFeel = currTripletFeel;
        }
        return undoable;
    }

    public TGUndoableTripletFeel endUndo(int tripletFeel, boolean toEnd) {
        this.redoableTripletFeel = tripletFeel;
        this.toEnd = toEnd;
        return this;
    }

    public TGMeasureHeader getMeasureHeaderAt(Long start) {
        return this.getSongManager().getMeasureHeaderAt(this.getSong(), start.longValue());
    }

    public void changeTripletFeel(TGSong song, TGMeasureHeader header, Integer tripletFeel, Boolean applyToEnd) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.composition.change-triplet-feel");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, song);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_HEADER, header);
        tgActionProcessor.setAttribute("tripletFeel", tripletFeel);
        tgActionProcessor.setAttribute("applyToEnd", applyToEnd);
        this.processByPassUndoableAction(tgActionProcessor);
    }

    private class TripletFeelPosition {
        private long position;
        private int tripletFeel;

        public TripletFeelPosition(long position, int tripletFeel) {
            this.position = position;
            this.tripletFeel = tripletFeel;
        }

        public long getPosition() {
            return this.position;
        }

        public int getTripletFeel() {
            return this.tripletFeel;
        }
    }
}

