/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.toolbar;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.app.view.toolbar.TGToolBar;
import org.herac.tuxguitar.app.view.toolbar.TGToolBarSection;

public class TGToolBarSectionMarker
implements TGToolBarSection {
    private ToolItem menuItem;

    public void createSection(final TGToolBar toolBar) {
        this.menuItem = new ToolItem(toolBar.getControl(), 8);
        this.menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TGToolBarSectionMarker.this.createMenu(toolBar, (ToolItem)event.widget);
            }
        });
        this.loadIcons(toolBar);
        this.loadProperties(toolBar);
    }

    public void loadProperties(TGToolBar toolBar) {
        this.menuItem.setToolTipText(toolBar.getText("marker"));
    }

    public void loadIcons(TGToolBar toolBar) {
        this.menuItem.setImage(toolBar.getIconManager().getMarkerList());
    }

    public void updateItems(TGToolBar toolBar) {
    }

    public void createMenu(TGToolBar toolBar, ToolItem item) {
        Menu menu = new Menu((Control)item.getParent().getShell());
        MenuItem add = new MenuItem(menu, 8);
        add.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.gui.open-marker-editor-dialog"));
        add.setText(toolBar.getText("marker.add"));
        add.setImage(toolBar.getIconManager().getMarkerAdd());
        MenuItem list = new MenuItem(menu, 8);
        list.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.gui.toggle-marker-list"));
        list.setText(toolBar.getText("marker.list"));
        list.setImage(toolBar.getIconManager().getMarkerList());
        new MenuItem(menu, 2);
        MenuItem first = new MenuItem(menu, 8);
        first.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.marker.go-first"));
        first.setText(toolBar.getText("marker.first"));
        first.setImage(toolBar.getIconManager().getMarkerFirst());
        MenuItem previous = new MenuItem(menu, 8);
        previous.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.marker.go-previous"));
        previous.setText(toolBar.getText("marker.previous"));
        previous.setImage(toolBar.getIconManager().getMarkerPrevious());
        MenuItem next = new MenuItem(menu, 8);
        next.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.marker.go-next"));
        next.setText(toolBar.getText("marker.next"));
        next.setImage(toolBar.getIconManager().getMarkerNext());
        MenuItem last = new MenuItem(menu, 8);
        last.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.marker.go-last"));
        last.setText(toolBar.getText("marker.last"));
        last.setImage(toolBar.getIconManager().getMarkerLast());
        Rectangle rect = item.getBounds();
        Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
        menu.setLocation(pt.x, pt.y + rect.height);
        menu.setVisible(true);
    }
}

