/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.toolbar;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.view.component.tab.TablatureEditor;
import org.herac.tuxguitar.app.view.component.tab.edit.EditorKit;
import org.herac.tuxguitar.app.view.toolbar.TGToolBar;
import org.herac.tuxguitar.app.view.toolbar.TGToolBarSection;
import org.herac.tuxguitar.editor.undo.TGUndoableManager;
import org.herac.tuxguitar.player.base.MidiPlayer;
import org.herac.tuxguitar.util.TGContext;

public class TGToolBarSectionEdit
implements TGToolBarSection {
    private ToolItem undo;
    private ToolItem redo;
    private ToolItem menuItem;

    public void createSection(final TGToolBar toolBar) {
        this.undo = new ToolItem(toolBar.getControl(), 8);
        this.undo.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.edit.undo"));
        this.redo = new ToolItem(toolBar.getControl(), 8);
        this.redo.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.edit.redo"));
        this.menuItem = new ToolItem(toolBar.getControl(), 8);
        this.menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TGToolBarSectionEdit.this.createMenu(toolBar, (ToolItem)event.widget);
            }
        });
        this.loadIcons(toolBar);
        this.loadProperties(toolBar);
    }

    public void updateItems(TGToolBar toolBar) {
        boolean running = MidiPlayer.getInstance((TGContext)toolBar.getContext()).isRunning();
        TGUndoableManager undoableManager = TGUndoableManager.getInstance((TGContext)toolBar.getContext());
        this.undo.setEnabled(!running && undoableManager.canUndo());
        this.redo.setEnabled(!running && undoableManager.canRedo());
    }

    public void loadProperties(TGToolBar toolBar) {
        this.undo.setToolTipText(toolBar.getText("edit.undo"));
        this.redo.setToolTipText(toolBar.getText("edit.redo"));
        this.menuItem.setToolTipText(toolBar.getText("edit"));
    }

    public void loadIcons(TGToolBar toolBar) {
        this.undo.setImage(toolBar.getIconManager().getEditUndo());
        this.redo.setImage(toolBar.getIconManager().getEditRedo());
        this.menuItem.setImage(toolBar.getIconManager().getEditModeEdition());
    }

    public void createMenu(TGToolBar toolBar, ToolItem item) {
        TablatureEditor editor = TablatureEditor.getInstance(toolBar.getContext());
        EditorKit editorKit = editor.getTablature().getEditorKit();
        boolean running = TuxGuitar.getInstance().getPlayer().isRunning();
        Menu menu = new Menu((Control)item.getParent().getShell());
        MenuItem voice1 = new MenuItem(menu, 8);
        voice1.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.edit.voice-1"));
        voice1.setText(toolBar.getText("edit.voice-1", editor.getTablature().getCaret().getVoice() == 0));
        voice1.setImage(toolBar.getIconManager().getEditVoice1());
        voice1.setEnabled(!running);
        MenuItem voice2 = new MenuItem(menu, 8);
        voice2.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.edit.voice-2"));
        voice2.setText(toolBar.getText("edit.voice-2", editor.getTablature().getCaret().getVoice() == 1));
        voice2.setImage(toolBar.getIconManager().getEditVoice2());
        voice2.setEnabled(!running);
        new MenuItem(menu, 2);
        MenuItem modeSelection = new MenuItem(menu, 8);
        modeSelection.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.edit.set-mouse-mode-selection"));
        modeSelection.setText(toolBar.getText("edit.mouse-mode-selection", editorKit.getMouseMode() == 1));
        modeSelection.setImage(toolBar.getIconManager().getEditModeSelection());
        modeSelection.setEnabled(!running);
        MenuItem modeEdition = new MenuItem(menu, 8);
        modeEdition.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.edit.set-mouse-mode-edition"));
        modeEdition.setText(toolBar.getText("edit.mouse-mode-edition", editorKit.getMouseMode() == 2));
        modeEdition.setImage(toolBar.getIconManager().getEditModeEdition());
        modeEdition.setEnabled(!running);
        MenuItem notNaturalKey = new MenuItem(menu, 8);
        notNaturalKey.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.edit.set-natural-key"));
        notNaturalKey.setText(toolBar.getText("edit.not-natural-key", !editorKit.isNatural()));
        notNaturalKey.setImage(toolBar.getIconManager().getEditModeEditionNotNatural());
        notNaturalKey.setEnabled(!running && editorKit.getMouseMode() == 2);
        Rectangle rect = item.getBounds();
        Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
        menu.setLocation(pt.x, pt.y + rect.height);
        menu.setVisible(true);
    }
}

