/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.toolbar;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.action.TGActionProcessorListener;
import org.herac.tuxguitar.app.view.component.tab.Tablature;
import org.herac.tuxguitar.app.view.component.tab.TablatureEditor;
import org.herac.tuxguitar.app.view.toolbar.TGToolBar;
import org.herac.tuxguitar.app.view.toolbar.TGToolBarSection;
import org.herac.tuxguitar.document.TGDocumentManager;
import org.herac.tuxguitar.editor.action.duration.TGSetDivisionTypeDurationAction;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGDivisionType;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.util.TGContext;

public class TGToolBarSectionDuration
implements TGToolBarSection {
    private ToolItem dotted;
    private ToolItem doubleDotted;
    private ToolItem durationItem;
    private ToolItem divisionTypeItem;
    private Map<Integer, String> durationNameKeys;
    private Map<Integer, String> durationActions;
    private Integer durationValue;

    public TGToolBarSectionDuration() {
        this.createDurationNames();
        this.createDurationActions();
    }

    public void createSection(final TGToolBar toolBar) {
        this.durationItem = new ToolItem(toolBar.getControl(), 8);
        this.durationItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TGToolBarSectionDuration.this.createDurationMenu(toolBar, (ToolItem)event.widget);
            }
        });
        this.dotted = new ToolItem(toolBar.getControl(), 32);
        this.dotted.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.note.duration.change-dotted"));
        this.doubleDotted = new ToolItem(toolBar.getControl(), 32);
        this.doubleDotted.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.note.duration.change-double-dotted"));
        this.divisionTypeItem = new ToolItem(toolBar.getControl(), 4);
        this.divisionTypeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TGToolBarSectionDuration.this.processDivisionTypeSelection(toolBar, event);
            }
        });
        this.loadIcons(toolBar);
        this.loadProperties(toolBar);
    }

    public void loadProperties(TGToolBar toolBar) {
        this.durationItem.setToolTipText(toolBar.getText("duration"));
        this.dotted.setToolTipText(toolBar.getText("duration.dotted"));
        this.doubleDotted.setToolTipText(toolBar.getText("duration.doubledotted"));
        this.divisionTypeItem.setToolTipText(toolBar.getText("duration.division-type"));
    }

    public void loadIcons(TGToolBar toolBar) {
        this.dotted.setImage(toolBar.getIconManager().getDurationDotted());
        this.doubleDotted.setImage(toolBar.getIconManager().getDurationDoubleDotted());
        this.divisionTypeItem.setImage(toolBar.getIconManager().getDivisionType());
        this.loadDurationIcon(toolBar, true);
    }

    public void loadDurationIcon(TGToolBar toolBar, boolean force) {
        Image icon;
        int durationValue = 4;
        Tablature tablature = toolBar.getTablature();
        if (tablature != null) {
            durationValue = tablature.getCaret().getDuration().getValue();
        }
        if ((force || this.durationValue == null || !this.durationValue.equals(durationValue)) && (icon = this.findDurationIcon(toolBar, durationValue)) != null) {
            this.durationItem.setImage(icon);
            this.durationValue = durationValue;
        }
    }

    public void updateItems(TGToolBar toolBar) {
        TGDuration duration = toolBar.getTablature().getCaret().getDuration();
        boolean running = TuxGuitar.getInstance().getPlayer().isRunning();
        this.loadDurationIcon(toolBar, false);
        this.durationItem.setEnabled(!running);
        this.dotted.setSelection(duration.isDotted());
        this.dotted.setEnabled(!running);
        this.doubleDotted.setSelection(duration.isDoubleDotted());
        this.doubleDotted.setEnabled(!running);
        this.divisionTypeItem.setEnabled(!running);
    }

    public void createDurationMenu(TGToolBar toolBar, ToolItem item) {
        TGDuration duration = TablatureEditor.getInstance(toolBar.getContext()).getTablature().getCaret().getDuration();
        boolean running = TuxGuitar.getInstance().getPlayer().isRunning();
        Menu menu = new Menu((Control)item.getParent().getShell());
        this.createDurationMenuItem(toolBar, menu, 1, duration.getValue(), running);
        this.createDurationMenuItem(toolBar, menu, 2, duration.getValue(), running);
        this.createDurationMenuItem(toolBar, menu, 4, duration.getValue(), running);
        this.createDurationMenuItem(toolBar, menu, 8, duration.getValue(), running);
        this.createDurationMenuItem(toolBar, menu, 16, duration.getValue(), running);
        this.createDurationMenuItem(toolBar, menu, 32, duration.getValue(), running);
        this.createDurationMenuItem(toolBar, menu, 64, duration.getValue(), running);
        Rectangle rect = item.getBounds();
        Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
        menu.setLocation(pt.x, pt.y + rect.height);
        menu.setVisible(true);
    }

    private void createDurationMenuItem(TGToolBar toolBar, Menu menu, int value, int selection, boolean running) {
        Image icon = this.findDurationIcon(toolBar, value);
        String action = this.findDurationAction(value);
        String nameKey = this.findDurationNameKey(value);
        if (icon != null && action != null && nameKey != null) {
            MenuItem menuItem = new MenuItem(menu, 8);
            menuItem.setEnabled(!running);
            menuItem.addSelectionListener((SelectionListener)toolBar.createActionProcessor(action));
            menuItem.setText(toolBar.getText(nameKey, value == selection));
            menuItem.setImage(icon);
        }
    }

    private void createDurationNames() {
        this.durationNameKeys = new HashMap<Integer, String>();
        this.durationNameKeys.put(1, "duration.whole");
        this.durationNameKeys.put(2, "duration.half");
        this.durationNameKeys.put(4, "duration.quarter");
        this.durationNameKeys.put(8, "duration.eighth");
        this.durationNameKeys.put(16, "duration.sixteenth");
        this.durationNameKeys.put(32, "duration.thirtysecond");
        this.durationNameKeys.put(64, "duration.sixtyfourth");
    }

    private void createDurationActions() {
        this.durationActions = new HashMap<Integer, String>();
        this.durationActions.put(1, "action.note.duration.set-whole");
        this.durationActions.put(2, "action.note.duration.set-half");
        this.durationActions.put(4, "action.note.duration.set-quarter");
        this.durationActions.put(8, "action.note.duration.set-eighth");
        this.durationActions.put(16, "action.note.duration.set-sixteenth");
        this.durationActions.put(32, "action.note.duration.set-thirty-second");
        this.durationActions.put(64, "action.note.duration.set-sixty-fourth");
    }

    private String findDurationNameKey(int value) {
        if (this.durationNameKeys.containsKey(value)) {
            return this.durationNameKeys.get(value);
        }
        return null;
    }

    private String findDurationAction(int value) {
        if (this.durationActions.containsKey(value)) {
            return this.durationActions.get(value);
        }
        return null;
    }

    private Image findDurationIcon(TGToolBar toolBar, int value) {
        return toolBar.getIconManager().getDuration(value);
    }

    public void processDivisionTypeSelection(TGToolBar toolBar, SelectionEvent event) {
        if (event.detail == 4) {
            this.createDivisionTypeMenu(toolBar, (ToolItem)event.widget);
        } else {
            this.toggleDivisionType(toolBar);
        }
    }

    private void toggleDivisionType(TGToolBar toolBar) {
        TGDuration duration = TablatureEditor.getInstance(toolBar.getContext()).getTablature().getCaret().getDuration();
        TGDivisionType divisionType = null;
        divisionType = duration.getDivision().isEqual(TGDivisionType.NORMAL) ? this.createDivisionType(toolBar, TGDivisionType.TRIPLET) : this.createDivisionType(toolBar, TGDivisionType.NORMAL);
        this.createDivisionTypeAction(toolBar, divisionType).process();
    }

    private void createDivisionTypeMenu(TGToolBar toolBar, ToolItem item) {
        TGDuration duration = TablatureEditor.getInstance(toolBar.getContext()).getTablature().getCaret().getDuration();
        Menu menu = new Menu((Control)item.getParent().getShell());
        for (int i = 0; i < TGDivisionType.ALTERED_DIVISION_TYPES.length; ++i) {
            TGDivisionType divisionType = TGDivisionType.ALTERED_DIVISION_TYPES[i];
            MenuItem menuItem = new MenuItem(menu, 32);
            menuItem.setText(toolBar.toCheckString(Integer.toString(TGDivisionType.ALTERED_DIVISION_TYPES[i].getEnters()), divisionType.isEqual(duration.getDivision())));
            menuItem.addSelectionListener((SelectionListener)this.createDivisionTypeAction(toolBar, divisionType));
        }
        Rectangle rect = item.getBounds();
        Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
        menu.setLocation(pt.x, pt.y + rect.height);
        menu.setVisible(true);
    }

    private TGDivisionType createDivisionType(TGToolBar toolBar, TGDivisionType tgDivisionTypeSrc) {
        TGFactory tgFactory = TGDocumentManager.getInstance((TGContext)toolBar.getContext()).getSongManager().getFactory();
        TGDivisionType tgDivisionTypeDst = tgFactory.newDivisionType();
        tgDivisionTypeDst.copyFrom(tgDivisionTypeSrc);
        return tgDivisionTypeDst;
    }

    private TGActionProcessorListener createDivisionTypeAction(TGToolBar toolBar, TGDivisionType tgDivisionType) {
        TGActionProcessorListener tgActionProcessor = toolBar.createActionProcessor("action.note.duration.set-division-type");
        tgActionProcessor.setAttribute(TGSetDivisionTypeDurationAction.PROPERTY_DIVISION_TYPE, this.createDivisionType(toolBar, tgDivisionType));
        return tgActionProcessor;
    }
}

