/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.menu.impl;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.view.dialog.transport.TGTransportDialog;
import org.herac.tuxguitar.app.view.menu.TGMenuItem;
import org.herac.tuxguitar.app.view.toolbar.TGToolBar;
import org.herac.tuxguitar.graphics.control.TGLayout;
import org.herac.tuxguitar.graphics.control.TGLayoutHorizontal;
import org.herac.tuxguitar.graphics.control.TGLayoutVertical;

public class ViewMenuItem
extends TGMenuItem {
    private Menu menu;
    private Menu chordMenu;
    private MenuItem layoutMenuItem;
    private MenuItem showToolbars;
    private MenuItem showInstruments;
    private MenuItem showTransport;
    private MenuItem showFretBoard;
    private MenuItem showPiano;
    private MenuItem showMatrix;
    private MenuItem pageLayout;
    private MenuItem linearLayout;
    private MenuItem multitrack;
    private MenuItem scoreEnabled;
    private MenuItem tablatureEnabled;
    private MenuItem compact;
    private MenuItem chordMenuItem;
    private MenuItem chordName;
    private MenuItem chordDiagram;

    public ViewMenuItem(Shell shell, Menu parent, int style) {
        this.layoutMenuItem = new MenuItem(parent, style);
        this.menu = new Menu((Decorations)shell, 4);
    }

    public void showItems() {
        this.showToolbars = new MenuItem(this.menu, 32);
        this.showToolbars.addSelectionListener((SelectionListener)this.createActionProcessor("action.gui.toggle-toolbars"));
        this.showInstruments = new MenuItem(this.menu, 32);
        this.showInstruments.addSelectionListener((SelectionListener)this.createActionProcessor("action.gui.toggle-channels-dialog"));
        this.showTransport = new MenuItem(this.menu, 32);
        this.showTransport.addSelectionListener((SelectionListener)this.createActionProcessor("action.gui.toggle-transport-dialog"));
        this.showFretBoard = new MenuItem(this.menu, 32);
        this.showFretBoard.addSelectionListener((SelectionListener)this.createActionProcessor("action.gui.toggle-fretboard-editor"));
        this.showPiano = new MenuItem(this.menu, 32);
        this.showPiano.addSelectionListener((SelectionListener)this.createActionProcessor("action.gui.toggle-piano-editor"));
        this.showMatrix = new MenuItem(this.menu, 32);
        this.showMatrix.addSelectionListener((SelectionListener)this.createActionProcessor("action.gui.toggle-matrix-editor"));
        new MenuItem(this.menu, 2);
        this.pageLayout = new MenuItem(this.menu, 16);
        this.pageLayout.addSelectionListener((SelectionListener)this.createActionProcessor("action.view.layout-set-page"));
        this.linearLayout = new MenuItem(this.menu, 16);
        this.linearLayout.addSelectionListener((SelectionListener)this.createActionProcessor("action.view.layout-set-linear"));
        this.multitrack = new MenuItem(this.menu, 32);
        this.multitrack.addSelectionListener((SelectionListener)this.createActionProcessor("action.view.layout-set-multitrack"));
        this.scoreEnabled = new MenuItem(this.menu, 32);
        this.scoreEnabled.addSelectionListener((SelectionListener)this.createActionProcessor("action.view.layout-set-score-enabled"));
        this.tablatureEnabled = new MenuItem(this.menu, 32);
        this.tablatureEnabled.addSelectionListener((SelectionListener)this.createActionProcessor("action.view.layout-set-tablature-enabled"));
        this.compact = new MenuItem(this.menu, 32);
        this.compact.addSelectionListener((SelectionListener)this.createActionProcessor("action.view.layout-set-compact"));
        new MenuItem(this.menu, 2);
        this.chordMenuItem = new MenuItem(this.menu, 64);
        this.chordMenu = new Menu((Decorations)this.menu.getShell(), 4);
        this.chordName = new MenuItem(this.chordMenu, 32);
        this.chordName.addSelectionListener((SelectionListener)this.createActionProcessor("action.view.layout-set-chord-name-enabled"));
        this.chordDiagram = new MenuItem(this.chordMenu, 32);
        this.chordDiagram.addSelectionListener((SelectionListener)this.createActionProcessor("action.view.layout-set-chord-diagram-enabled"));
        this.chordMenuItem.setMenu(this.chordMenu);
        this.layoutMenuItem.setMenu(this.menu);
        this.loadIcons();
        this.loadProperties();
    }

    public void update() {
        TGLayout layout = TuxGuitar.getInstance().getTablatureEditor().getTablature().getViewLayout();
        int style = layout.getStyle();
        this.showToolbars.setSelection(TGToolBar.getInstance(this.findContext()).isVisible());
        this.showInstruments.setSelection(!TuxGuitar.getInstance().getChannelManager().isDisposed());
        this.showTransport.setSelection(!TGTransportDialog.getInstance(this.findContext()).isDisposed());
        this.showFretBoard.setSelection(TuxGuitar.getInstance().getFretBoardEditor().isVisible());
        this.showPiano.setSelection(!TuxGuitar.getInstance().getPianoEditor().isDisposed());
        this.showMatrix.setSelection(!TuxGuitar.getInstance().getMatrixEditor().isDisposed());
        this.pageLayout.setSelection(layout instanceof TGLayoutVertical);
        this.linearLayout.setSelection(layout instanceof TGLayoutHorizontal);
        this.multitrack.setSelection((style & 2) != 0);
        this.scoreEnabled.setSelection((style & 4) != 0);
        this.tablatureEnabled.setSelection((style & 8) != 0);
        this.compact.setSelection((style & 1) != 0);
        this.compact.setEnabled((style & 2) == 0 || layout.getSong().countTracks() == 1);
        this.chordName.setSelection((style & 0x10) != 0);
        this.chordDiagram.setSelection((style & 0x20) != 0);
    }

    public void loadProperties() {
        this.setMenuItemTextAndAccelerator(this.layoutMenuItem, "view", null);
        this.setMenuItemTextAndAccelerator(this.showToolbars, "view.show-toolbars", "action.gui.toggle-toolbars");
        this.setMenuItemTextAndAccelerator(this.showInstruments, "view.show-instruments", "action.gui.toggle-channels-dialog");
        this.setMenuItemTextAndAccelerator(this.showTransport, "view.show-transport", "action.gui.toggle-transport-dialog");
        this.setMenuItemTextAndAccelerator(this.showFretBoard, "view.show-fretboard", "action.gui.toggle-fretboard-editor");
        this.setMenuItemTextAndAccelerator(this.showPiano, "view.show-piano", "action.gui.toggle-piano-editor");
        this.setMenuItemTextAndAccelerator(this.showMatrix, "view.show-matrix", "action.gui.toggle-matrix-editor");
        this.setMenuItemTextAndAccelerator(this.pageLayout, "view.layout.page", "action.view.layout-set-page");
        this.setMenuItemTextAndAccelerator(this.linearLayout, "view.layout.linear", "action.view.layout-set-linear");
        this.setMenuItemTextAndAccelerator(this.multitrack, "view.layout.multitrack", "action.view.layout-set-multitrack");
        this.setMenuItemTextAndAccelerator(this.scoreEnabled, "view.layout.score-enabled", "action.view.layout-set-score-enabled");
        this.setMenuItemTextAndAccelerator(this.tablatureEnabled, "view.layout.tablature-enabled", "action.view.layout-set-tablature-enabled");
        this.setMenuItemTextAndAccelerator(this.compact, "view.layout.compact", "action.view.layout-set-compact");
        this.setMenuItemTextAndAccelerator(this.chordMenuItem, "view.layout.chord-style", null);
        this.setMenuItemTextAndAccelerator(this.chordName, "view.layout.chord-name", "action.view.layout-set-chord-name-enabled");
        this.setMenuItemTextAndAccelerator(this.chordDiagram, "view.layout.chord-diagram", "action.view.layout-set-chord-diagram-enabled");
    }

    public void loadIcons() {
    }
}

