/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.menu.impl;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.view.menu.TGMenuItem;
import org.herac.tuxguitar.song.models.TGNote;

public class NoteEffectsMenuItem
extends TGMenuItem {
    private MenuItem noteEffectsMenuItem;
    private Menu menu;
    private MenuItem vibrato;
    private MenuItem bend;
    private MenuItem tremoloBar;
    private MenuItem deadNote;
    private MenuItem slide;
    private MenuItem hammer;
    private MenuItem ghostNote;
    private MenuItem accentuatedNote;
    private MenuItem heavyAccentuatedNote;
    private MenuItem letRing;
    private MenuItem harmonicNote;
    private MenuItem graceNote;
    private MenuItem trill;
    private MenuItem tremoloPicking;
    private MenuItem palmMute;
    private MenuItem staccato;
    private MenuItem tapping;
    private MenuItem slapping;
    private MenuItem popping;
    private MenuItem fadeIn;

    public NoteEffectsMenuItem(Shell shell, Menu parent, int style) {
        this.noteEffectsMenuItem = new MenuItem(parent, style);
        this.menu = new Menu((Decorations)shell, 4);
    }

    public void showItems() {
        this.vibrato = new MenuItem(this.menu, 32);
        this.vibrato.addSelectionListener((SelectionListener)this.createActionProcessor("action.note.effect.change-vibrato"));
        this.bend = new MenuItem(this.menu, 32);
        this.bend.addSelectionListener((SelectionListener)this.createActionProcessor("action.gui.open-bend-dialog"));
        this.tremoloBar = new MenuItem(this.menu, 32);
        this.tremoloBar.addSelectionListener((SelectionListener)this.createActionProcessor("action.gui.open-tremolo-bar-dialog"));
        this.slide = new MenuItem(this.menu, 32);
        this.slide.addSelectionListener((SelectionListener)this.createActionProcessor("action.note.effect.change-slide"));
        this.deadNote = new MenuItem(this.menu, 32);
        this.deadNote.addSelectionListener((SelectionListener)this.createActionProcessor("action.note.effect.change-dead"));
        this.hammer = new MenuItem(this.menu, 32);
        this.hammer.addSelectionListener((SelectionListener)this.createActionProcessor("action.note.effect.change-hammer"));
        new MenuItem(this.menu, 2);
        this.ghostNote = new MenuItem(this.menu, 32);
        this.ghostNote.addSelectionListener((SelectionListener)this.createActionProcessor("action.note.effect.change-ghost"));
        this.accentuatedNote = new MenuItem(this.menu, 32);
        this.accentuatedNote.addSelectionListener((SelectionListener)this.createActionProcessor("action.note.effect.change-accentuated"));
        this.heavyAccentuatedNote = new MenuItem(this.menu, 32);
        this.heavyAccentuatedNote.addSelectionListener((SelectionListener)this.createActionProcessor("action.note.effect.change-heavy-accentuated"));
        this.letRing = new MenuItem(this.menu, 32);
        this.letRing.addSelectionListener((SelectionListener)this.createActionProcessor("action.note.effect.change-let-ring"));
        this.harmonicNote = new MenuItem(this.menu, 32);
        this.harmonicNote.addSelectionListener((SelectionListener)this.createActionProcessor("action.gui.open-harmonic-dialog"));
        this.graceNote = new MenuItem(this.menu, 32);
        this.graceNote.addSelectionListener((SelectionListener)this.createActionProcessor("action.gui.open-grace-dialog"));
        new MenuItem(this.menu, 2);
        this.trill = new MenuItem(this.menu, 32);
        this.trill.addSelectionListener((SelectionListener)this.createActionProcessor("action.gui.open-trill-dialog"));
        this.tremoloPicking = new MenuItem(this.menu, 32);
        this.tremoloPicking.addSelectionListener((SelectionListener)this.createActionProcessor("action.gui.open-tremolo-picking-dialog"));
        this.palmMute = new MenuItem(this.menu, 32);
        this.palmMute.addSelectionListener((SelectionListener)this.createActionProcessor("action.note.effect.change-palm-mute"));
        this.staccato = new MenuItem(this.menu, 32);
        this.staccato.addSelectionListener((SelectionListener)this.createActionProcessor("action.note.effect.change-staccato"));
        new MenuItem(this.menu, 2);
        this.tapping = new MenuItem(this.menu, 32);
        this.tapping.addSelectionListener((SelectionListener)this.createActionProcessor("action.note.effect.change-tapping"));
        this.slapping = new MenuItem(this.menu, 32);
        this.slapping.addSelectionListener((SelectionListener)this.createActionProcessor("action.note.effect.change-slapping"));
        this.popping = new MenuItem(this.menu, 32);
        this.popping.addSelectionListener((SelectionListener)this.createActionProcessor("action.note.effect.change-popping"));
        new MenuItem(this.menu, 2);
        this.fadeIn = new MenuItem(this.menu, 32);
        this.fadeIn.addSelectionListener((SelectionListener)this.createActionProcessor("action.note.effect.change-fade-in"));
        this.noteEffectsMenuItem.setMenu(this.menu);
        this.loadIcons();
        this.loadProperties();
    }

    public void update() {
        TGNote note = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getSelectedNote();
        boolean running = TuxGuitar.getInstance().getPlayer().isRunning();
        this.vibrato.setSelection(note != null && note.getEffect().isVibrato());
        this.vibrato.setEnabled(!running && note != null);
        this.bend.setSelection(note != null && note.getEffect().isBend());
        this.bend.setEnabled(!running && note != null);
        this.tremoloBar.setSelection(note != null && note.getEffect().isTremoloBar());
        this.tremoloBar.setEnabled(!running && note != null);
        this.deadNote.setSelection(note != null && note.getEffect().isDeadNote());
        this.deadNote.setEnabled(!running && note != null);
        this.slide.setSelection(note != null && note.getEffect().isSlide());
        this.slide.setEnabled(!running && note != null);
        this.hammer.setSelection(note != null && note.getEffect().isHammer());
        this.hammer.setEnabled(!running && note != null);
        this.ghostNote.setSelection(note != null && note.getEffect().isGhostNote());
        this.ghostNote.setEnabled(!running && note != null);
        this.accentuatedNote.setSelection(note != null && note.getEffect().isAccentuatedNote());
        this.accentuatedNote.setEnabled(!running && note != null);
        this.heavyAccentuatedNote.setSelection(note != null && note.getEffect().isHeavyAccentuatedNote());
        this.heavyAccentuatedNote.setEnabled(!running && note != null);
        this.letRing.setSelection(note != null && note.getEffect().isLetRing());
        this.letRing.setEnabled(!running && note != null);
        this.harmonicNote.setSelection(note != null && note.getEffect().isHarmonic());
        this.harmonicNote.setEnabled(!running && note != null);
        this.graceNote.setSelection(note != null && note.getEffect().isGrace());
        this.graceNote.setEnabled(!running && note != null);
        this.trill.setSelection(note != null && note.getEffect().isTrill());
        this.trill.setEnabled(!running && note != null);
        this.tremoloPicking.setSelection(note != null && note.getEffect().isTremoloPicking());
        this.tremoloPicking.setEnabled(!running && note != null);
        this.palmMute.setSelection(note != null && note.getEffect().isPalmMute());
        this.palmMute.setEnabled(!running && note != null);
        this.staccato.setSelection(note != null && note.getEffect().isStaccato());
        this.staccato.setEnabled(!running && note != null);
        this.tapping.setSelection(note != null && note.getEffect().isTapping());
        this.tapping.setEnabled(!running && note != null);
        this.slapping.setSelection(note != null && note.getEffect().isSlapping());
        this.slapping.setEnabled(!running && note != null);
        this.popping.setSelection(note != null && note.getEffect().isPopping());
        this.popping.setEnabled(!running && note != null);
        this.fadeIn.setSelection(note != null && note.getEffect().isFadeIn());
        this.fadeIn.setEnabled(!running && note != null);
    }

    public void loadProperties() {
        this.setMenuItemTextAndAccelerator(this.noteEffectsMenuItem, "effects", null);
        this.setMenuItemTextAndAccelerator(this.vibrato, "effects.vibrato", "action.note.effect.change-vibrato");
        this.setMenuItemTextAndAccelerator(this.bend, "effects.bend", "action.gui.open-bend-dialog");
        this.setMenuItemTextAndAccelerator(this.tremoloBar, "effects.tremolo-bar", "action.gui.open-tremolo-bar-dialog");
        this.setMenuItemTextAndAccelerator(this.deadNote, "effects.deadnote", "action.note.effect.change-dead");
        this.setMenuItemTextAndAccelerator(this.slide, "effects.slide", "action.note.effect.change-slide");
        this.setMenuItemTextAndAccelerator(this.hammer, "effects.hammer", "action.note.effect.change-hammer");
        this.setMenuItemTextAndAccelerator(this.ghostNote, "effects.ghostnote", "action.note.effect.change-ghost");
        this.setMenuItemTextAndAccelerator(this.accentuatedNote, "effects.accentuatednote", "action.note.effect.change-accentuated");
        this.setMenuItemTextAndAccelerator(this.heavyAccentuatedNote, "effects.heavyaccentuatednote", "action.note.effect.change-heavy-accentuated");
        this.setMenuItemTextAndAccelerator(this.letRing, "effects.let-ring", "action.note.effect.change-let-ring");
        this.setMenuItemTextAndAccelerator(this.harmonicNote, "effects.harmonic", "action.gui.open-harmonic-dialog");
        this.setMenuItemTextAndAccelerator(this.graceNote, "effects.grace", "action.gui.open-grace-dialog");
        this.setMenuItemTextAndAccelerator(this.trill, "effects.trill", "action.gui.open-trill-dialog");
        this.setMenuItemTextAndAccelerator(this.tremoloPicking, "effects.tremolo-picking", "action.gui.open-tremolo-picking-dialog");
        this.setMenuItemTextAndAccelerator(this.palmMute, "effects.palm-mute", "action.note.effect.change-palm-mute");
        this.setMenuItemTextAndAccelerator(this.staccato, "effects.staccato", "action.note.effect.change-staccato");
        this.setMenuItemTextAndAccelerator(this.tapping, "effects.tapping", "action.note.effect.change-tapping");
        this.setMenuItemTextAndAccelerator(this.slapping, "effects.slapping", "action.note.effect.change-slapping");
        this.setMenuItemTextAndAccelerator(this.popping, "effects.popping", "action.note.effect.change-popping");
        this.setMenuItemTextAndAccelerator(this.fadeIn, "effects.fade-in", "action.note.effect.change-fade-in");
    }

    public void loadIcons() {
    }
}

