/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.menu.impl;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.view.menu.TGMenuItem;
import org.herac.tuxguitar.graphics.control.TGMeasureImpl;

public class MeasureMenuItem
extends TGMenuItem {
    private MenuItem measureMenuItem;
    private Menu menu;
    private MenuItem first;
    private MenuItem last;
    private MenuItem next;
    private MenuItem previous;
    private MenuItem addMeasure;
    private MenuItem cleanMeasure;
    private MenuItem removeMeasure;
    private MenuItem copyMeasure;
    private MenuItem pasteMeasure;

    public MeasureMenuItem(Shell shell, Menu parent, int style) {
        this.measureMenuItem = new MenuItem(parent, style);
        this.menu = new Menu((Decorations)shell, 4);
    }

    public void showItems() {
        this.first = new MenuItem(this.menu, 8);
        this.first.addSelectionListener((SelectionListener)this.createActionProcessor("action.measure.go-first"));
        this.previous = new MenuItem(this.menu, 8);
        this.previous.addSelectionListener((SelectionListener)this.createActionProcessor("action.measure.go-previous"));
        this.next = new MenuItem(this.menu, 8);
        this.next.addSelectionListener((SelectionListener)this.createActionProcessor("action.measure.go-next"));
        this.last = new MenuItem(this.menu, 8);
        this.last.addSelectionListener((SelectionListener)this.createActionProcessor("action.measure.go-last"));
        new MenuItem(this.menu, 2);
        this.addMeasure = new MenuItem(this.menu, 8);
        this.addMeasure.addSelectionListener((SelectionListener)this.createActionProcessor("action.gui.open-measure-add-dialog"));
        this.cleanMeasure = new MenuItem(this.menu, 8);
        this.cleanMeasure.addSelectionListener((SelectionListener)this.createActionProcessor("action.gui.open-measure-clean-dialog"));
        this.removeMeasure = new MenuItem(this.menu, 8);
        this.removeMeasure.addSelectionListener((SelectionListener)this.createActionProcessor("action.gui.open-measure-remove-dialog"));
        new MenuItem(this.menu, 2);
        this.copyMeasure = new MenuItem(this.menu, 8);
        this.copyMeasure.addSelectionListener((SelectionListener)this.createActionProcessor("action.gui.open-measure-copy-dialog"));
        this.pasteMeasure = new MenuItem(this.menu, 8);
        this.pasteMeasure.addSelectionListener((SelectionListener)this.createActionProcessor("action.gui.open-measure-paste-dialog"));
        this.measureMenuItem.setMenu(this.menu);
        this.loadIcons();
        this.loadProperties();
    }

    public void update() {
        TGMeasureImpl measure = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getMeasure();
        boolean running = TuxGuitar.getInstance().getPlayer().isRunning();
        boolean isFirst = measure.getNumber() == 1;
        boolean isLast = measure.getNumber() == measure.getTrack().countMeasures();
        this.first.setEnabled(!isFirst);
        this.previous.setEnabled(!isFirst);
        this.next.setEnabled(!isLast);
        this.last.setEnabled(!isLast);
        this.addMeasure.setEnabled(!running);
        this.cleanMeasure.setEnabled(!running);
        this.removeMeasure.setEnabled(!running);
        this.copyMeasure.setEnabled(!running);
        this.pasteMeasure.setEnabled(!running && !TuxGuitar.getInstance().getTablatureEditor().getClipBoard().isEmpty());
    }

    public void loadProperties() {
        this.setMenuItemTextAndAccelerator(this.measureMenuItem, "measure", null);
        this.setMenuItemTextAndAccelerator(this.first, "measure.first", "action.measure.go-first");
        this.setMenuItemTextAndAccelerator(this.last, "measure.last", "action.measure.go-last");
        this.setMenuItemTextAndAccelerator(this.previous, "measure.previous", "action.measure.go-previous");
        this.setMenuItemTextAndAccelerator(this.next, "measure.next", "action.measure.go-next");
        this.setMenuItemTextAndAccelerator(this.addMeasure, "measure.add", "action.gui.open-measure-add-dialog");
        this.setMenuItemTextAndAccelerator(this.cleanMeasure, "measure.clean", "action.gui.open-measure-clean-dialog");
        this.setMenuItemTextAndAccelerator(this.removeMeasure, "measure.remove", "action.gui.open-measure-remove-dialog");
        this.setMenuItemTextAndAccelerator(this.copyMeasure, "measure.copy", "action.gui.open-measure-copy-dialog");
        this.setMenuItemTextAndAccelerator(this.pasteMeasure, "measure.paste", "action.gui.open-measure-paste-dialog");
    }

    public void loadIcons() {
    }
}

