/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.menu.impl;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.action.TGActionProcessorListener;
import org.herac.tuxguitar.app.view.menu.TGMenuItem;
import org.herac.tuxguitar.song.models.TGNote;

public class DynamicMenuItem
extends TGMenuItem {
    private MenuItem dynamicMenuItem;
    private Menu menu;
    private MenuItem pianoPianissimo;
    private MenuItem pianissimo;
    private MenuItem piano;
    private MenuItem mezzoPiano;
    private MenuItem mezzoForte;
    private MenuItem forte;
    private MenuItem fortissimo;
    private MenuItem forteFortissimo;

    public DynamicMenuItem(Shell shell, Menu parent, int style) {
        this.dynamicMenuItem = new MenuItem(parent, style);
        this.menu = new Menu((Decorations)shell, 4);
    }

    public void showItems() {
        this.pianoPianissimo = new MenuItem(this.menu, 32);
        this.pianoPianissimo.addSelectionListener((SelectionListener)this.createChangeVelocityAction(15));
        this.pianissimo = new MenuItem(this.menu, 32);
        this.pianissimo.addSelectionListener((SelectionListener)this.createChangeVelocityAction(31));
        this.piano = new MenuItem(this.menu, 32);
        this.piano.addSelectionListener((SelectionListener)this.createChangeVelocityAction(47));
        this.mezzoPiano = new MenuItem(this.menu, 32);
        this.mezzoPiano.addSelectionListener((SelectionListener)this.createChangeVelocityAction(63));
        this.mezzoForte = new MenuItem(this.menu, 32);
        this.mezzoForte.addSelectionListener((SelectionListener)this.createChangeVelocityAction(79));
        this.forte = new MenuItem(this.menu, 32);
        this.forte.addSelectionListener((SelectionListener)this.createChangeVelocityAction(95));
        this.fortissimo = new MenuItem(this.menu, 32);
        this.fortissimo.addSelectionListener((SelectionListener)this.createChangeVelocityAction(111));
        this.forteFortissimo = new MenuItem(this.menu, 32);
        this.forteFortissimo.addSelectionListener((SelectionListener)this.createChangeVelocityAction(127));
        this.dynamicMenuItem.setMenu(this.menu);
        this.loadIcons();
        this.loadProperties();
    }

    public void update() {
        TGNote note = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getSelectedNote();
        int velocity = note != null ? note.getVelocity() : TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getVelocity();
        boolean running = TuxGuitar.getInstance().getPlayer().isRunning();
        this.pianoPianissimo.setSelection(velocity == 15);
        this.pianoPianissimo.setEnabled(!running);
        this.pianissimo.setSelection(velocity == 31);
        this.pianissimo.setEnabled(!running);
        this.piano.setSelection(velocity == 47);
        this.piano.setEnabled(!running);
        this.mezzoPiano.setSelection(velocity == 63);
        this.mezzoPiano.setEnabled(!running);
        this.mezzoForte.setSelection(velocity == 79);
        this.mezzoForte.setEnabled(!running);
        this.forte.setSelection(velocity == 95);
        this.forte.setEnabled(!running);
        this.fortissimo.setSelection(velocity == 111);
        this.fortissimo.setEnabled(!running);
        this.forteFortissimo.setSelection(velocity == 127);
        this.forteFortissimo.setEnabled(!running);
    }

    public void loadProperties() {
        this.dynamicMenuItem.setText(TuxGuitar.getProperty("dynamic"));
        this.pianoPianissimo.setText(TuxGuitar.getProperty("dynamic.piano-pianissimo"));
        this.pianissimo.setText(TuxGuitar.getProperty("dynamic.pianissimo"));
        this.piano.setText(TuxGuitar.getProperty("dynamic.piano"));
        this.mezzoPiano.setText(TuxGuitar.getProperty("dynamic.mezzo-piano"));
        this.mezzoForte.setText(TuxGuitar.getProperty("dynamic.mezzo-forte"));
        this.forte.setText(TuxGuitar.getProperty("dynamic.forte"));
        this.fortissimo.setText(TuxGuitar.getProperty("dynamic.fortissimo"));
        this.forteFortissimo.setText(TuxGuitar.getProperty("dynamic.forte-fortissimo"));
    }

    public void loadIcons() {
    }

    public TGActionProcessorListener createChangeVelocityAction(Integer velocity) {
        TGActionProcessorListener tgActionProcessor = this.createActionProcessor("action.note.general.velocity");
        tgActionProcessor.setAttribute("velocity", velocity);
        return tgActionProcessor;
    }
}

