/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.menu.impl;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.view.menu.TGMenuItem;

public class CompositionMenuItem
extends TGMenuItem {
    private MenuItem compositionMenuItem;
    private Menu menu;
    private MenuItem timeSignature;
    private MenuItem tempo;
    private MenuItem clef;
    private MenuItem keySignature;
    private MenuItem repeatOpen;
    private MenuItem repeatClose;
    private MenuItem repeatAlternative;
    private MenuItem tripletFeel;
    private MenuItem properties;

    public CompositionMenuItem(Shell shell, Menu parent, int style) {
        this.compositionMenuItem = new MenuItem(parent, style);
        this.menu = new Menu((Decorations)shell, 4);
    }

    public void showItems() {
        this.timeSignature = new MenuItem(this.menu, 8);
        this.timeSignature.addSelectionListener((SelectionListener)this.createActionProcessor("action.gui.open-time-signature-dialog"));
        this.tempo = new MenuItem(this.menu, 8);
        this.tempo.addSelectionListener((SelectionListener)this.createActionProcessor("action.gui.open-tempo-dialog"));
        this.clef = new MenuItem(this.menu, 8);
        this.clef.addSelectionListener((SelectionListener)this.createActionProcessor("action.gui.open-clef-dialog"));
        this.keySignature = new MenuItem(this.menu, 8);
        this.keySignature.addSelectionListener((SelectionListener)this.createActionProcessor("action.gui.open-key-signature-dialog"));
        this.tripletFeel = new MenuItem(this.menu, 8);
        this.tripletFeel.addSelectionListener((SelectionListener)this.createActionProcessor("action.gui.open-triplet-feel-dialog"));
        new MenuItem(this.menu, 2);
        this.repeatOpen = new MenuItem(this.menu, 8);
        this.repeatOpen.addSelectionListener((SelectionListener)this.createActionProcessor("action.insert.open-repeat"));
        this.repeatClose = new MenuItem(this.menu, 8);
        this.repeatClose.addSelectionListener((SelectionListener)this.createActionProcessor("action.gui.open-repeat-close-dialog"));
        this.repeatAlternative = new MenuItem(this.menu, 8);
        this.repeatAlternative.addSelectionListener((SelectionListener)this.createActionProcessor("action.gui.open-repeat-alternative-dialog"));
        new MenuItem(this.menu, 2);
        this.properties = new MenuItem(this.menu, 8);
        this.properties.addSelectionListener((SelectionListener)this.createActionProcessor("action.gui.open-song-info-dialog"));
        this.compositionMenuItem.setMenu(this.menu);
        this.loadIcons();
        this.loadProperties();
    }

    public void update() {
        boolean running = TuxGuitar.getInstance().getPlayer().isRunning();
        this.timeSignature.setEnabled(!running);
        this.tempo.setEnabled(!running);
        this.clef.setEnabled(!running);
        this.keySignature.setEnabled(!running);
        this.tripletFeel.setEnabled(!running);
        this.repeatOpen.setEnabled(!running);
        this.repeatClose.setEnabled(!running);
        this.repeatAlternative.setEnabled(!running);
    }

    public void loadProperties() {
        this.setMenuItemTextAndAccelerator(this.compositionMenuItem, "composition", null);
        this.setMenuItemTextAndAccelerator(this.timeSignature, "composition.timesignature", "action.gui.open-time-signature-dialog");
        this.setMenuItemTextAndAccelerator(this.tempo, "composition.tempo", "action.gui.open-tempo-dialog");
        this.setMenuItemTextAndAccelerator(this.clef, "composition.clef", "action.gui.open-clef-dialog");
        this.setMenuItemTextAndAccelerator(this.keySignature, "composition.keysignature", "action.gui.open-key-signature-dialog");
        this.setMenuItemTextAndAccelerator(this.tripletFeel, "composition.tripletfeel", "action.gui.open-triplet-feel-dialog");
        this.setMenuItemTextAndAccelerator(this.repeatOpen, "repeat.open", "action.insert.open-repeat");
        this.setMenuItemTextAndAccelerator(this.repeatClose, "repeat.close", "action.gui.open-repeat-close-dialog");
        this.setMenuItemTextAndAccelerator(this.repeatAlternative, "repeat.alternative", "action.gui.open-repeat-alternative-dialog");
        this.setMenuItemTextAndAccelerator(this.properties, "composition.properties", "action.gui.open-song-info-dialog");
    }

    public void loadIcons() {
        this.timeSignature.setImage(TuxGuitar.getInstance().getIconManager().getCompositionTimeSignature());
        this.tempo.setImage(TuxGuitar.getInstance().getIconManager().getCompositionTempo());
        this.repeatOpen.setImage(TuxGuitar.getInstance().getIconManager().getCompositionRepeatOpen());
        this.repeatClose.setImage(TuxGuitar.getInstance().getIconManager().getCompositionRepeatClose());
        this.repeatAlternative.setImage(TuxGuitar.getInstance().getIconManager().getCompositionRepeatAlternative());
        this.properties.setImage(TuxGuitar.getInstance().getIconManager().getSongProperties());
    }
}

