/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.menu.impl;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.view.component.tab.Caret;
import org.herac.tuxguitar.app.view.menu.TGMenuItem;
import org.herac.tuxguitar.app.view.menu.impl.ChordMenuItem;
import org.herac.tuxguitar.app.view.menu.impl.DurationMenuItem;
import org.herac.tuxguitar.app.view.menu.impl.DynamicMenuItem;
import org.herac.tuxguitar.app.view.menu.impl.NoteEffectsMenuItem;
import org.herac.tuxguitar.graphics.control.TGBeatImpl;
import org.herac.tuxguitar.song.models.TGNote;

public class BeatMenuItem
extends TGMenuItem {
    private MenuItem noteMenuItem;
    private Menu menu;
    private MenuItem tiedNote;
    private MenuItem insertRestBeat;
    private MenuItem deleteNoteOrRest;
    private MenuItem cleanBeat;
    private MenuItem removeVoice;
    private MenuItem insertText;
    private MenuItem voiceAuto;
    private MenuItem voiceUp;
    private MenuItem voiceDown;
    private MenuItem strokeUp;
    private MenuItem strokeDown;
    private MenuItem shiftUp;
    private MenuItem shiftDown;
    private MenuItem semitoneUp;
    private MenuItem semitoneDown;
    private MenuItem moveBeatsLeft;
    private MenuItem moveBeatsRight;
    private MenuItem moveBeatsCustom;
    private DurationMenuItem durationMenuItem;
    private ChordMenuItem chordMenuItem;
    private NoteEffectsMenuItem effectMenuItem;
    private DynamicMenuItem dynamicMenuItem;

    public BeatMenuItem(Shell shell, Menu parent, int style) {
        this.noteMenuItem = new MenuItem(parent, style);
        this.menu = new Menu((Decorations)shell, 4);
    }

    public void showItems() {
        this.tiedNote = new MenuItem(this.menu, 32);
        this.tiedNote.addSelectionListener((SelectionListener)this.createActionProcessor("action.note.general.tied"));
        this.insertRestBeat = new MenuItem(this.menu, 8);
        this.insertRestBeat.addSelectionListener((SelectionListener)this.createActionProcessor("action.beat.general.insert-rest"));
        this.deleteNoteOrRest = new MenuItem(this.menu, 8);
        this.deleteNoteOrRest.addSelectionListener((SelectionListener)this.createActionProcessor("action.beat.general.delete-note-or-rest"));
        this.cleanBeat = new MenuItem(this.menu, 8);
        this.cleanBeat.addSelectionListener((SelectionListener)this.createActionProcessor("action.note.general.clean-beat"));
        this.removeVoice = new MenuItem(this.menu, 8);
        this.removeVoice.addSelectionListener((SelectionListener)this.createActionProcessor("action.beat.general.remove-unused-voice"));
        this.durationMenuItem = new DurationMenuItem(this.menu.getShell(), this.menu, 64);
        this.durationMenuItem.showItems();
        this.chordMenuItem = new ChordMenuItem(this.menu.getShell(), this.menu, 64);
        this.chordMenuItem.showItems();
        this.effectMenuItem = new NoteEffectsMenuItem(this.menu.getShell(), this.menu, 64);
        this.effectMenuItem.showItems();
        this.dynamicMenuItem = new DynamicMenuItem(this.menu.getShell(), this.menu, 64);
        this.dynamicMenuItem.showItems();
        new MenuItem(this.menu, 2);
        this.insertText = new MenuItem(this.menu, 8);
        this.insertText.addSelectionListener((SelectionListener)this.createActionProcessor("action.gui.open-text-dialog"));
        new MenuItem(this.menu, 2);
        this.voiceAuto = new MenuItem(this.menu, 8);
        this.voiceAuto.addSelectionListener((SelectionListener)this.createActionProcessor("action.beat.general.voice-auto"));
        this.voiceUp = new MenuItem(this.menu, 8);
        this.voiceUp.addSelectionListener((SelectionListener)this.createActionProcessor("action.beat.general.voice-up"));
        this.voiceDown = new MenuItem(this.menu, 8);
        this.voiceDown.addSelectionListener((SelectionListener)this.createActionProcessor("action.beat.general.voice-down"));
        new MenuItem(this.menu, 2);
        this.strokeUp = new MenuItem(this.menu, 32);
        this.strokeUp.addSelectionListener((SelectionListener)this.createActionProcessor("action.gui.open-stroke-up-dialog"));
        this.strokeDown = new MenuItem(this.menu, 32);
        this.strokeDown.addSelectionListener((SelectionListener)this.createActionProcessor("action.gui.open-stroke-down-dialog"));
        new MenuItem(this.menu, 2);
        this.semitoneUp = new MenuItem(this.menu, 8);
        this.semitoneUp.addSelectionListener((SelectionListener)this.createActionProcessor("action.note.general.increment-semitone"));
        this.semitoneDown = new MenuItem(this.menu, 8);
        this.semitoneDown.addSelectionListener((SelectionListener)this.createActionProcessor("action.note.general.decrement-semitone"));
        new MenuItem(this.menu, 2);
        this.shiftUp = new MenuItem(this.menu, 8);
        this.shiftUp.addSelectionListener((SelectionListener)this.createActionProcessor("action.note.general.shift-up"));
        this.shiftDown = new MenuItem(this.menu, 8);
        this.shiftDown.addSelectionListener((SelectionListener)this.createActionProcessor("action.note.general.shift-down"));
        new MenuItem(this.menu, 2);
        this.moveBeatsLeft = new MenuItem(this.menu, 8);
        this.moveBeatsLeft.addSelectionListener((SelectionListener)this.createActionProcessor("action.beat.general.move-left"));
        this.moveBeatsRight = new MenuItem(this.menu, 8);
        this.moveBeatsRight.addSelectionListener((SelectionListener)this.createActionProcessor("action.beat.general.move-right"));
        this.moveBeatsCustom = new MenuItem(this.menu, 8);
        this.moveBeatsCustom.addSelectionListener((SelectionListener)this.createActionProcessor("action.gui.open-beat-move-dialog"));
        this.noteMenuItem.setMenu(this.menu);
        this.loadIcons();
        this.loadProperties();
    }

    public void update() {
        Caret caret = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret();
        TGBeatImpl beat = caret.getSelectedBeat();
        TGNote note = caret.getSelectedNote();
        boolean restBeat = caret.isRestBeatSelected();
        boolean running = TuxGuitar.getInstance().getPlayer().isRunning();
        this.tiedNote.setEnabled(!running);
        this.tiedNote.setSelection(note != null && note.isTiedNote());
        this.insertRestBeat.setEnabled(!running);
        this.deleteNoteOrRest.setEnabled(!running);
        this.cleanBeat.setEnabled(!running);
        this.removeVoice.setEnabled(!running);
        this.voiceAuto.setEnabled(!running && !restBeat);
        this.voiceUp.setEnabled(!running && !restBeat);
        this.voiceDown.setEnabled(!running && !restBeat);
        this.strokeUp.setEnabled(!running && !restBeat);
        this.strokeUp.setSelection(beat != null && beat.getStroke().getDirection() == 1);
        this.strokeDown.setEnabled(!running && !restBeat);
        this.strokeDown.setSelection(beat != null && beat.getStroke().getDirection() == -1);
        this.semitoneUp.setEnabled(!running && note != null);
        this.semitoneDown.setEnabled(!running && note != null);
        this.shiftUp.setEnabled(!running && note != null);
        this.shiftDown.setEnabled(!running && note != null);
        this.insertText.setEnabled(!running);
        this.moveBeatsLeft.setEnabled(!running);
        this.moveBeatsRight.setEnabled(!running);
        this.moveBeatsCustom.setEnabled(!running);
        this.durationMenuItem.update();
        this.chordMenuItem.update();
        this.effectMenuItem.update();
        this.dynamicMenuItem.update();
    }

    public void loadProperties() {
        this.setMenuItemTextAndAccelerator(this.noteMenuItem, "beat", null);
        this.setMenuItemTextAndAccelerator(this.cleanBeat, "beat.clean", "action.note.general.clean-beat");
        this.setMenuItemTextAndAccelerator(this.removeVoice, "beat.voice.remove-unused", "action.beat.general.remove-unused-voice");
        this.setMenuItemTextAndAccelerator(this.tiedNote, "note.tiednote", "action.note.general.tied");
        this.setMenuItemTextAndAccelerator(this.insertRestBeat, "beat.insert-rest", "action.beat.general.insert-rest");
        this.setMenuItemTextAndAccelerator(this.deleteNoteOrRest, "beat.delete-note-or-rest", "action.beat.general.delete-note-or-rest");
        this.setMenuItemTextAndAccelerator(this.voiceAuto, "beat.voice-auto", "action.beat.general.voice-auto");
        this.setMenuItemTextAndAccelerator(this.voiceUp, "beat.voice-up", "action.beat.general.voice-up");
        this.setMenuItemTextAndAccelerator(this.voiceDown, "beat.voice-down", "action.beat.general.voice-down");
        this.setMenuItemTextAndAccelerator(this.strokeUp, "beat.stroke-up", "action.gui.open-stroke-up-dialog");
        this.setMenuItemTextAndAccelerator(this.strokeDown, "beat.stroke-down", "action.gui.open-stroke-down-dialog");
        this.setMenuItemTextAndAccelerator(this.semitoneUp, "note.semitone-up", "action.note.general.increment-semitone");
        this.setMenuItemTextAndAccelerator(this.semitoneDown, "note.semitone-down", "action.note.general.decrement-semitone");
        this.setMenuItemTextAndAccelerator(this.shiftUp, "note.shift-up", "action.note.general.shift-up");
        this.setMenuItemTextAndAccelerator(this.shiftDown, "note.shift-down", "action.note.general.shift-down");
        this.setMenuItemTextAndAccelerator(this.insertText, "text.insert", "action.gui.open-text-dialog");
        this.setMenuItemTextAndAccelerator(this.moveBeatsLeft, "beat.move-left", "action.beat.general.move-left");
        this.setMenuItemTextAndAccelerator(this.moveBeatsRight, "beat.move-right", "action.beat.general.move-right");
        this.setMenuItemTextAndAccelerator(this.moveBeatsCustom, "beat.move-custom", "action.gui.open-beat-move-dialog");
        this.durationMenuItem.loadProperties();
        this.chordMenuItem.loadProperties();
        this.effectMenuItem.loadProperties();
        this.dynamicMenuItem.loadProperties();
    }

    public void loadIcons() {
        this.tiedNote.setImage(TuxGuitar.getInstance().getIconManager().getNoteTied());
    }
}

