/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.main;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.action.TGActionProcessorListener;
import org.herac.tuxguitar.app.system.config.TGConfigManager;
import org.herac.tuxguitar.app.system.icons.TGIconManager;
import org.herac.tuxguitar.app.view.component.tabfolder.TGTabFolder;
import org.herac.tuxguitar.app.view.component.table.TGTableViewer;
import org.herac.tuxguitar.app.view.dialog.fretboard.TGFretBoardEditor;
import org.herac.tuxguitar.app.view.toolbar.TGToolBar;
import org.herac.tuxguitar.app.view.util.TGCursorController;
import org.herac.tuxguitar.app.view.util.TGSyncProcess;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGExpressionResolver;
import org.herac.tuxguitar.util.TGSynchronizer;
import org.herac.tuxguitar.util.singleton.TGSingletonFactory;
import org.herac.tuxguitar.util.singleton.TGSingletonUtil;

public class TGWindow
implements TGEventListener {
    public static final int MARGIN_WIDTH = 5;
    private TGContext context;
    private TGSyncProcess loadTitleProcess;
    private TGCursorController cursorController;
    private Shell shell;
    private Sash sash;
    private Composite sashComposite;

    public TGWindow(TGContext context) {
        this.context = context;
        this.createSyncProcesses();
    }

    public void open() {
        if (this.shell != null) {
            this.shell.open();
        }
    }

    public void createShell(Display display) {
        this.shell = new Shell(display);
        this.shell.setLayout((Layout)this.createShellLayout());
        this.shell.addShellListener((ShellListener)new TGActionProcessorListener(this.context, "action.system.dispose"));
        this.createShellComposites();
        this.createShellListeners();
        this.loadIcons();
    }

    private void createShellComposites() {
        TGToolBar tgToolBar = TGToolBar.getInstance(this.context);
        tgToolBar.createToolBar((Composite)this.shell);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)tgToolBar.getControl(), 0);
        data.bottom = new FormAttachment(100, 0);
        this.sashComposite = new Composite((Composite)this.shell, 0);
        this.sashComposite.setLayout((Layout)new FormLayout());
        this.sashComposite.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, -150);
        data.height = 5;
        this.sash = new Sash(this.sashComposite, 256);
        this.sash.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment((Control)this.sash, 0);
        TGTabFolder tgTabFolder = TGTabFolder.getInstance(this.context);
        tgTabFolder.init(this.sashComposite);
        tgTabFolder.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.sash, 0);
        data.bottom = new FormAttachment(100, 0);
        TGTableViewer tgTableViewer = TGTableViewer.getInstance(this.context);
        tgTableViewer.init(this.sashComposite);
        tgTableViewer.getComposite().setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.sashComposite, 0);
        data.bottom = new FormAttachment(100, 0);
        Composite footer = new Composite((Composite)this.shell, 0);
        footer.setLayout((Layout)new FormLayout());
        footer.setLayoutData((Object)data);
        TGFretBoardEditor tgFretBoardEditor = TGFretBoardEditor.getInstance(this.context);
        tgFretBoardEditor.showFretBoard(footer);
        this.sash.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                TGWindow.this.sashComposite.layout(true, true);
            }
        });
        this.sash.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int maximumHeight = ((TGWindow)TGWindow.this).sashComposite.getBounds().height - ((TGWindow)TGWindow.this).sash.getBounds().height;
                int height = maximumHeight - event.y;
                height = Math.max(height, 0);
                height = Math.min(height, maximumHeight);
                ((FormData)((TGWindow)TGWindow.this).sash.getLayoutData()).bottom = new FormAttachment(100, -height);
            }
        });
        this.sash.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                TGWindow.this.sash.setCursor(TGWindow.this.sash.getDisplay().getSystemCursor(7));
            }
        });
        this.sashComposite.addListener(11, new Listener(){

            public void handleEvent(Event arg0) {
                FormData data = (FormData)TGWindow.this.sash.getLayoutData();
                int height = -data.bottom.offset;
                int maximumHeight = ((TGWindow)TGWindow.this).sashComposite.getBounds().height - ((TGWindow)TGWindow.this).sash.getBounds().height;
                if (height > maximumHeight) {
                    data.bottom = new FormAttachment(100, -maximumHeight);
                }
            }
        });
    }

    private void createShellListeners() {
        TGIconManager tgIconManager = TGIconManager.getInstance(this.context);
        tgIconManager.addLoader(this);
    }

    private FormLayout createShellLayout() {
        FormLayout layout = new FormLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        return layout;
    }

    public void setTableHeight(int value) {
        TGTableViewer tgTableViewer = TGTableViewer.getInstance(this.context);
        int offset = ((FormData)tgTableViewer.getComposite().getLayoutData()).top.offset;
        int sashHeight = this.sash.getBounds().height;
        int maximumHeight = this.sashComposite.getBounds().height - sashHeight;
        int height = value + offset;
        height = Math.max(height, 0);
        height = Math.min(height, maximumHeight);
        ((FormData)this.sash.getLayoutData()).bottom = new FormAttachment(100, -height);
        this.sashComposite.layout(true, true);
    }

    public void updateShellFooter(int offset, int minimumWith, int minimumHeight) {
        FormData data = (FormData)this.sashComposite.getLayoutData();
        data.bottom.offset = -offset;
        this.getShell().setMinimumSize(Math.max(640, minimumWith), Math.max(480, minimumHeight));
        this.getShell().layout(true, true);
        this.getShell().redraw();
    }

    public void loadDefaultCursor() {
        this.loadCursor(0);
    }

    public void loadBusyCursor() {
        this.loadCursor(1);
    }

    public void loadCursor(int cursorStyle) {
        if (!this.isDisposed()) {
            if (this.cursorController == null || !this.cursorController.isControlling((Control)this.shell)) {
                this.cursorController = new TGCursorController(this.context, (Control)this.shell);
            }
            this.cursorController.loadCursor(cursorStyle);
        }
    }

    public void moveToTop() {
        if (!this.isDisposed()) {
            this.shell.setMinimized(false);
            this.shell.forceActive();
        }
    }

    public boolean isDisposed() {
        return this.shell == null || this.shell.isDisposed();
    }

    public Shell getShell() {
        return this.shell;
    }

    public Composite getSashComposite() {
        return this.sashComposite;
    }

    public void loadTitle() {
        this.loadTitleProcess.process();
    }

    public void loadTitleInCurrentThread() {
        if (!this.isDisposed()) {
            String titleLayout = TGConfigManager.getInstance(this.context).getStringValue("window.title");
            String title = TGExpressionResolver.getInstance((TGContext)this.context).resolve(titleLayout);
            this.getShell().setText(title != null ? title : "TuxGuitar");
        }
    }

    public void loadIcons() {
        if (!this.isDisposed()) {
            this.getShell().setImage(TGIconManager.getInstance(this.context).getAppIcon());
            this.getShell().layout(true);
        }
    }

    public void createSyncProcesses() {
        this.loadTitleProcess = new TGSyncProcess(this.context, new Runnable(){

            public void run() {
                TGWindow.this.loadTitleInCurrentThread();
            }
        });
    }

    public void processEvent(final TGEvent event) {
        TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){

            public void run() {
                if ("ui-icon".equals(event.getEventType())) {
                    TGWindow.this.loadIcons();
                }
            }
        });
    }

    public static TGWindow getInstance(TGContext context) {
        return (TGWindow)TGSingletonUtil.getInstance((TGContext)context, (String)TGWindow.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGWindow>(){

            public TGWindow createInstance(TGContext context) {
                return new TGWindow(context);
            }
        });
    }
}

