/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.tripletfeel;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.util.TGContext;

public class TGTripletFeelDialog {
    public void show(final TGViewContext context) {
        Shell parent = (Shell)context.getAttribute("parent");
        final TGSong song = (TGSong)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
        final TGMeasureHeader header = (TGMeasureHeader)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_HEADER);
        final Shell dialog = DialogUtils.newDialog(parent, 67680);
        dialog.setLayout((Layout)new GridLayout());
        dialog.setText(TuxGuitar.getProperty("composition.tripletfeel"));
        dialog.setMinimumSize(300, 0);
        Group tripletFeel = new Group((Composite)dialog, 16);
        tripletFeel.setLayout((Layout)new GridLayout());
        tripletFeel.setLayoutData((Object)new GridData(4, 4, true, true));
        tripletFeel.setText(TuxGuitar.getProperty("composition.tripletfeel"));
        final Button tripletFeelNone = new Button((Composite)tripletFeel, 16);
        tripletFeelNone.setText(TuxGuitar.getProperty("composition.tripletfeel.none"));
        tripletFeelNone.setSelection(header.getTripletFeel() == 1);
        final Button tripletFeelEighth = new Button((Composite)tripletFeel, 16);
        tripletFeelEighth.setText(TuxGuitar.getProperty("composition.tripletfeel.eighth"));
        tripletFeelEighth.setSelection(header.getTripletFeel() == 2);
        final Button tripletFeelSixteenth = new Button((Composite)tripletFeel, 16);
        tripletFeelSixteenth.setText(TuxGuitar.getProperty("composition.tripletfeel.sixteenth"));
        tripletFeelSixteenth.setSelection(header.getTripletFeel() == 3);
        Group check = new Group((Composite)dialog, 16);
        check.setLayout((Layout)new GridLayout());
        check.setLayoutData((Object)new GridData(4, 4, true, true));
        check.setText(TuxGuitar.getProperty("options"));
        final Button toEnd = new Button((Composite)check, 32);
        toEnd.setText(TuxGuitar.getProperty("composition.tripletfeel.to-the-end"));
        toEnd.setSelection(true);
        Composite buttons = new Composite((Composite)dialog, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        Button buttonOk = new Button(buttons, 8);
        buttonOk.setText(TuxGuitar.getProperty("ok"));
        buttonOk.setLayoutData((Object)this.getButtonData());
        buttonOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TGTripletFeelDialog.this.changeTripletFeel(context.getContext(), song, header, TGTripletFeelDialog.this.parseTripletFeel(tripletFeelNone, tripletFeelEighth, tripletFeelSixteenth), toEnd.getSelection());
                dialog.dispose();
            }
        });
        Button buttonCancel = new Button(buttons, 8);
        buttonCancel.setLayoutData((Object)this.getButtonData());
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
            }
        });
        dialog.setDefaultButton(buttonOk);
        DialogUtils.openDialog(dialog, 10);
    }

    private GridData getButtonData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    protected int parseTripletFeel(Button tripletFeelNone, Button tripletFeelEighth, Button tripletFeelSixteenth) {
        if (tripletFeelNone.getSelection()) {
            return 1;
        }
        if (tripletFeelEighth.getSelection()) {
            return 2;
        }
        if (tripletFeelSixteenth.getSelection()) {
            return 3;
        }
        return 1;
    }

    public void changeTripletFeel(TGContext context, TGSong song, TGMeasureHeader header, Integer tripletFeel, Boolean applyToEnd) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(context, "action.composition.change-triplet-feel");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, (Object)song);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_HEADER, (Object)header);
        tgActionProcessor.setAttribute("tripletFeel", (Object)tripletFeel);
        tgActionProcessor.setAttribute("applyToEnd", (Object)applyToEnd);
        tgActionProcessor.processOnNewThread();
    }
}

