/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.settings.items;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.TGFileUtils;
import org.herac.tuxguitar.app.view.dialog.settings.TGSettingsEditor;
import org.herac.tuxguitar.app.view.dialog.settings.items.Option;
import org.herac.tuxguitar.resource.TGResourceManager;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGSynchronizer;

public class SkinOption
extends Option {
    protected boolean initialized = false;
    protected List<SkinInfo> skins;
    protected Combo combo;
    protected Label nameLabel;
    protected Label authorLabel;
    protected Label versionLabel;
    protected Label descriptionLabel;
    protected Image preview;
    protected Composite previewArea;

    public SkinOption(TGSettingsEditor configEditor, ToolBar toolBar, Composite parent) {
        super(configEditor, toolBar, parent, TuxGuitar.getProperty("settings.config.skin"), 4, 4);
    }

    public void createOption() {
        this.getToolItem().setText(TuxGuitar.getProperty("settings.config.skin"));
        this.getToolItem().setImage(TuxGuitar.getInstance().getIconManager().getOptionSkin());
        this.getToolItem().addSelectionListener((SelectionListener)this);
        this.showLabel(this.getComposite(), 4, 128, true, false, 16576, 1, 0, TuxGuitar.getProperty("settings.config.skin.choose"));
        Composite composite = new Composite(this.getComposite(), 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)this.getTabbedData(4, 4, true, false));
        this.combo = new Combo(composite, 12);
        this.combo.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite skinInfoComposite = new Composite(this.getComposite(), 0);
        skinInfoComposite.setLayout((Layout)new GridLayout(2, false));
        skinInfoComposite.setLayoutData((Object)this.getTabbedData(4, 4, true, false));
        this.showLabel(skinInfoComposite, 4, 0x1000000, false, true, 16576, 1, 0, TuxGuitar.getProperty("name") + ": ");
        this.nameLabel = this.showLabel(skinInfoComposite, 4, 0x1000000, 16576, 0, 0, "");
        this.showLabel(skinInfoComposite, 4, 0x1000000, false, true, 16576, 1, 0, TuxGuitar.getProperty("author") + ": ");
        this.authorLabel = this.showLabel(skinInfoComposite, 4, 0x1000000, 16576, 0, 0, "");
        this.showLabel(skinInfoComposite, 4, 0x1000000, false, true, 16576, 1, 0, TuxGuitar.getProperty("version") + ": ");
        this.versionLabel = this.showLabel(skinInfoComposite, 4, 0x1000000, 16576, 0, 0, "");
        this.showLabel(skinInfoComposite, 4, 0x1000000, false, true, 16576, 1, 0, TuxGuitar.getProperty("description") + ": ");
        this.descriptionLabel = this.showLabel(skinInfoComposite, 4, 0x1000000, 16576, 0, 0, "");
        Composite skinPreviewComposite = new Composite(this.getComposite(), 0);
        skinPreviewComposite.setLayout((Layout)new GridLayout());
        skinPreviewComposite.setLayoutData((Object)this.getTabbedData(4, 4, true, true));
        this.previewArea = new Composite(skinPreviewComposite, 0x20000000);
        this.previewArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.previewArea.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (SkinOption.this.preview != null && !SkinOption.this.preview.isDisposed()) {
                    e.gc.drawImage(SkinOption.this.preview, 0, 0);
                }
            }
        });
        this.loadConfig();
    }

    protected void loadConfig() {
        new Thread(new Runnable(){

            public void run() {
                SkinOption.this.skins = new ArrayList<SkinInfo>();
                String[] skinNames = TGFileUtils.getFileNames(SkinOption.this.getViewContext().getContext(), "skins");
                if (skinNames != null) {
                    for (int i = 0; i < skinNames.length; ++i) {
                        Properties properties = new Properties();
                        try {
                            InputStream skinInfo = TGResourceManager.getInstance((TGContext)SkinOption.this.getViewContext().getContext()).getResourceAsStream("skins/" + skinNames[i] + "/skin.properties");
                            if (skinInfo != null) {
                                properties.load(skinInfo);
                            }
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                        SkinInfo info = new SkinInfo(skinNames[i]);
                        info.setName(properties.getProperty("name", info.getSkin()));
                        info.setAuthor(properties.getProperty("author", "Not available."));
                        info.setVersion(properties.getProperty("version", "Not available."));
                        info.setDescription(properties.getProperty("description", "Not available."));
                        info.setDate(properties.getProperty("date", null));
                        info.setPreview(properties.getProperty("preview", null));
                        SkinOption.this.skins.add(info);
                    }
                }
                TGSynchronizer.getInstance((TGContext)SkinOption.this.getViewContext().getContext()).executeLater(new Runnable(){

                    public void run() {
                        if (!SkinOption.this.isDisposed()) {
                            for (int i = 0; i < SkinOption.this.skins.size(); ++i) {
                                SkinInfo info = SkinOption.this.skins.get(i);
                                SkinOption.this.combo.add(info.getName());
                                if (!info.getSkin().equals(SkinOption.this.getConfig().getStringValue("skin"))) continue;
                                SkinOption.this.combo.select(i);
                            }
                            SkinOption.this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                public void widgetSelected(SelectionEvent e) {
                                    int selection = SkinOption.this.combo.getSelectionIndex();
                                    if (selection >= 0 && selection < SkinOption.this.skins.size()) {
                                        SkinOption.this.showSkinInfo(SkinOption.this.skins.get(selection));
                                    }
                                }
                            });
                            int selection = SkinOption.this.combo.getSelectionIndex();
                            if (selection >= 0 && selection < SkinOption.this.skins.size()) {
                                SkinOption.this.showSkinInfo(SkinOption.this.skins.get(selection));
                            }
                            SkinOption.this.initialized = true;
                            SkinOption.this.pack();
                        }
                    }
                });
            }
        }).start();
    }

    protected void showSkinInfo(final SkinInfo info) {
        this.loadCursor(1);
        TGSynchronizer.getInstance((TGContext)this.getViewContext().getContext()).executeLater(new Runnable(){

            public void run() {
                if (!SkinOption.this.isDisposed()) {
                    SkinOption.this.disposePreview();
                    SkinOption.this.nameLabel.setText(info.getName());
                    SkinOption.this.authorLabel.setText(info.getAuthor());
                    SkinOption.this.descriptionLabel.setText(info.getDescription());
                    SkinOption.this.versionLabel.setText(info.getDate() == null ? info.getVersion() : info.getVersion() + " (" + info.getDate() + ")");
                    if (info.getPreview() != null) {
                        SkinOption.this.preview = TGFileUtils.loadImage(SkinOption.this.getViewContext().getContext(), info.getSkin(), info.getPreview());
                    }
                    SkinOption.this.previewArea.redraw();
                    SkinOption.this.loadCursor(0);
                }
            }
        });
    }

    public void updateConfig() {
        int selection;
        if (this.initialized && (selection = this.combo.getSelectionIndex()) >= 0 && selection < this.skins.size()) {
            SkinInfo info = this.skins.get(selection);
            this.getConfig().setValue("skin", info.getSkin());
        }
    }

    public void updateDefaults() {
        if (this.initialized) {
            this.getConfig().setValue("skin", this.getDefaults().getValue("skin"));
        }
    }

    public void dispose() {
        this.disposePreview();
    }

    public void disposePreview() {
        if (this.preview != null && !this.preview.isDisposed()) {
            this.preview.dispose();
        }
    }

    private class SkinInfo {
        private String skin;
        private String name;
        private String date;
        private String author;
        private String version;
        private String description;
        private String preview;

        public SkinInfo(String skin) {
            this.skin = skin;
        }

        public String getAuthor() {
            return this.author;
        }

        public void setAuthor(String author) {
            this.author = author;
        }

        public String getDate() {
            return this.date;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getSkin() {
            return this.skin;
        }

        public String getPreview() {
            return this.preview;
        }

        public void setPreview(String preview) {
            this.preview = preview;
        }
    }
}

