/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.printer;

import java.util.List;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.graphics.TGImageImpl;
import org.herac.tuxguitar.app.graphics.TGPainterImpl;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.graphics.TGRectangle;

public class TGPrintPreviewDialog {
    private static final int SCROLL_INCREMENT = 50;
    private static final int MARGIN_TOP = 20;
    private static final int MARGIN_BOTTOM = 40;
    private static final int MARGIN_LEFT = 50;
    private static final int MARGIN_RIGHT = 20;
    public static final String ATTRIBUTE_PAGES = TGPrintPreviewDialog.class.getName() + "-pages";
    public static final String ATTRIBUTE_BOUNDS = TGPrintPreviewDialog.class.getName() + "-bounds";
    private TGViewContext context;
    private Shell dialog;
    private Composite previewComposite;
    private Composite pageComposite;
    private Text currentText;
    private Button previous;
    private Button next;
    private TGRectangle bounds;
    private List<Image> pages;
    private int currentPage;

    public TGPrintPreviewDialog(TGViewContext context) {
        this.context = context;
        this.pages = (List)context.getAttribute(ATTRIBUTE_PAGES);
        this.bounds = (TGRectangle)context.getAttribute(ATTRIBUTE_BOUNDS);
    }

    public void show() {
        Shell parent = (Shell)this.context.getAttribute("parent");
        this.dialog = DialogUtils.newDialog(parent, 66800);
        this.dialog.setLayout((Layout)new GridLayout());
        this.dialog.setText(TuxGuitar.getProperty("print.preview"));
        this.initToolBar();
        this.initPreviewComposite();
        this.changePage(0);
        DisposeListener disposeListener = (DisposeListener)this.context.getAttribute(TGViewContext.ATTRIBUTE_DISPOSE_LISTENER);
        if (disposeListener != null) {
            this.dialog.addDisposeListener(disposeListener);
        }
        DialogUtils.openDialog(this.dialog, 16);
    }

    private void initToolBar() {
        Composite composite = new Composite((Composite)this.dialog, 0);
        composite.setLayout((Layout)new GridLayout(5, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.previous = new Button(composite, 16388);
        this.currentText = new Text(composite, 2048);
        this.currentText.setLayoutData((Object)new GridData(25, -1));
        this.next = new Button(composite, 131076);
        Label maxPages = new Label(composite, 0);
        Button close = new Button(composite, 8);
        close.setLayoutData((Object)this.getButtonData());
        this.currentText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13) {
                    try {
                        Integer number = new Integer(TGPrintPreviewDialog.this.currentText.getText());
                        TGPrintPreviewDialog.this.changePage(number - 1);
                    }
                    catch (NumberFormatException exception) {
                        TGPrintPreviewDialog.this.changePage(TGPrintPreviewDialog.this.currentPage);
                    }
                }
            }
        });
        this.previous.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TGPrintPreviewDialog.this.currentPage >= 0) {
                    TGPrintPreviewDialog.this.changePage(TGPrintPreviewDialog.this.currentPage - 1);
                }
            }
        });
        this.next.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TGPrintPreviewDialog.this.currentPage >= 0) {
                    TGPrintPreviewDialog.this.changePage(TGPrintPreviewDialog.this.currentPage + 1);
                }
            }
        });
        close.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGPrintPreviewDialog.this.dialog.dispose();
            }
        });
        maxPages.setText(TuxGuitar.getProperty("print.preview.page-of") + " " + this.pages.size());
        close.setText(TuxGuitar.getProperty("close"));
    }

    private GridData getButtonData() {
        GridData data = new GridData(131072, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    private void initPreviewComposite() {
        this.previewComposite = new Composite((Composite)this.dialog, 2560);
        this.previewComposite.setLayout((Layout)new GridLayout());
        this.previewComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.previewComposite.setBackground(this.previewComposite.getDisplay().getSystemColor(15));
        this.previewComposite.setFocus();
        this.pageComposite = new Composite(this.previewComposite, 0x20000800);
        this.pageComposite.setLayout((Layout)new GridLayout());
        this.pageComposite.setBackground(this.previewComposite.getDisplay().getSystemColor(1));
        this.pageComposite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (TGPrintPreviewDialog.this.currentPage >= 0) {
                    TGPrintPreviewDialog.this.updateScroll();
                    int vScroll = TGPrintPreviewDialog.this.previewComposite.getVerticalBar().getSelection();
                    TGImageImpl page = new TGImageImpl((Image)TGPrintPreviewDialog.this.pages.get(TGPrintPreviewDialog.this.currentPage));
                    TGPainterImpl painter = new TGPainterImpl(e.gc);
                    painter.drawImage(page, 50.0f, 20 - vScroll);
                }
            }
        });
        GridData pageData = new GridData();
        pageData.horizontalAlignment = 0x1000000;
        pageData.verticalAlignment = 0x1000000;
        pageData.grabExcessHorizontalSpace = true;
        pageData.grabExcessVerticalSpace = true;
        pageData.widthHint = Math.round(this.bounds.getWidth() - this.bounds.getX() + 70.0f);
        pageData.heightHint = Math.round(this.bounds.getHeight() - this.bounds.getY() + 60.0f);
        this.pageComposite.setLayoutData((Object)pageData);
        this.previewComposite.getVerticalBar().setIncrement(50);
        this.previewComposite.getVerticalBar().addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TGPrintPreviewDialog.this.pageComposite.redraw();
            }
        });
    }

    protected void updateScroll() {
        ScrollBar vBar = this.previewComposite.getVerticalBar();
        Rectangle client = this.pageComposite.getClientArea();
        vBar.setMaximum(Math.round(this.bounds.getHeight() - this.bounds.getY()) + 60);
        vBar.setThumb(Math.min(Math.round(this.bounds.getHeight() - this.bounds.getY()) + 60, client.height));
    }

    protected void changePage(int index) {
        if (!this.pages.isEmpty()) {
            int pageCount = this.pages.size();
            if (index >= 0 && index < pageCount) {
                this.currentPage = index;
                this.currentText.setText(Integer.toString(index + 1));
                this.pageComposite.redraw();
            } else if (this.currentPage >= 0 && this.currentPage < pageCount) {
                this.currentText.setText(Integer.toString(this.currentPage + 1));
            }
            this.previous.setEnabled(this.currentPage > 0);
            this.next.setEnabled(this.currentPage + 1 < pageCount);
            this.previewComposite.getVerticalBar().setSelection(0);
            this.previewComposite.setFocus();
        } else {
            this.currentText.setEnabled(false);
            this.previous.setEnabled(false);
            this.next.setEnabled(false);
        }
    }

    public TGViewContext getContext() {
        return this.context;
    }
}

