/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.piano;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.system.config.TGConfigDefaults;
import org.herac.tuxguitar.app.system.config.TGConfigManager;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.util.properties.TGProperties;

public class TGPianoConfig {
    private static final int MINIMUM_CONTROL_WIDTH = 180;
    private static final int MINIMUM_BUTTON_WIDTH = 80;
    private static final int MINIMUM_BUTTON_HEIGHT = 25;
    private Color colorNatural;
    private Color colorNotNatural;
    private Color colorNote;
    private Color colorScale;

    public Color getColorNatural() {
        return this.colorNatural;
    }

    public Color getColorNotNatural() {
        return this.colorNotNatural;
    }

    public Color getColorNote() {
        return this.colorNote;
    }

    public Color getColorScale() {
        return this.colorScale;
    }

    public void load() {
        Display display = TuxGuitar.getInstance().getDisplay();
        TGConfigManager config = TuxGuitar.getInstance().getConfig();
        this.colorNatural = new Color((Device)display, config.getRGBConfigValue("piano.color.natural-key"));
        this.colorNotNatural = new Color((Device)display, config.getRGBConfigValue("piano.color.not-natural-key"));
        this.colorNote = new Color((Device)display, config.getRGBConfigValue("piano.color.note"));
        this.colorScale = new Color((Device)display, config.getRGBConfigValue("piano.color.scale"));
    }

    public void defaults() {
        TGConfigManager config = TuxGuitar.getInstance().getConfig();
        TGProperties defaults = TGConfigDefaults.createDefaults();
        config.setValue("piano.color.natural-key", defaults.getValue("piano.color.natural-key"));
        config.setValue("piano.color.not-natural-key", defaults.getValue("piano.color.not-natural-key"));
        config.setValue("piano.color.note", defaults.getValue("piano.color.note"));
        config.setValue("piano.color.scale", defaults.getValue("piano.color.scale"));
    }

    public void save(RGB rgbNatural, RGB rgbNotNatural, RGB rgbNote, RGB rgbScale) {
        TGConfigManager config = TuxGuitar.getInstance().getConfig();
        config.setValue("piano.color.natural-key", rgbNatural);
        config.setValue("piano.color.not-natural-key", rgbNotNatural);
        config.setValue("piano.color.note", rgbNote);
        config.setValue("piano.color.scale", rgbScale);
    }

    public void dispose() {
        this.colorNatural.dispose();
        this.colorNotNatural.dispose();
        this.colorNote.dispose();
        this.colorScale.dispose();
    }

    public void configure(Shell shell) {
        final Shell dialog = DialogUtils.newDialog(shell, 67680);
        dialog.setLayout((Layout)new GridLayout());
        dialog.setText(TuxGuitar.getProperty("piano.settings"));
        Group group = new Group((Composite)dialog, 16);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty("piano.settings"));
        final RGB rgbNatural = this.getColorChooser((Composite)group, TuxGuitar.getProperty("piano.natural-key-color"), this.colorNatural.getRGB());
        final RGB rgbNotNatural = this.getColorChooser((Composite)group, TuxGuitar.getProperty("piano.not-natural-key-color"), this.colorNotNatural.getRGB());
        final RGB rgbNote = this.getColorChooser((Composite)group, TuxGuitar.getProperty("piano.note-color"), this.colorNote.getRGB());
        final RGB rgbScale = this.getColorChooser((Composite)group, TuxGuitar.getProperty("piano.scale-note-color"), this.colorScale.getRGB());
        Composite buttons = new Composite((Composite)dialog, 0);
        buttons.setLayout((Layout)new GridLayout(3, false));
        buttons.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        Button buttonDefaults = new Button(buttons, 8);
        buttonDefaults.setText(TuxGuitar.getProperty("defaults"));
        buttonDefaults.setLayoutData((Object)this.getButtonData());
        buttonDefaults.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
                TGPianoConfig.this.defaults();
                TGPianoConfig.this.applyChanges();
            }
        });
        Button buttonOK = new Button(buttons, 8);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setLayoutData((Object)this.getButtonData());
        buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
                TGPianoConfig.this.save(rgbNatural, rgbNotNatural, rgbNote, rgbScale);
                TGPianoConfig.this.applyChanges();
            }
        });
        Button buttonCancel = new Button(buttons, 8);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.setLayoutData((Object)this.getButtonData());
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
            }
        });
        dialog.setDefaultButton(buttonOK);
        DialogUtils.openDialog(dialog, 10);
    }

    protected void applyChanges() {
        this.dispose();
        this.load();
    }

    private RGB getColorChooser(Composite parent, String title, RGB rgb) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
        label.setText(title);
        ButtonColor button = new ButtonColor(parent, 8, TuxGuitar.getProperty("choose"));
        button.setLayoutData(this.getAlignmentData(180, 4));
        button.loadColor(rgb);
        return button.getValue();
    }

    private GridData getAlignmentData(int minimumWidth, int horizontalAlignment) {
        GridData data = new GridData();
        data.minimumWidth = minimumWidth;
        data.horizontalAlignment = horizontalAlignment;
        data.verticalAlignment = -1;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        return data;
    }

    protected GridData getButtonData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    private class ButtonColor {
        protected Button button;
        protected Color color;
        protected RGB value = new RGB(0, 0, 0);

        public ButtonColor(Composite parent, int style, String text) {
            this.button = new Button(parent, style);
            this.button.setText(text);
            this.addListeners();
        }

        protected void setLayoutData(Object layoutData) {
            this.button.setLayoutData(layoutData);
        }

        protected void loadColor(RGB rgb) {
            this.value.red = rgb.red;
            this.value.green = rgb.green;
            this.value.blue = rgb.blue;
            Color color = new Color((Device)this.button.getDisplay(), this.value);
            this.button.setForeground(color);
            this.disposeColor();
            this.color = color;
        }

        protected void disposeColor() {
            if (this.color != null && !this.color.isDisposed()) {
                this.color.dispose();
                this.color = null;
            }
        }

        private void addListeners() {
            this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ColorDialog dlg = new ColorDialog(ButtonColor.this.button.getShell());
                    dlg.setRGB(ButtonColor.this.value);
                    dlg.setText(TuxGuitar.getProperty("choose-color"));
                    RGB result = dlg.open();
                    if (result != null) {
                        ButtonColor.this.loadColor(result);
                    }
                }
            });
            this.button.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ButtonColor.this.disposeColor();
                }
            });
        }

        protected RGB getValue() {
            return this.value;
        }
    }
}

